/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils.awtree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.Toolbar;
import org.antlr.works.utils.TreeUtilities;
import org.antlr.works.utils.awtree.AWTreeGraphView;
import org.antlr.works.utils.awtree.AWTreeModel;
import org.antlr.works.utils.awtree.AWTreeNode;
import org.antlr.works.utils.awtree.AWTreePanelDelegate;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.swing.XJRollOverButton;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class AWTreePanel
extends JPanel {
    protected Component listViewComponent;
    protected Component graphViewComponent;
    protected JTree tree;
    protected DefaultTreeModel jTreeModel;
    protected AWTreeGraphView treeGraphView;
    protected JScrollPane graphScrollPane;
    protected AWTreePanelDelegate delegate;

    public AWTreePanel(DefaultTreeModel treeModel) {
        super(new BorderLayout());
        this.jTreeModel = treeModel;
        this.tree = new JTree(treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
        treeRenderer.setClosedIcon(null);
        treeRenderer.setLeafIcon(null);
        treeRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(treeRenderer);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = AWTreePanel.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = AWTreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2) {
                    AWTreePanel.this.displayNodeInfo(selPath.getLastPathComponent());
                    e.consume();
                }
            }
        });
        this.listViewComponent = this.createListView();
        this.graphViewComponent = this.createGraphView();
        this.add(this.graphViewComponent, "Center");
    }

    public void setDelegate(AWTreePanelDelegate delegate) {
        this.delegate = delegate;
    }

    public void setAWTreeModel(AWTreeModel model) {
        this.treeGraphView.setModel(model);
    }

    public Component createListView() {
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setWheelScrollingEnabled(true);
        scrollPane.setBackground(Color.white);
        Toolbar box = Toolbar.createHorizontalToolbar();
        box.addElement(this.createExpandAllButton());
        box.addElement(this.createCollapseAllButton());
        box.add(Box.createHorizontalGlue());
        box.addElement(this.createDisplayAsGraphButton());
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)box, "South");
        return panel;
    }

    public JButton createDisplayAsGraphButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconGraph());
        button.setToolTipText("Display as Graph");
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AWTreePanel.this.toggleGraph();
            }
        });
        return button;
    }

    public JButton createExpandAllButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconExpandAll());
        button.setToolTipText("Expand All");
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TreeUtilities.expandAll(AWTreePanel.this.tree);
            }
        });
        return button;
    }

    public JButton createCollapseAllButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconCollapseAll());
        button.setToolTipText("Collapse All");
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TreeUtilities.collapseAll(AWTreePanel.this.tree);
            }
        });
        return button;
    }

    public Component createGraphView() {
        JPanel panel = new JPanel(new BorderLayout());
        this.treeGraphView = new AWTreeGraphView(this);
        this.treeGraphView.setAutoAdjustSize(true);
        this.treeGraphView.setBackground(Color.white);
        this.treeGraphView.setDrawBorder(false);
        ParseTreeMouseAdapter adapter = new ParseTreeMouseAdapter();
        this.treeGraphView.addMouseListener(adapter);
        this.treeGraphView.addMouseMotionListener(adapter);
        this.graphScrollPane = new JScrollPane(this.treeGraphView);
        this.graphScrollPane.setWheelScrollingEnabled(true);
        Toolbar box = Toolbar.createHorizontalToolbar();
        box.addElement(new JLabel("Zoom"));
        box.addElement(this.createZoomSlider());
        box.add(Box.createHorizontalGlue());
        box.addElement(this.createDisplayAsListButton());
        panel.add((Component)this.graphScrollPane, "Center");
        panel.add((Component)box, "South");
        return panel;
    }

    public JButton createDisplayAsListButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconListTree());
        button.setToolTipText("Display as List");
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AWTreePanel.this.toggleGraph();
            }
        });
        return button;
    }

    public JSlider createZoomSlider() {
        JSlider slider = new JSlider();
        slider.setFocusable(false);
        slider.setMinimum(1);
        slider.setMaximum(200);
        slider.setValue(100);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                JSlider slider = (JSlider)event.getSource();
                AWTreePanel.this.treeGraphView.setZoom((float)slider.getValue() / 100.0f);
                AWTreePanel.this.treeGraphView.repaint();
                AWTreePanel.this.treeGraphView.revalidate();
            }
        });
        return slider;
    }

    public void setRootVisible(boolean flag) {
        this.tree.setRootVisible(flag);
    }

    public void setRoot(TreeNode node) {
        this.jTreeModel.setRoot(node);
        this.treeGraphView.setRoot(node);
    }

    public Object getRoot() {
        return this.jTreeModel.getRoot();
    }

    public AWTreeGraphView getGraphView() {
        return this.treeGraphView;
    }

    public void clear() {
        this.treeGraphView.clear();
    }

    public void refresh() {
        this.jTreeModel.reload();
        this.treeGraphView.refresh();
    }

    public void toggleGraph() {
        if (this.getComponent(0) == this.listViewComponent) {
            this.remove(this.listViewComponent);
            this.add(this.graphViewComponent, "Center");
        } else {
            this.remove(this.graphViewComponent);
            this.add(this.listViewComponent, "Center");
        }
        this.repaint();
        this.revalidate();
    }

    public void selectNode(TreeNode node) {
        TreePath path = new TreePath(this.jTreeModel.getPathToRoot(node));
        this.tree.scrollPathToVisible(path);
        this.tree.setSelectionPath(path);
        this.treeGraphView.highlightNode(node);
    }

    public void scrollNodeToVisible(TreeNode node) {
        if (node == null) {
            return;
        }
        this.tree.scrollPathToVisible(new TreePath(this.jTreeModel.getPathToRoot(node)));
        this.treeGraphView.scrollNodeToVisible(node);
    }

    public void displayNodeInfo(Object node) {
        AWTreeNode n = (AWTreeNode)node;
        XJAlert.display(this, "Node info", n.getInfoString());
    }

    public JPopupMenu getContextualMenu() {
        if (this.delegate != null) {
            return this.delegate.awTreeGetContextualMenu();
        }
        return null;
    }

    protected class ParseTreeMouseAdapter
    implements MouseListener,
    MouseMotionListener {
        public Point origin;
        public Rectangle r;
        public boolean dragging;

        protected ParseTreeMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            GElement elem = AWTreePanel.this.treeGraphView.getElementAtMousePosition(e);
            if (elem != null && elem instanceof AWTreeGraphView.GElementNode) {
                boolean shiftKey;
                TreeNode node = AWTreePanel.this.treeGraphView.getTreeNodeForElement((AWTreeGraphView.GElementNode)elem);
                if (node == null) {
                    return;
                }
                boolean bl = shiftKey = (e.getModifiersEx() & 0x40) == 64;
                if (AWTreePanel.this.delegate != null) {
                    AWTreePanel.this.delegate.awTreeDidSelectTreeNode(node, shiftKey);
                }
                AWTreePanel.this.selectNode(node);
            }
            this.origin = SwingUtilities.convertPoint(AWTreePanel.this.treeGraphView, e.getPoint(), null);
            this.r = AWTreePanel.this.treeGraphView.getVisibleRect();
            this.dragging = true;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            this.dragging = false;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.dragging) {
                return;
            }
            Point p = SwingUtilities.convertPoint(AWTreePanel.this.treeGraphView, e.getPoint(), null);
            Rectangle r1 = new Rectangle(this.r);
            r1.x -= p.x - this.origin.x;
            r1.y -= p.y - this.origin.y;
            AWTreePanel.this.treeGraphView.scrollRectToVisible(r1);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

