/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.path;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.path.GPath;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPathGroup
extends GObject {
    public static final String NOTIF_CURRENT_PATH_DID_CHANGE = "NOTIF_CURRENT_PATH_DID_CHANGE";
    public static int DEFAULT_PATH_WIDTH = 1;
    protected List<GPath> graphicPaths = new ArrayList<GPath>();
    protected int selectedPathIndex = 0;
    protected boolean showRuleLinks = true;

    public void addPath(GPath path) {
        this.graphicPaths.add(path);
    }

    public List<GPath> getPaths() {
        return this.graphicPaths;
    }

    public GPath getPath(int index) {
        return this.graphicPaths.get(index);
    }

    public int getNumberOfPaths() {
        return this.graphicPaths.size();
    }

    public void setSelectedPath(int index) {
        this.selectedPathIndex = index < 0 ? this.graphicPaths.size() - 1 : (index >= this.graphicPaths.size() ? 0 : index);
        this.updateShowRuleLinks();
        XJNotificationCenter.defaultCenter().postNotification(this, NOTIF_CURRENT_PATH_DID_CHANGE);
    }

    public void setPathVisible(int index, boolean flag) {
        this.getPath(index).setVisible(flag);
    }

    public boolean isPathVisible(int index) {
        return this.getPath(index).isVisible();
    }

    public void makeSureCurrentPathIsVisible() {
        if (this.getCurrentPath().isVisible()) {
            return;
        }
        for (GPath path : this.graphicPaths) {
            if (!path.isVisible()) continue;
            this.setSelectedPath(this.graphicPaths.indexOf(path));
            break;
        }
    }

    public void selectPreviousPath() {
        this.setSelectedPath(this.selectedPathIndex - 1);
    }

    public void selectNextPath() {
        this.setSelectedPath(this.selectedPathIndex + 1);
    }

    public GPath getCurrentPath() {
        if (this.graphicPaths.size() > 0) {
            return this.graphicPaths.get(this.selectedPathIndex);
        }
        return null;
    }

    public int getSelectedPathIndex() {
        return this.selectedPathIndex;
    }

    @Override
    public void setContext(GContext context) {
        super.setContext(context);
        for (GPath path : this.graphicPaths) {
            path.setContext(context);
        }
    }

    public void toggleShowRuleLinks() {
        this.showRuleLinks = !this.showRuleLinks;
        this.updateShowRuleLinks();
    }

    public void updateShowRuleLinks() {
        for (GPath path : this.graphicPaths) {
            path.setShowRuleLinks(this.showRuleLinks);
        }
    }

    public void selectPath(Point p) {
        List<GPath> paths = this.getPathsAtPoint(p);
        if (paths.isEmpty()) {
            return;
        }
        GPath selectPath = paths.get(0);
        if (paths.size() > 1) {
            int i = 1;
            while (!selectPath.isVisible() && i < paths.size()) {
                selectPath = paths.get(i++);
            }
        }
        this.setSelectedPath(this.graphicPaths.indexOf(selectPath));
        this.getCurrentPath().setMaxWidth();
        this.context.repaint();
    }

    public List<GPath> getPathsAtPoint(Point p) {
        ArrayList<GPath> paths = new ArrayList<GPath>();
        for (GPath path : this.graphicPaths) {
            if (!path.containsPoint(p)) continue;
            paths.add(path);
        }
        return paths;
    }

    @Override
    public void draw() {
        GPath currentPath = this.getCurrentPath();
        for (GPath path : this.graphicPaths) {
            if (path != currentPath) {
                path.deselectElement();
            } else {
                currentPath.selectElement();
            }
            if (!path.isVisible() || path == currentPath) continue;
            path.draw(DEFAULT_PATH_WIDTH, null);
        }
        if (currentPath.isVisible()) {
            currentPath.draw(DEFAULT_PATH_WIDTH, null);
        }
    }

    public void drawSelectedElement() {
        if (this.getCurrentPath().isVisible() && this.getCurrentPath().isSelectable()) {
            this.getCurrentPath().drawSelectedElement();
        }
    }
}

