/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.shape.SLabel;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class GElementCircle
extends GElement
implements XJXMLSerializable {
    public static final int DEFAULT_RADIUS = 20;
    protected double radius = 20.0;

    public void setRadius(double radius) {
        this.radius = radius;
        this.elementDimensionDidChange();
    }

    public double getRadius() {
        return this.radius;
    }

    public void updateAnchors() {
        this.setAnchor("CENTER", this.position, Anchor2D.DIRECTION_FREE);
        this.setAnchor("TOP", this.position.add(new Vector2D(0.0, -this.radius)), Anchor2D.DIRECTION_TOP);
        this.setAnchor("BOTTOM", this.position.add(new Vector2D(0.0, this.radius)), Anchor2D.DIRECTION_BOTTOM);
        this.setAnchor("LEFT", this.position.add(new Vector2D(-this.radius, 0.0)), Anchor2D.DIRECTION_LEFT);
        this.setAnchor("RIGHT", this.position.add(new Vector2D(this.radius, 0.0)), Anchor2D.DIRECTION_RIGHT);
    }

    public double getDefaultAnchorOffset(String anchorKey) {
        if (anchorKey != null && anchorKey.equals("CENTER")) {
            return this.radius;
        }
        return 0.0;
    }

    public Rect getFrame() {
        double x = this.getPositionX() - this.radius;
        double y = this.getPositionY() - this.radius;
        double dx = this.radius * 2.0;
        double dy = this.radius * 2.0;
        return new Rect(x, y, dx, dy);
    }

    public boolean isInside(Point p) {
        return Math.abs(p.getX() - this.getPositionX()) < this.radius && Math.abs(p.getY() - this.getPositionY()) < this.radius;
    }

    public void draw(Graphics2D g) {
        if (this.isVisibleInClip(g)) {
            if (this.labelVisible) {
                g.setColor(this.labelColor);
                SLabel.drawCenteredString(this.getLabel(), (int)this.getPositionX(), (int)this.getPositionY(), g);
            }
            if (this.color != null) {
                g.setColor(this.color);
            } else {
                g.setColor(Color.black);
            }
            g.setStroke(this.strokeSize);
            this.drawShape(g);
            g.setStroke(this.strokeNormal);
        }
    }

    public void drawShape(Graphics2D g) {
        super.drawShape(g);
        int x = (int)(this.getPositionX() - this.radius);
        int y = (int)(this.getPositionY() - this.radius);
        g.drawOval(x, y, (int)(this.radius * 2.0), (int)(this.radius * 2.0));
    }
}

