/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.antlr.Tool;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATEPanelDelegate;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEThread;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.GrammarDebuggerDelegate;
import org.antlr.works.components.GrammarMemoryStatus;
import org.antlr.works.components.GrammarStatusBar;
import org.antlr.works.components.GrammarWindowMenu;
import org.antlr.works.components.GrammarWindowToolbar;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.editor.ConsoleTab;
import org.antlr.works.editor.EditorAnalysisManager;
import org.antlr.works.editor.EditorFoldingManager;
import org.antlr.works.editor.EditorGutterColumnManager;
import org.antlr.works.editor.EditorIdeas;
import org.antlr.works.editor.EditorInspector;
import org.antlr.works.editor.EditorOverlayManager;
import org.antlr.works.editor.EditorPersistence;
import org.antlr.works.editor.EditorRules;
import org.antlr.works.editor.EditorTips;
import org.antlr.works.editor.GrammarEditorKit;
import org.antlr.works.editor.GrammarWindowTab;
import org.antlr.works.editor.InspectorDelegate;
import org.antlr.works.editor.completion.AutoCompletionMenu;
import org.antlr.works.editor.completion.AutoCompletionMenuDelegate;
import org.antlr.works.editor.navigation.GoToHistory;
import org.antlr.works.editor.navigation.GoToRule;
import org.antlr.works.editor.navigation.GoToRuleDelegate;
import org.antlr.works.find.FindAndReplace;
import org.antlr.works.find.FindAndReplaceDelegate;
import org.antlr.works.find.Usages;
import org.antlr.works.grammar.GrammarAutoIndent;
import org.antlr.works.grammar.decisiondfa.DecisionDFAEngine;
import org.antlr.works.grammar.element.ElementImport;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.element.Jumpable;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.grammar.engine.GrammarEngineDelegate;
import org.antlr.works.grammar.engine.GrammarEngineImpl;
import org.antlr.works.interpreter.InterpreterTab;
import org.antlr.works.menu.ActionRefactor;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.menu.DebugMenu;
import org.antlr.works.menu.FindMenuDelegate;
import org.antlr.works.menu.GoToMenu;
import org.antlr.works.menu.GoToMenuDelegate;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.Utils;
import org.antlr.works.visualization.SyntaxDiagramTab;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.text.XJURLLabel;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarWindow
extends XJWindow
implements AutoCompletionMenuDelegate,
ATEPanelDelegate,
XJUndoDelegate,
InspectorDelegate,
GrammarEngineDelegate,
FindAndReplaceDelegate,
GoToRuleDelegate,
GoToMenuDelegate,
FindMenuDelegate,
XJNotificationObserver {
    private static final int CLOSING_INDEX_LIMIT = 4;
    private final Map<Integer, GrammarWindowTab> indexToEditorTab = new HashMap<Integer, GrammarWindowTab>();
    private final List<GrammarWindowTab> tabs = new ArrayList<GrammarWindowTab>();
    public final SyntaxDiagramTab syntaxDiagramTab;
    public final InterpreterTab interpreterTab;
    private final DebuggerTab debuggerTab;
    public final ConsoleTab consoleTab;
    private final GrammarWindowMenu menu;
    private final GrammarWindowToolbar toolbar;
    private final GrammarEngine grammarEngine;
    public final EditorRules editorRules;
    private final FindAndReplace findAndReplace;
    public final DecisionDFAEngine decisionDFAEngine;
    private final GoToRule goToRule;
    public final GoToHistory goToHistory;
    private ConsoleStatus consoleStatus;
    private GrammarMemoryStatus memoryStatus;
    public AutoCompletionMenu autoCompletionMenu;
    private EditorGutterColumnManager gutterColumnManager;
    private EditorFoldingManager foldingManager;
    private EditorOverlayManager underlyingManager;
    private EditorAnalysisManager analysisManager;
    public final EditorIdeas editorIdeas;
    public final EditorTips editorTips;
    public final EditorInspector editorInspector;
    private final EditorPersistence editorPersistence;
    private GrammarEditorKit editorKit;
    public ATEPanel textEditor;
    private MouseListener ml;
    private ChangeListener cl;
    private JSplitPane horizontalSplit;
    private JTabbedPane bottomTab;
    private Box statusBar;
    private JLabel infoLabel;
    private JLabel cursorLabel;
    private JLabel writableLabel;
    private XJDialogProgress progress;
    private int debuggerLocation = -1;
    private Jumpable highlightedReference;
    private boolean windowFirstDisplay = true;
    private String lastSelectedRule;
    private AfterParseOperations afterParserOp;

    public GrammarWindow() {
        this.createTextEditor();
        this.createStatusBar();
        this.resetAutoCompletion();
        this.syntaxDiagramTab = new SyntaxDiagramTab(this);
        this.interpreterTab = new InterpreterTab(this);
        this.debuggerTab = new DebuggerTab(new GrammarDebuggerDelegate(this));
        this.consoleTab = new ConsoleTab(this);
        this.consoleTab.makeCurrent();
        this.menu = new GrammarWindowMenu(this);
        this.toolbar = new GrammarWindowToolbar(this);
        this.afterParserOp = new AfterParseOperations();
        this.grammarEngine = new GrammarEngineImpl(this);
        this.decisionDFAEngine = new DecisionDFAEngine(this);
        this.goToRule = new GoToRule(this, this, this.getTextPane());
        this.goToHistory = new GoToHistory();
        this.findAndReplace = new FindAndReplace(this);
        this.editorIdeas = new EditorIdeas(this);
        this.editorTips = new EditorTips(this);
        this.editorInspector = new EditorInspector(this.grammarEngine, this.decisionDFAEngine, this);
        this.editorPersistence = new EditorPersistence(this);
        this.editorRules = new EditorRules(this);
        this.textEditor.setParserEngine(this.grammarEngine.getSyntaxEngine());
        this.editorRules.setKeyBindings(this.textEditor.getKeyBindings());
    }

    @Override
    public void awake() {
        super.awake();
        this.debuggerTab.awake();
        this.interpreterTab.awake();
        this.menu.awake();
        this.toolbar.awake();
        this.editorIdeas.awake();
        this.editorTips.awake();
        this.assemble();
        this.applyPrefs();
    }

    public void assemble() {
        this.bottomTab = new JTabbedPane();
        this.bottomTab.setTabPlacement(3);
        this.bottomTab.addTab("Syntax Diagram", this.syntaxDiagramTab.getTabComponent());
        this.bottomTab.addTab("Interpreter", this.interpreterTab.getTabComponent());
        this.bottomTab.addTab("Console", this.consoleTab.getTabComponent());
        this.bottomTab.addTab("Debugger", this.debuggerTab.getTabComponent());
        this.ml = new BottomTabbedPaneMouseListener();
        this.bottomTab.addMouseListener(this.ml);
        this.cl = new BottomTabbedPaneChangeListener();
        this.bottomTab.addChangeListener(this.cl);
        JSplitPane verticalSplit = new JSplitPane();
        verticalSplit.setBorder(null);
        verticalSplit.setOrientation(1);
        verticalSplit.setLeftComponent(this.editorRules.getComponent());
        verticalSplit.setRightComponent(this.textEditor);
        verticalSplit.setContinuousLayout(true);
        verticalSplit.setOneTouchExpandable(true);
        verticalSplit.setResizeWeight(0.2);
        this.horizontalSplit = new JSplitPane();
        this.horizontalSplit.setBorder(null);
        this.horizontalSplit.setOrientation(0);
        this.horizontalSplit.setTopComponent(verticalSplit);
        this.horizontalSplit.setBottomComponent(this.bottomTab);
        this.horizontalSplit.setContinuousLayout(true);
        this.horizontalSplit.setOneTouchExpandable(true);
        this.horizontalSplit.setResizeWeight(0.7);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.addComponentListener(new MainPanelComponentListener());
        mainPanel.setBorder(null);
        mainPanel.add((Component)this.toolbar.getToolbar(), "North");
        mainPanel.add((Component)this.horizontalSplit, "Center");
        mainPanel.add((Component)this.statusBar, "South");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STARTED");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STOPPED");
        this.registerUndo(this, this.getTextPane());
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    private void createTextEditor() {
        this.textEditor = new ATEPanel(this);
        this.editorKit = new GrammarEditorKit(this);
        this.textEditor.setEditorKit(this.editorKit);
        this.textEditor.setSyntaxColoring(true);
        this.textEditor.setDelegate(this);
        this.gutterColumnManager = new EditorGutterColumnManager(this);
        this.textEditor.setGutterColumnManager(this.gutterColumnManager);
        this.foldingManager = new EditorFoldingManager(this);
        this.textEditor.setFoldingManager(this.foldingManager);
        this.underlyingManager = new EditorOverlayManager(this);
        this.textEditor.setUnderlyingManager(this.underlyingManager);
        this.analysisManager = new EditorAnalysisManager(this);
        this.textEditor.setAnalysisManager(this.analysisManager);
    }

    private void createStatusBar() {
        this.infoLabel = new JLabel();
        this.cursorLabel = new JLabel();
        this.writableLabel = new JLabel();
        this.consoleStatus = new ConsoleStatus();
        this.memoryStatus = new GrammarMemoryStatus();
        this.statusBar = new GrammarStatusBar();
        this.statusBar.setPreferredSize(new Dimension(0, 30));
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.infoLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(GrammarWindow.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.cursorLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(GrammarWindow.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.writableLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(GrammarWindow.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.consoleStatus.getPanel());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(GrammarWindow.createSeparator());
        this.statusBar.add(Box.createHorizontalGlue());
        this.statusBar.add(this.memoryStatus);
    }

    private void resetAutoCompletion() {
        if (this.autoCompletionMenu != null) {
            this.autoCompletionMenu.close();
        }
        this.autoCompletionMenu = new AutoCompletionMenu(this, this.getTextPane(), this);
    }

    private static JComponent createSeparator() {
        JSeparator s = new JSeparator(1);
        Dimension d = s.getMaximumSize();
        d.width = 2;
        s.setMaximumSize(d);
        return s;
    }

    @Override
    public boolean close(boolean force) {
        if (!super.close(force)) {
            return false;
        }
        XJNotificationCenter.defaultCenter().removeObserver(this);
        this.goToRule.close();
        this.autoCompletionMenu.close();
        this.decisionDFAEngine.close();
        this.interpreterTab.close();
        this.consoleTab.close();
        this.editorIdeas.close();
        this.editorTips.close();
        this.editorInspector.close();
        this.editorPersistence.close();
        this.grammarEngine.close();
        this.editorRules.close();
        this.syntaxDiagramTab.close();
        this.afterParserOp.stop();
        this.afterParserOp = null;
        this.gutterColumnManager.close();
        this.foldingManager.close();
        this.underlyingManager.close();
        this.analysisManager.close();
        this.textEditor.close();
        this.editorKit.close();
        this.consoleStatus = null;
        this.memoryStatus.close();
        this.memoryStatus = null;
        this.menu.close();
        this.debuggerTab.close();
        this.toolbar.close();
        this.bottomTab.removeMouseListener(this.ml);
        this.bottomTab.removeChangeListener(this.cl);
        this.ml = null;
        this.cl = null;
        return true;
    }

    @Override
    public String autosaveName() {
        if (AWPrefs.getRestoreWindows()) {
            return this.getDocument().getDocumentName();
        }
        return null;
    }

    @Override
    public void setDefaultSize() {
        if (XJApplication.shared().useDesktopMode()) {
            super.setDefaultSize();
            return;
        }
        Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        r.width = (int)((double)r.width * 0.8);
        r.height = (int)((double)r.height * 0.8);
        this.setPreferredSize(r.getSize());
    }

    @Override
    public void windowActivated() {
        for (GrammarWindowTab et : this.tabs) {
            et.editorActivated();
        }
        this.componentActivated();
        super.windowActivated();
    }

    @Override
    public void windowDocumentPathDidChange(XJDocument doc) {
        this.componentDocumentContentChanged();
    }

    @Override
    public void becomingVisibleForTheFirstTime() {
        this.componentDidAwake();
        this.debuggerTab.componentShouldLayout(this.getSize());
    }

    @Override
    public void customizeFileMenu(XJMenu menu) {
        this.menu.customizeFileMenu(menu);
    }

    @Override
    public void customizeMenuBar(XJMainMenuBar menubar) {
        this.menu.customizeMenuBar(menubar);
    }

    @Override
    public void menuItemState(XJMenuItem item) {
        this.menu.menuItemState(item);
    }

    @Override
    public void handleMenuSelected(XJMenu menu) {
        this.menu.handleMenuSelected(menu);
    }

    public SyntaxDiagramTab getSyntaxDiagramTab() {
        return this.syntaxDiagramTab;
    }

    public InterpreterTab getInterpreterTab() {
        return this.interpreterTab;
    }

    public ConsoleTab getConsoleTab() {
        return this.consoleTab;
    }

    public GrammarWindowTab getSelectedTab() {
        int index = this.bottomTab.getSelectedIndex();
        switch (index) {
            case 0: {
                return this.getSyntaxDiagramTab();
            }
            case 1: {
                return this.getInterpreterTab();
            }
            case 2: {
                return this.getConsoleTab();
            }
            case 3: {
                return this.debuggerTab;
            }
        }
        return this.indexToEditorTab.get(index);
    }

    public void addTab(GrammarWindowTab tab) {
        int index = this.getSimilarTab(tab);
        if (index == -1) {
            this.tabs.add(tab);
            this.bottomTab.add(tab.getTabName(), tab.getTabComponent());
            index = this.bottomTab.getTabCount() - 1;
        } else {
            this.tabs.remove(index);
            this.tabs.add(index, tab);
            this.bottomTab.removeTabAt(index + 4);
            this.bottomTab.insertTab(tab.getTabName(), null, tab.getTabComponent(), null, index + 4);
        }
        this.indexToEditorTab.put(index, tab);
        this.selectTab(tab.getTabComponent());
    }

    private void selectTab(Component c) {
        if (this.bottomTab.getSelectedComponent() != c) {
            this.bottomTab.setSelectedComponent(c);
            this.refreshMainMenuBar();
        }
        this.makeBottomTabVisible();
    }

    private int getSimilarTab(GrammarWindowTab tab) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            GrammarWindowTab t = this.tabs.get(i);
            if (!t.getTabName().equals(tab.getTabName())) continue;
            return i;
        }
        return -1;
    }

    private void closeTab(int index) {
        if (index < 4) {
            return;
        }
        this.tabs.remove(index - 4);
        this.bottomTab.removeTabAt(index);
    }

    private void makeBottomTabVisible() {
        if (this.horizontalSplit.getBottomComponent().getHeight() == 0) {
            this.horizontalSplit.setDividerLocation(this.horizontalSplit.getLastDividerLocation());
        }
    }

    public boolean documentWillSave() {
        AWPrefs.setLastSavedDocument(this.getFilePath());
        if (!this.isFileWritable()) {
            XJAlert.display(this.getJavaContainer(), "Cannot Save", "This file cannot be saved. Check the file permission on the disk and try again.");
            return false;
        }
        return true;
    }

    public DebuggerTab getDebuggerTab() {
        return this.debuggerTab;
    }

    public DebugMenu getDebugMenu() {
        return this.menu.getDebugMenu();
    }

    public ActionRefactor getActionRefactor() {
        return this.menu.getActionRefactor();
    }

    public GoToMenu getGoToMenu() {
        return this.menu.getGoToMenu();
    }

    public void applyPrefs() {
        this.afterParserOp.setDefaultThreshold(AWPrefs.getParserDelay());
        this.textEditor.setFoldingEnabled(AWPrefs.getFoldingEnabled());
        this.textEditor.setLineNumberEnabled(AWPrefs.getLineNumberEnabled());
        this.textEditor.setHighlightCursorLine(AWPrefs.getHighlightCursorEnabled());
        this.textEditor.refresh();
        this.resetAutoCompletion();
        this.applyFont();
    }

    public void applyFont() {
        this.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
    }

    @Override
    public ATETextPane getTextPane() {
        return this.textEditor.getTextPane();
    }

    @Override
    public ATEPanel getTextEditor() {
        return this.textEditor;
    }

    @Override
    public void gotoToRule(String grammar, String name) {
        if (grammar.equals(this.grammarEngine.getGrammarName())) {
            this.gotoToRule(name);
        }
    }

    private void gotoToRule(String name) {
        int index = this.grammarEngine.getFirstDeclarationPosition(name);
        if (index != -1) {
            this.setCaretPosition(index);
        }
    }

    public void toggleSyntaxColoring() {
        StatisticsAW.shared().recordEvent(120);
        this.textEditor.toggleSyntaxColoring();
    }

    public boolean isSyntaxColored() {
        return this.textEditor.isSyntaxColoring();
    }

    public void toggleRulesSorting() {
        StatisticsAW.shared().recordEvent(123);
        this.editorRules.toggleSorting();
        this.interpreterTab.setRules(this.getNaturalRules());
    }

    public boolean isRulesSorted() {
        return this.editorRules.isSorted();
    }

    public void toggleSyntaxDiagram() {
        StatisticsAW.shared().recordEvent(121);
        this.syntaxDiagramTab.setEnable(!this.syntaxDiagramTab.isEnabled());
        if (this.syntaxDiagramTab.isEnabled()) {
            this.syntaxDiagramTab.setText(this.getText(), this.getFileName());
        }
        this.updateVisualization(false);
    }

    public boolean isSyntaxDiagramDisplayed() {
        return this.syntaxDiagramTab.isEnabled();
    }

    public void toggleIdeas() {
        StatisticsAW.shared().recordEvent(122);
        this.editorIdeas.toggleEnabled();
    }

    public boolean isIdeasEnabled() {
        return this.editorIdeas.isEnabled();
    }

    public void changeUpdate() {
        this.ateChangeUpdate(-1, -1, false);
    }

    public void beginGroupChange(String name) {
        this.disableTextPane(false);
        this.beginTextPaneUndoGroup(name);
    }

    public void endGroupChange() {
        this.endTextPaneUndoGroup();
        this.enableTextPane(false);
        this.textEditor.parse();
        this.changeDone();
    }

    public void enableTextPane(boolean undo) {
        this.textEditor.setEnableRecordChange(true);
        if (undo) {
            this.enableTextPaneUndo();
        }
    }

    public void disableTextPane(boolean undo) {
        this.textEditor.setEnableRecordChange(false);
        if (undo) {
            this.disableTextPaneUndo();
        }
    }

    public void beginTextPaneUndoGroup(String name) {
        XJUndo undo = this.getUndo(this.getTextPane());
        if (undo != null) {
            undo.beginUndoGroup(name);
        }
    }

    public void endTextPaneUndoGroup() {
        XJUndo undo = this.getUndo(this.getTextPane());
        if (undo != null) {
            undo.endUndoGroup();
        }
    }

    public void enableTextPaneUndo() {
        XJUndo undo = this.getUndo(this.getTextPane());
        if (undo != null) {
            undo.enableUndo();
        }
    }

    public void disableTextPaneUndo() {
        XJUndo undo = this.getUndo(this.getTextPane());
        if (undo != null) {
            undo.disableUndo();
        }
    }

    @Override
    public void undoManagerWillUndo(boolean redo) {
    }

    @Override
    public void undoManagerDidUndo(boolean redo) {
        this.changeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadText(String text) {
        this.disableTextPaneUndo();
        try {
            this.textEditor.loadText(text);
            this.grammarChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.enableTextPaneUndo();
        }
    }

    @Override
    public synchronized void setText(String text) {
        this.textEditor.setText(text);
        this.grammarChanged();
        this.textEditor.parse();
        this.changeDone();
    }

    @Override
    public synchronized String getText() {
        return this.getTextPane().getText();
    }

    @Override
    public String getGrammarFileName() {
        String fileName = this.getFileName();
        return fileName == null ? "<notsaved>" : fileName;
    }

    @Override
    public String getGrammarText() {
        return this.getText();
    }

    @Override
    public void reportError(String error) {
        this.getConsoleTab().println(error, 2);
    }

    @Override
    public void reportError(Exception e) {
        this.getConsoleTab().println(e);
    }

    @Override
    public Tool getANTLRTool() {
        String[] params = AWPrefs.getANTLR3Options();
        if (this.getOutputPath() != null) {
            File output = new File(this.getOutputPath());
            if (!output.exists()) {
                output.mkdirs();
            }
            params = this.getFileFolder() != null ? Utils.concat(params, new String[]{"-o", output.getAbsolutePath(), "-lib", this.getFileFolder()}) : Utils.concat(params, new String[]{"-o", output.getAbsolutePath()});
        }
        if (params.length > 0) {
            return new Tool(params);
        }
        return new Tool();
    }

    @Override
    public void engineAnalyzeCompleted() {
        this.syntaxDiagramTab.clearCacheGraphs();
        this.editorRules.refreshRules();
        if (!this.syntaxDiagramTab.update()) {
            this.updateVisualization(true);
        }
        this.updateInformation();
    }

    @Override
    public void createFile(String name) {
    }

    @Override
    public void createRuleAtIndex(boolean lexer, String name, String content) {
        this.getActionRefactor().createRuleAtIndex(lexer, name, content);
    }

    @Override
    public void deleteRuleAtCurrentPosition() {
        this.getActionRefactor().deleteRuleAtIndex(this.getCaretPosition());
    }

    @Override
    public void removeLeftRecursion() {
        this.getActionRefactor().removeLeftRecursion();
    }

    @Override
    public void convertLiteralsToSingleQuote() {
        this.getActionRefactor().convertLiteralsToSingleQuote();
    }

    @Override
    public void replaceText(int leftIndex, int rightIndex, String text) {
        this.textEditor.replaceText(leftIndex, rightIndex, text);
    }

    @Override
    public void selectTextRange(int start, int end) {
        this.textEditor.selectTextRange(start, end);
    }

    public void setDebuggerLocation(int index) {
        this.debuggerLocation = index;
        if (index != -1) {
            this.textEditor.getTextPane().setCaretPosition(index);
        }
    }

    public int getDebuggerLocation() {
        return this.debuggerLocation;
    }

    public int getSelectionLeftIndexOnTokenBoundary() {
        ATEToken t = this.getTokenAtPosition(this.getTextPane().getSelectionStart(), true);
        if (t == null) {
            return -1;
        }
        return t.getStartIndex();
    }

    public int getSelectionRightIndexOnTokenBoundary() {
        ATEToken t = this.getTokenAtPosition(this.getTextPane().getSelectionEnd(), false);
        if (t == null) {
            return -1;
        }
        return t.getEndIndex();
    }

    public synchronized boolean isFileWritable() {
        String path = this.getFilePath();
        if (path == null) {
            return true;
        }
        File f = new File(path);
        return !f.exists() || f.canWrite();
    }

    public synchronized boolean isFileExists() {
        String path = this.getFilePath();
        if (path == null) {
            return false;
        }
        File f = new File(path);
        return f.exists();
    }

    public synchronized String getFileFolder() {
        return XJUtils.getPathByDeletingLastComponent(this.getFilePath());
    }

    @Override
    public String getTokenVocabFile(String tokenVocabName) {
        String filePath = this.getFileFolder();
        if (filePath == null) {
            return null;
        }
        String path = XJUtils.concatPath(filePath, tokenVocabName);
        if (new File(path).exists()) {
            return path;
        }
        path = XJUtils.concatPath(this.getOutputPath(), tokenVocabName);
        if (new File(path).exists()) {
            return path;
        }
        return null;
    }

    public synchronized String getFilePath() {
        return this.getDocument().getDocumentPath();
    }

    @Override
    public synchronized String getFileName() {
        return this.getDocument().getDocumentName();
    }

    public String getOutputPath() {
        File outputPath = new File(AWPrefs.getOutputPath());
        if (outputPath.isAbsolute()) {
            return outputPath.getAbsolutePath();
        }
        if (this.getFilePath() == null) {
            return null;
        }
        return XJUtils.concatPath(XJUtils.getPathByDeletingLastComponent(this.getFilePath()), outputPath.getPath());
    }

    @Override
    public GrammarEngine getGrammarEngine() {
        return this.grammarEngine;
    }

    public List<ElementRule> getRules() {
        return this.editorRules.getRules();
    }

    public List<ElementRule> getSortedRules() {
        return this.editorRules.getSortedRules();
    }

    public List<ElementRule> getNaturalRules() {
        return this.editorRules.isSorted() ? this.editorRules.getSortedRules() : this.editorRules.getRules();
    }

    @Override
    public EditorRules getEditorRules() {
        return this.editorRules;
    }

    @Override
    public void addUsagesTab(Usages usage) {
        this.addTab(usage);
    }

    @Override
    public List<ATEToken> getTokens() {
        return this.textEditor.getTokens();
    }

    @Override
    public List<ATELine> getLines() {
        return this.textEditor.getLines();
    }

    @Override
    public void goToHistoryRememberCurrentPosition() {
        this.goToHistory.addPosition(this.getCaretPosition());
        this.getMainMenuBar().refresh();
    }

    public ElementReference getCurrentReference() {
        return this.getReferenceAtPosition(this.getCaretPosition());
    }

    public ElementReference getReferenceAtPosition(int pos) {
        for (ElementReference ref : this.grammarEngine.getReferences()) {
            if (!ref.containsIndex(pos)) continue;
            return ref;
        }
        return null;
    }

    public ElementImport getImportAtPosition(int pos) {
        for (ElementImport element : this.grammarEngine.getImports()) {
            if (!element.containsIndex(pos)) continue;
            return element;
        }
        return null;
    }

    @Override
    public ATEToken getCurrentToken() {
        return this.getTokenAtPosition(this.getCaretPosition(), false);
    }

    public ATEToken getTokenAtPosition(int pos, boolean fromRight) {
        List<ATEToken> tokens = this.getTokens();
        if (tokens == null) {
            return null;
        }
        if (fromRight) {
            for (int i = tokens.size() - 1; i >= 0; --i) {
                ATEToken token = tokens.get(i);
                if (!token.containsIndex(pos)) continue;
                return token;
            }
        } else {
            for (ATEToken token : tokens) {
                if (!token.containsIndex(pos)) continue;
                return token;
            }
        }
        return null;
    }

    public ElementRule getCurrentRule() {
        return this.editorRules.getEnclosingRuleAtPosition(this.getCaretPosition());
    }

    @Override
    public void setCaretPosition(int position) {
        this.setCaretPosition(position, AWPrefs.getSmoothScrolling());
    }

    private void setCaretPosition(int position, boolean animate) {
        ElementRule rule = this.editorRules.getEnclosingRuleAtPosition(position);
        if (rule != null && !rule.isExpanded()) {
            this.foldingManager.toggleFolding(rule);
        }
        this.textEditor.setCaretPosition(position, true, animate);
    }

    @Override
    public int getCaretPosition() {
        return this.textEditor.getCaretPosition();
    }

    public void updateVisualization(boolean immediate) {
        if (this.syntaxDiagramTab.isEnabled()) {
            ElementRule r = this.editorRules.getEnclosingRuleAtPosition(this.getCaretPosition());
            if (r == null) {
                this.syntaxDiagramTab.setPlaceholder("Select a rule to display its syntax diagram");
            } else {
                if (r.hasErrors() && r.needsToBuildErrors()) {
                    this.grammarEngine.computeRuleErrors(r);
                    try {
                        this.syntaxDiagramTab.createGraphsForRule(r);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.syntaxDiagramTab.setRule(r, immediate);
            }
        } else {
            this.syntaxDiagramTab.setPlaceholder("Syntax Diagram Disabled");
        }
    }

    public void updateInformation() {
        String t;
        int size = this.grammarEngine.getNumberOfRules();
        switch (size) {
            case 0: {
                t = "No rules";
                break;
            }
            case 1: {
                t = "One rule";
                break;
            }
            default: {
                t = size + " rules";
            }
        }
        int warnings = this.grammarEngine.getNumberOfErrors();
        if (warnings > 0) {
            t = t + " (" + warnings + " warning" + (warnings > 0 ? "s" : "") + ")";
        }
        this.infoLabel.setText(t);
        if (this.isFileWritable()) {
            this.writableLabel.setText("Writable");
        } else {
            this.writableLabel.setText("Read-only");
        }
    }

    public void updateCursorInfo() {
        this.cursorLabel.setText(this.textEditor.getCurrentLinePosition() + ":" + this.textEditor.getCurrentColumnPosition());
    }

    @Override
    public FindAndReplace getFindAndReplace() {
        return this.findAndReplace;
    }

    @Override
    public GoToRule getGoToRule() {
        return this.goToRule;
    }

    @Override
    public boolean goToRule(String ruleName) {
        ElementRule rule = this.editorRules.selectRuleNameInTree(ruleName);
        if (rule != null) {
            this.goToHistoryRememberCurrentPosition();
            this.editorRules.goToRule(rule);
            return true;
        }
        return false;
    }

    @Override
    public void goToDeclaration() {
        Comparable ref = this.getCurrentReference();
        if (ref == null) {
            ref = this.getImportAtPosition(this.getCaretPosition());
        }
        this.getGoToMenu().goToDeclaration((Jumpable)((Object)ref));
    }

    @Override
    public void goToDeclaration(final Jumpable ref) {
        this.goToHistoryRememberCurrentPosition();
        if (!(ref instanceof ElementImport) && ref != null) {
            GrammarEngine engine = this.getGrammarEngine();
            int index = engine.getFirstDeclarationPosition(ref.getName());
            if (index == -1) {
                List<String> grammars = (engine = engine.getRootEngine()).getGrammarsOverriddenByRule(ref.getName());
                if (!grammars.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GrammarEngine engine = GrammarWindow.this.getGrammarEngine();
                            int index = engine.getFirstDeclarationPosition(ref.getName());
                            if (index != -1) {
                                GrammarWindow.this.setCaretPosition(index);
                            }
                        }
                    });
                }
            } else {
                this.setCaretPosition(index);
            }
        }
    }

    @Override
    public List<String> getRulesStartingWith(String match) {
        return this.editorRules.getRulesStartingWith(match);
    }

    public void rulesCaretPositionDidChange() {
        this.updateVisualization(false);
    }

    public void rulesDidChange() {
        this.interpreterTab.updateIgnoreTokens(this.getRules());
    }

    public JPopupMenu rulesGetContextualMenu(List selectedObjects) {
        if (selectedObjects.isEmpty()) {
            return null;
        }
        ContextualMenuFactory factory = this.createContextualMenuFactory();
        factory.addItem(56);
        factory.addItem(57);
        factory.addSeparator();
        XJMenuItemCheck item = (XJMenuItemCheck)factory.addItem(58);
        item.setSelected(this.editorRules.getFirstSelectedRuleIgnoredFlag());
        return factory.menu;
    }

    @Override
    public void ateEngineBeforeParsing() {
        this.editorPersistence.store();
    }

    @Override
    public void ateEngineAfterParsing() {
        this.updateInformation();
        this.updateCursorInfo();
        if (this.windowFirstDisplay) {
            this.windowFirstDisplay = false;
            this.afterParseOperations();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GrammarWindow.this.updateVisualization(true);
                    GrammarWindow.this.findTokensToIgnore(true);
                }
            });
        } else {
            this.afterParserOp.awakeThread();
        }
    }

    private void afterParseOperations() {
        this.editorPersistence.restore();
        this.grammarEngine.parserCompleted();
        this.grammarEngine.updateAll();
        this.interpreterTab.setRules(this.getNaturalRules());
        this.editorRules.parserDidParse();
        this.decisionDFAEngine.reset();
        this.decisionDFAEngine.refreshMenu();
        this.editorIdeas.display(this.getCaretPosition());
        this.syntaxDiagramTab.setText(this.getText(), this.getFileName());
        this.updateVisualization(false);
        this.textEditor.damage();
        this.textEditor.repaint();
    }

    public void changeDone() {
        this.grammarChanged();
        this.getDocument().changeDone();
    }

    public boolean ensureDocumentSaved() {
        return this.getDocument().getDocumentPath() != null || this.getDocument().save(false);
    }

    private void grammarChanged() {
        this.grammarEngine.markDirty();
    }

    public void consolePrint(String s, int level) {
        this.consoleStatus.showLevel(level);
    }

    public void clearConsoleStatus() {
        this.consoleStatus.clearMessage();
    }

    public void setHighlightedReference(Jumpable highlightedReference) {
        if (highlightedReference != this.highlightedReference) {
            this.textEditor.repaint();
        }
        this.highlightedReference = highlightedReference;
    }

    public Jumpable getHighlightedReference() {
        return this.highlightedReference;
    }

    @Override
    public void notificationFire(Object source, String name) {
        if (name.equals("NOTIF_PREFS_APPLIED")) {
            this.notificationPrefsChanged();
        } else if (name.equals("NOTIF_DEBUG_STARTED")) {
            this.notificationDebuggerStarted();
        } else if (name.equals("NOTIF_DEBUG_STOPPED")) {
            this.notificationDebuggerStopped();
        }
    }

    private void notificationPrefsChanged() {
        this.applyPrefs();
    }

    private void notificationDebuggerStarted() {
        this.getMainMenuBar().refresh();
        this.editorIdeas.hide();
    }

    private void notificationDebuggerStopped() {
    }

    public void setEditable(boolean flag) {
        this.textEditor.setEditable(flag);
        if (flag) {
            this.getTextPane().requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GrammarWindow.this.getTextPane().getCaret().setVisible(true);
                }
            });
        } else {
            this.getTextPane().getCaret().setVisible(flag);
        }
    }

    public void componentDidAwake() {
        this.updateInformation();
        this.updateCursorInfo();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GrammarWindow.this.getTextPane().requestFocusInWindow();
            }
        });
    }

    public void componentActivated() {
        this.consoleTab.makeCurrent();
        this.grammarEngine.reset();
        this.grammarEngine.updateAll();
        this.textEditor.getTextPane().setWritable(this.isFileWritable());
        this.textEditor.refresh();
        this.updateInformation();
    }

    public void componentDidHide() {
        this.editorIdeas.hide();
    }

    public void componentDocumentContentChanged() {
        if (!this.isFileExists()) {
            XJAlert.display(this.getJavaContainer(), "Warning", "The document cannot be found on the disk anymore.");
            return;
        }
        if (AWPrefs.isAlertFileChangesDetected()) {
            XJAlert alert = XJAlert.createInstance();
            alert.setDisplayDoNotShowAgainButton(true);
            int result = alert.showCustom(this.getJavaContainer(), "File Changes", "The file \"" + this.getFileName() + "\" changed on the disk. Do you want to reload it?", "Cancel", "Reload", 1, 0);
            AWPrefs.setAlertFileChangesDetected(!alert.isDoNotShowAgain());
            if (result == 0) {
                return;
            }
        }
        int oldCursorPosition = this.getCaretPosition();
        try {
            this.getDocument().reload();
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(this.getJavaContainer(), "Error Reloading Document", "An error occurred when reloading the document:\n" + e.toString());
        }
        this.grammarChanged();
        this.setCaretPosition(Math.min(oldCursorPosition, this.getText().length()));
    }

    @Override
    public List<String> autoCompletionMenuGetMatchingWordsForPartialWord(String partialWord) {
        if (this.grammarEngine.getNumberOfRules() == 0) {
            return null;
        }
        partialWord = partialWord.toLowerCase();
        ArrayList<String> matchingRules = new ArrayList<String>();
        if (this.editorRules.isRuleAtIndex(this.getCaretPosition())) {
            ArrayList<ElementRule> sortedRules = Collections.list(Collections.enumeration(this.grammarEngine.getRules()));
            Collections.sort(sortedRules, new Comparator<ElementRule>(){

                @Override
                public int compare(ElementRule o1, ElementRule o2) {
                    return o1.name.compareToIgnoreCase(o2.name);
                }
            });
            for (ElementRule rule : sortedRules) {
                if (!rule.name.toLowerCase().startsWith(partialWord) || matchingRules.contains(rule.name)) continue;
                matchingRules.add(rule.name);
            }
        } else {
            ArrayList<ElementReference> sortedUndefinedReferences = Collections.list(Collections.enumeration(this.grammarEngine.getUndefinedReferences()));
            Collections.sort(sortedUndefinedReferences, new Comparator<ElementReference>(){

                @Override
                public int compare(ElementReference o1, ElementReference o2) {
                    return o1.rule.name.compareToIgnoreCase(o2.rule.name);
                }
            });
            for (ElementReference ref : sortedUndefinedReferences) {
                String attr = ref.token.getAttribute();
                if (!attr.toLowerCase().startsWith(partialWord) || attr.equals(partialWord) || matchingRules.contains(attr)) continue;
                matchingRules.add(attr);
            }
        }
        return matchingRules;
    }

    @Override
    public void autoCompletionMenuWillDisplay() {
        this.editorIdeas.hide();
    }

    @Override
    public void ateChangeUpdate(int offset, int length, boolean insert) {
        this.changeDone();
        this.syntaxDiagramTab.cancelDrawingProcess();
    }

    @Override
    public void ateAutoIndent(int offset, int length) {
        try {
            GrammarAutoIndent.autoIndentOnSpecificKeys(this, this.getTextPane().getDocument(), offset, length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void ateMousePressed(Point point) {
        if (this.textEditor.getTextPane().isWritable()) {
            this.editorIdeas.display(point);
        }
        if (this.highlightedReference != null) {
            this.getGoToMenu().goToDeclaration(this.highlightedReference);
            this.highlightedReference = null;
        }
    }

    @Override
    public void ateMouseExited() {
        if (this.getTextPane().hasFocus()) {
            this.editorTips.hide();
        }
    }

    @Override
    public void ateMouseMoved(MouseEvent event) {
        Point pt = event.getPoint();
        if (this.getTextPane().hasFocus()) {
            Point absolutePoint = SwingUtilities.convertPoint(this.getTextPane(), pt, this.getJavaContainer());
            this.editorTips.display(pt, absolutePoint);
        }
        this.setHighlightedReference(null);
        if (event.isMetaDown() && XJSystem.isMacOS() || event.isControlDown()) {
            int index = this.textEditor.getTextIndexAtPosition(pt.x, pt.y);
            Comparable ref = this.getReferenceAtPosition(index);
            if (ref == null) {
                ref = this.getImportAtPosition(index);
            }
            this.setHighlightedReference((Jumpable)((Object)ref));
        }
    }

    @Override
    public void ateInvokePopUp(Component component, int x, int y) {
        JPopupMenu m = this.getContextualMenu(this.textEditor.getTextIndexAtPosition(x, y));
        if (m != null) {
            m.show(component, x, y);
        }
    }

    @Override
    public void ateCaretUpdate(int index) {
        this.updateCursorInfo();
        if (this.getTextPane().hasFocus()) {
            this.editorIdeas.hide();
            if (this.textEditor.getTextPane().isWritable()) {
                this.editorIdeas.display(this.getCaretPosition());
            }
        }
        this.autoCompletionMenu.updateAutoCompleteList();
        ElementRule rule = this.editorRules.selectRuleInTreeAtPosition(index);
        if (rule == null || rule.name == null) {
            this.updateVisualization(false);
            this.lastSelectedRule = null;
            return;
        }
        if (this.lastSelectedRule == null || !this.lastSelectedRule.equals(rule.name)) {
            this.lastSelectedRule = rule.name;
            this.updateVisualization(false);
        }
    }

    public void findTokensToIgnore(boolean reset) {
        this.editorRules.findTokensToIgnore(reset);
        this.interpreterTab.setRules(this.getNaturalRules());
    }

    public void print() {
        try {
            this.textEditor.print();
        }
        catch (PrinterException e) {
            XJAlert.display(this.getJavaContainer(), "Print Error", "An error occurred while printing:\n" + e.toString());
        }
    }

    public void showProgress(String title, XJDialogProgressDelegate delegate) {
        if (this.progress == null) {
            this.progress = new XJDialogProgress((Container)this.getJavaContainer());
        }
        this.progress.setInfo(title);
        this.progress.setCancellable(true);
        this.progress.setDelegate(delegate);
        this.progress.setIndeterminate(true);
        this.progress.display();
    }

    public void hideProgress() {
        this.progress.close();
    }

    @Override
    public void goToBackward() {
        StatisticsAW.shared().recordEvent(24);
        if (this.goToHistory.canGoBack()) {
            this.setCaretPosition(this.goToHistory.getBackPosition(this.getCaretPosition()));
            this.refreshMainMenuBar();
        }
    }

    @Override
    public void goToForward() {
        StatisticsAW.shared().recordEvent(25);
        if (this.goToHistory.canGoForward()) {
            this.setCaretPosition(this.goToHistory.getForwardPosition());
            this.refreshMainMenuBar();
        }
    }

    @Override
    public void find() {
        StatisticsAW.shared().recordEvent(10);
        this.findAndReplace.find();
    }

    public ContextualMenuFactory createContextualMenuFactory() {
        return new ContextualMenuFactory(this.menu);
    }

    public JPopupMenu getContextualMenu(int textIndex) {
        return this.menu.getContextualMenu(textIndex);
    }

    @Override
    public Set<Integer> getBreakpoints() {
        return this.gutterColumnManager.getBreakpoints();
    }

    public void refreshMainMenuBar() {
        this.getMainMenuBar().refreshState();
    }

    public void selectInterpreterTab() {
        this.selectTab(this.interpreterTab.getContainer());
    }

    public void selectConsoleTab() {
        this.selectTab(this.consoleTab.getContainer());
    }

    public void selectDebuggerTab() {
        this.selectTab(this.debuggerTab.getContainer());
    }

    private class MainPanelComponentListener
    extends ComponentAdapter {
        private MainPanelComponentListener() {
        }

        public void componentHidden(ComponentEvent e) {
            GrammarWindow.this.componentDidHide();
        }
    }

    private class BottomTabbedPaneChangeListener
    implements ChangeListener {
        private BottomTabbedPaneChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            GrammarWindow.this.refreshMainMenuBar();
        }
    }

    public class BottomTabbedPaneMouseListener
    extends MouseAdapter {
        public void displayPopUp(MouseEvent event) {
            if (GrammarWindow.this.bottomTab.getSelectedIndex() < 4) {
                return;
            }
            if (!event.isPopupTrigger()) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item = new JMenuItem("Close");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    GrammarWindow.this.closeTab(GrammarWindow.this.bottomTab.getSelectedIndex());
                }
            });
            popup.add(item);
            popup.show(event.getComponent(), event.getX(), event.getY());
        }

        public void mousePressed(MouseEvent event) {
            this.displayPopUp(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.displayPopUp(event);
        }
    }

    protected class ConsoleStatus {
        public final Box box = Box.createHorizontalBox();
        public final XJURLLabel label;
        public boolean visible;
        public int currentDisplayedLevel;

        public ConsoleStatus() {
            this.label = new XJURLLabel(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GrammarWindow.this.selectTab(GrammarWindow.this.consoleTab.getTabComponent());
                    ConsoleStatus.this.clearMessage();
                }
            });
            this.clearMessage();
        }

        public void showMessage(String message, Color color) {
            this.label.setText(message);
            this.label.setUnvisitedURLColor(color);
            this.label.setVisitedURLColor(color);
            this.label.repaint();
        }

        public void showLevel(int level) {
            if (level == 0) {
                return;
            }
            if (!this.visible) {
                this.visible = true;
                this.box.removeAll();
                this.box.add(this.label);
                this.box.revalidate();
            }
            if (level > this.currentDisplayedLevel) {
                this.currentDisplayedLevel = level;
                if (level == 2) {
                    this.showMessage("Errors reported in console", Color.red);
                } else {
                    this.showMessage("Warnings reported in console", Color.blue);
                }
            }
        }

        public void clearMessage() {
            this.label.setText("");
            this.box.removeAll();
            this.box.add(Box.createHorizontalStrut(20));
            this.visible = false;
            this.currentDisplayedLevel = 0;
        }

        public JComponent getPanel() {
            return this.box;
        }
    }

    protected class AfterParseOperations
    extends ATEThread {
        public AfterParseOperations() {
            this.start();
        }

        protected void threadRun() throws Exception {
            GrammarWindow.this.afterParseOperations();
        }
    }
}

