/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.dialog;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.antlr.works.IDE;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsReporter;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.Localizable;
import org.antlr.xjlib.appkit.frame.XJDialog;

public class DialogPersonalInfo
extends XJDialog {
    public static final String INFO_WHO = "who";
    public static final String INFO_SECTOR = "sector";
    public static final String INFO_DEVTOOL = "devtool";
    public static final String INFO_YEARSLANG = "yearslang";
    public static final String INFO_YEARSPROG = "yearsprog";
    public static final String INFO_RESIDING = "residing";
    public static final String INFO_CAFFEINE = "caffeine";
    private JPanel dialogPane;
    private JPanel contentPane;
    private JButton iconButton;
    private JLabel label6;
    private JTextArea textArea1;
    private JComboBox whoCombo;
    private JLabel label1;
    private JComboBox sectorCombo;
    private JLabel label7;
    private JLabel label8;
    private JComboBox devtoolCombo;
    private JSpinner languageExperienceSpinner;
    private JLabel label2;
    private JSpinner programmingExperienceSpinner;
    private JLabel label3;
    private JTextField countryField;
    private JLabel label4;
    private JTextField funField;
    private JLabel label5;
    private JPanel buttonBar;
    private JButton cancelButton;
    private JButton okButton;

    public DialogPersonalInfo(Container parent) {
        super(parent, true);
        this.initComponents();
        this.setSize(780, 550);
        this.iconButton.setIcon(IconManager.shared().getIconApplication());
        this.setTitle(Localizable.getLocalizedString("AppName") + " " + IDE.VERSION);
        this.setCancelButton(this.cancelButton);
        this.setDefaultButton(this.okButton);
        this.setOKButton(this.okButton);
        this.whoCombo.setSelectedIndex(-1);
        this.whoCombo.addActionListener(new MyActionListener());
        this.sectorCombo.setSelectedIndex(-1);
        this.sectorCombo.addActionListener(new MyActionListener());
        this.devtoolCombo.setSelectedIndex(-1);
        this.devtoolCombo.addActionListener(new MyActionListener());
        this.okButton.setEnabled(false);
    }

    public void dialogWillCloseCancel() {
        this.requestAndRegisterID();
    }

    public void dialogWillCloseOK() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put(INFO_WHO, this.whoCombo.getSelectedIndex());
        info.put(INFO_SECTOR, this.sectorCombo.getSelectedIndex());
        info.put(INFO_DEVTOOL, this.devtoolCombo.getSelectedIndex());
        info.put(INFO_YEARSLANG, this.languageExperienceSpinner.getValue());
        info.put(INFO_YEARSPROG, this.programmingExperienceSpinner.getValue());
        info.put(INFO_RESIDING, this.countryField.getText());
        info.put(INFO_CAFFEINE, this.funField.getText());
        AWPrefs.setPersonalInfo(info);
        this.requestAndRegisterID();
    }

    public void requestAndRegisterID() {
        StatisticsReporter sr = new StatisticsReporter();
        String id = sr.getID();
        if (id == null) {
            System.err.println("Cannot send info =" + sr.getError() + "\nID is null.");
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPane = new JPanel();
        this.iconButton = new JButton();
        this.label6 = new JLabel();
        this.textArea1 = new JTextArea();
        this.whoCombo = new JComboBox();
        this.label1 = new JLabel();
        this.sectorCombo = new JComboBox();
        this.label7 = new JLabel();
        this.label8 = new JLabel();
        this.devtoolCombo = new JComboBox();
        this.languageExperienceSpinner = new JSpinner();
        this.label2 = new JLabel();
        this.programmingExperienceSpinner = new JSpinner();
        this.label3 = new JLabel();
        this.countryField = new JTextField();
        this.label4 = new JLabel();
        this.funField = new JTextField();
        this.label5 = new JLabel();
        this.buttonBar = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("ANTLRWorks early access 1");
        Container contentPane2 = this.getContentPane();
        contentPane2.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setPreferredSize(new Dimension(750, 500));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPane.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(50)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;100dlu):grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;30dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.DLUY5), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.DLUY5), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, 1.0)}));
        this.iconButton.setBorder(null);
        this.iconButton.setIcon(null);
        this.iconButton.setEnabled(true);
        this.iconButton.setFocusable(false);
        this.iconButton.setFocusPainted(false);
        this.iconButton.setBorderPainted(false);
        this.iconButton.setContentAreaFilled(false);
        this.iconButton.setDefaultCapable(false);
        this.iconButton.setRequestFocusEnabled(false);
        this.iconButton.setOpaque(false);
        this.iconButton.setVerifyInputWhenFocusTarget(false);
        this.iconButton.setVerticalAlignment(1);
        this.contentPane.add((Component)this.iconButton, cc.xywh(1, 1, 1, 37));
        this.label6.setText("Welcome to ANTLRWorks!");
        this.label6.setFont(new Font("Lucida Grande", 0, 20));
        this.contentPane.add((Component)this.label6, cc.xywh(3, 1, 5, 1));
        this.textArea1.setText("Please take a few seconds to fill out some information about yourself to help us improve our products.  Thank you!");
        this.textArea1.setEditable(false);
        this.textArea1.setOpaque(false);
        this.textArea1.setWrapStyleWord(true);
        this.textArea1.setLineWrap(true);
        this.textArea1.setBackground(UIManager.getColor("window"));
        this.contentPane.add((Component)this.textArea1, cc.xywh(3, 5, 5, 1));
        this.whoCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Professional programmer", "Researcher", "Graduate student", "Undergraduate student", "Professor"}));
        this.contentPane.add((Component)this.whoCombo, cc.xywh(3, 11, 3, 1));
        this.label1.setText("Who are you?");
        this.label1.setHorizontalAlignment(2);
        this.contentPane.add((Component)this.label1, cc.xywh(3, 9, 3, 1));
        this.sectorCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Industry", "Government", "Academia", "Military", "Other"}));
        this.contentPane.add((Component)this.sectorCombo, cc.xywh(3, 15, 3, 1));
        this.label7.setText("What is your sector of activity?");
        this.label7.setHorizontalAlignment(2);
        this.contentPane.add((Component)this.label7, cc.xywh(3, 13, 3, 1));
        this.label8.setText("What is your primary development environment?");
        this.contentPane.add((Component)this.label8, cc.xywh(3, 17, 3, 1));
        this.devtoolCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Eclipse", "IntelliJ", "Microsoft Visual Studio", "Borland JBuilder", "Xcode", "Text Editor (vi, emacs) - hardcore old-school \"I don't need no stinkin' IDE coder\"", "Other"}));
        this.contentPane.add((Component)this.devtoolCombo, cc.xywh(3, 19, 3, 1));
        this.languageExperienceSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.contentPane.add((Component)this.languageExperienceSpinner, cc.xy(3, 23));
        this.label2.setText("How many years of experience with language translation/implementation?");
        this.label2.setHorizontalAlignment(2);
        this.contentPane.add((Component)this.label2, cc.xywh(3, 21, 3, 1));
        this.programmingExperienceSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.contentPane.add((Component)this.programmingExperienceSpinner, cc.xy(3, 27));
        this.label3.setText("How many years of programming experience?");
        this.label3.setHorizontalAlignment(2);
        this.contentPane.add((Component)this.label3, cc.xywh(3, 25, 3, 1));
        this.contentPane.add((Component)this.countryField, cc.xywh(3, 31, 3, 1));
        this.label4.setText("In which country do you currently live?");
        this.label4.setHorizontalAlignment(2);
        this.contentPane.add((Component)this.label4, cc.xywh(3, 29, 3, 1));
        this.contentPane.add((Component)this.funField, cc.xywh(3, 35, 3, 1));
        this.label5.setText("What is your preferred caffeinated beverage?");
        this.label5.setHorizontalAlignment(2);
        this.contentPane.add((Component)this.label5, cc.xywh(3, 33, 3, 1));
        this.dialogPane.add((Component)this.contentPane, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")));
        this.cancelButton.setText("Don't Send");
        this.buttonBar.add((Component)this.cancelButton, cc.xy(3, 1));
        this.okButton.setText("Send");
        this.buttonBar.add((Component)this.okButton, cc.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane2.add((Component)this.dialogPane, "Center");
        this.pack();
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            DialogPersonalInfo.this.okButton.setEnabled(DialogPersonalInfo.this.whoCombo.getSelectedIndex() > -1 && DialogPersonalInfo.this.sectorCombo.getSelectedIndex() > -1 && DialogPersonalInfo.this.devtoolCombo.getSelectedIndex() > -1);
        }
    }
}

