/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.dialog;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.works.dialog.DialogReportsDelegate;
import org.antlr.works.stats.StatisticsManager;
import org.antlr.works.stats.StatisticsReporter;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJSystem;

public class DialogReports
extends XJDialog {
    public static final int TYPE_GUI = 0;
    public static final int TYPE_GRAMMAR = 1;
    public static final int TYPE_RUNTIME = 2;
    protected StatisticsManager guiManager;
    protected StatisticsManager grammarManager;
    protected StatisticsManager runtimeManager;
    protected DialogReportsDelegate delegate;
    protected XJDialogProgress progress;
    protected DefaultComboBoxModel typeModel = new DefaultComboBoxModel();
    protected boolean usesAWStats = true;
    private JPanel dialogPane;
    private JPanel contentPane;
    private JLabel label1;
    private JComboBox typeCombo;
    private JLabel label22;
    private JCheckBox humanFormatCheck;
    private JSpinner currentSpinner;
    private JLabel label2;
    private JLabel infoLabel;
    private JScrollPane scrollPane1;
    private JTextArea statsTextArea;
    private JPanel buttonBar;
    private JButton submitButton;
    private JButton cancelButton;

    public DialogReports(Container parent, boolean usesAWStats) {
        super(parent, true);
        this.usesAWStats = usesAWStats;
        this.initComponents();
        this.setSize(550, 500);
        if (XJSystem.isMacOS()) {
            CellConstraints cc = new CellConstraints();
            this.buttonBar.remove(this.cancelButton);
            this.buttonBar.remove(this.submitButton);
            this.buttonBar.add((Component)this.cancelButton, cc.xy(3, 1));
            this.buttonBar.add((Component)this.submitButton, cc.xy(5, 1));
        }
        this.setDefaultButton(this.submitButton);
        this.setOKButton(this.submitButton);
        this.setCancelButton(this.cancelButton);
        this.buildTypeCombo();
        this.humanFormatCheck.setSelected(true);
        this.statsTextArea.setTabSize(2);
        this.typeCombo.addActionListener(new MyActionListener());
        this.humanFormatCheck.addActionListener(new MyActionListener());
        this.currentSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                DialogReports.this.updateInfo(true);
            }
        });
    }

    public void setDelegate(DialogReportsDelegate delegate) {
        this.delegate = delegate;
    }

    public void buildTypeCombo() {
        if (this.usesAWStats) {
            this.typeModel.addElement("ANTLRWorks");
        }
        this.typeModel.addElement("ANTLR - grammar");
        this.typeModel.addElement("ANTLR - runtime");
        this.typeCombo.setModel(this.typeModel);
    }

    public void dialogWillDisplay() {
        this.guiManager = new StatisticsManager("antlrworks");
        this.grammarManager = new StatisticsManager("grammar");
        this.runtimeManager = new StatisticsManager("runtime");
        this.updateInfo(false);
    }

    public void dialogWillCloseCancel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DialogReports.this.delegate != null) {
                    DialogReports.this.delegate.reportsCancelled();
                }
            }
        });
    }

    public void dialogWillCloseOK() {
        new SendReport().send();
    }

    protected int getTypeIndex() {
        if (this.usesAWStats) {
            return this.typeCombo.getSelectedIndex();
        }
        return this.typeCombo.getSelectedIndex() + 1;
    }

    protected void updateInfo(boolean textOnly) {
        StatisticsManager sm = null;
        boolean rangeEnabled = true;
        switch (this.getTypeIndex()) {
            case 0: {
                rangeEnabled = false;
                sm = this.guiManager;
                break;
            }
            case 1: {
                rangeEnabled = true;
                sm = this.grammarManager;
                break;
            }
            case 2: {
                rangeEnabled = true;
                sm = this.runtimeManager;
            }
        }
        if (!textOnly) {
            this.setRangeEnabled(rangeEnabled, sm);
        }
        if (sm != null) {
            this.setText(sm);
        }
    }

    protected void setRangeEnabled(boolean flag, StatisticsManager sm) {
        this.currentSpinner.setEnabled(flag);
        this.infoLabel.setEnabled(flag);
        this.currentSpinner.setValue(new Integer(1));
        SpinnerNumberModel spm = (SpinnerNumberModel)this.currentSpinner.getModel();
        spm.setMaximum(new Integer(sm.getStatsCount()));
        if (flag) {
            this.infoLabel.setText("of " + sm.getStatsCount());
        } else {
            this.infoLabel.setText("");
        }
    }

    protected void setText(StatisticsManager sm) {
        String text;
        int index = (Integer)this.currentSpinner.getValue() - 1;
        String string = text = this.isHumanReadable() ? sm.getReadableString(index) : sm.getRawString(index);
        if (text == null) {
            text = "* no statistics available *";
        }
        this.statsTextArea.setText(text);
        this.statsTextArea.setCaretPosition(0);
    }

    protected boolean isHumanReadable() {
        return this.humanFormatCheck.isSelected();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPane = new JPanel();
        this.label1 = new JLabel();
        this.typeCombo = new JComboBox();
        this.label22 = new JLabel();
        this.humanFormatCheck = new JCheckBox();
        this.currentSpinner = new JSpinner();
        this.label2 = new JLabel();
        this.infoLabel = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.statsTextArea = new JTextArea();
        this.buttonBar = new JPanel();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Review reports before submission");
        Container contentPane2 = this.getContentPane();
        contentPane2.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setPreferredSize(new Dimension(500, 500));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPane.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;30dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;30dlu):grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, 1.0)}));
        this.label1.setText("View report for:");
        this.label1.setHorizontalAlignment(4);
        this.contentPane.add((Component)this.label1, cc.xy(1, 1));
        this.typeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"ANTLRWorks", "ANTLR - grammar", "ANTLR - runtime"}));
        this.contentPane.add((Component)this.typeCombo, cc.xywh(3, 1, 5, 1));
        this.label22.setText("Format:");
        this.label22.setHorizontalAlignment(4);
        this.contentPane.add((Component)this.label22, cc.xy(1, 3));
        this.humanFormatCheck.setText("Human readable");
        this.humanFormatCheck.setSelected(true);
        this.contentPane.add((Component)this.humanFormatCheck, cc.xywh(3, 3, 7, 1));
        this.currentSpinner.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        this.contentPane.add((Component)this.currentSpinner, cc.xywh(3, 5, 2, 1));
        this.label2.setText("Report:");
        this.label2.setHorizontalAlignment(4);
        this.contentPane.add((Component)this.label2, cc.xy(1, 5));
        this.infoLabel.setText("of 999");
        this.contentPane.add((Component)this.infoLabel, cc.xywh(7, 5, 3, 1));
        this.statsTextArea.setEditable(false);
        this.statsTextArea.setLineWrap(false);
        this.statsTextArea.setWrapStyleWord(false);
        this.statsTextArea.setTabSize(2);
        this.scrollPane1.setViewportView(this.statsTextArea);
        this.contentPane.add((Component)this.scrollPane1, cc.xywh(1, 7, 9, 3));
        this.dialogPane.add((Component)this.contentPane, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")));
        this.submitButton.setText("Submit");
        this.buttonBar.add((Component)this.submitButton, cc.xy(3, 1));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, cc.xy(5, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane2.add((Component)this.dialogPane, "Center");
        this.pack();
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            DialogReports.this.updateInfo(false);
        }
    }

    protected class SendReport
    implements Runnable,
    XJDialogProgressDelegate {
        public boolean error = false;
        public boolean cancel = false;
        public StatisticsReporter reporter;
        public StatisticsManager[] managers;

        protected SendReport() {
            this.managers = new StatisticsManager[]{DialogReports.this.guiManager, DialogReports.this.grammarManager, DialogReports.this.runtimeManager};
        }

        public void send() {
            DialogReports.this.progress = new XJDialogProgress(DialogReports.this.parent);
            DialogReports.this.progress.setDelegate(this);
            DialogReports.this.progress.setCancellable(true);
            DialogReports.this.progress.setProgressMax(this.managers.length);
            DialogReports.this.progress.setIndeterminate(false);
            DialogReports.this.progress.setInfo("Sending statistics...");
            DialogReports.this.progress.display();
            this.error = false;
            this.cancel = false;
            this.reporter = new StatisticsReporter();
            new Thread(this).start();
        }

        public boolean submit() {
            for (int i = 0; i < this.managers.length; ++i) {
                StatisticsManager manager = this.managers[i];
                if (manager == DialogReports.this.guiManager && !DialogReports.this.usesAWStats) continue;
                DialogReports.this.progress.setProgress(i + 1);
                if (!this.reporter.submitStats(manager)) {
                    return true;
                }
                if (!this.cancel) continue;
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.error = this.submit();
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SendReport.this.finished();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public void finished() {
            String info;
            String title;
            if (!this.cancel) {
                DialogReports.this.guiManager.reset();
                DialogReports.this.grammarManager.reset();
                DialogReports.this.runtimeManager.reset();
            }
            DialogReports.this.progress.close();
            if (this.cancel) {
                title = "Submission cancelled";
                info = "The submission has been cancelled.";
            } else if (this.error) {
                title = "Submission failed";
                info = "An error has occurred when sending the statistics:\n" + this.reporter.getError();
            } else {
                title = "Thank you";
                info = "The statistics have been successfully transmitted.";
            }
            XJAlert.display(DialogReports.this.getJavaComponent(), title, info);
            if (DialogReports.this.delegate != null) {
                if (this.cancel) {
                    DialogReports.this.delegate.reportsCancelled();
                } else {
                    DialogReports.this.delegate.reportsSend(!this.error);
                }
            }
        }

        public void dialogDidCancel() {
            this.cancel = true;
            this.reporter.cancel();
        }
    }
}

