/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.fa;

import java.util.List;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FATransition
implements SSerializable {
    public FAState source;
    public String label;
    public FAState target;
    public boolean loop = false;
    public boolean externalRuleRef = false;
    public List<Integer> skippedStates;

    public FATransition(String label, FAState targetState) {
        this.label = label;
        this.target = targetState;
    }

    public FATransition(FAState targetState) {
        this(targetState, null);
    }

    public FATransition(FAState targetState, List<Integer> skippedStates) {
        this.label = null;
        this.target = targetState;
        this.skippedStates = skippedStates;
    }

    public void setSourceState(FAState source) {
        this.source = source;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setExternalRuleRef(boolean flag) {
        this.externalRuleRef = flag;
    }

    public boolean isEpsilon() {
        return this.label == null;
    }

    public boolean containsStateNumber(int n) {
        for (Integer state : this.skippedStates) {
            if (state != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void encode(SEncoder encoder) {
        encoder.write(this.source);
        encoder.write(this.label);
        encoder.write(this.target);
        encoder.write(this.loop);
        encoder.write(this.externalRuleRef);
        if (this.skippedStates != null) {
            for (Integer s : this.skippedStates) {
                encoder.write(s);
            }
        }
    }
}

