/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.Graphics2D;
import java.awt.Point;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.shape.SArrow;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class GElementArrow
extends GElement
implements XJXMLSerializable {
    protected SArrow arrow;
    protected Vector2D target;

    public GElementArrow() {
        this.setArrow(new SArrow());
    }

    public void setArrow(SArrow arrow) {
        this.arrow = arrow;
    }

    public SArrow getArrow() {
        return this.arrow;
    }

    public void setArrowLength(double length) {
        this.arrow.setLength(length);
    }

    public void setSource(double x, double y) {
        super.setPosition(x, y);
    }

    public void setTarget(double x, double y) {
        this.arrow.setAnchor(x, y);
        this.target = new Vector2D(x, y);
        Vector2D direction = this.getPosition().sub(this.target);
        this.arrow.setDirection(direction);
    }

    public void setTarget(Vector2D target) {
        this.target = target;
    }

    public Vector2D getTarget() {
        return this.target;
    }

    public void move(double dx, double dy) {
        super.move(dx, dy);
        this.target.shift(dx, dy);
        this.arrow.getAnchor().shift(dx, dy);
    }

    public Rect getFrame() {
        return new Rect(this.getPosition(), this.target, 2.0, 2.0);
    }

    public boolean isInside(Point p) {
        return this.getFrame().contains(p);
    }

    public void draw(Graphics2D g) {
        if (this.isVisibleInClip(g)) {
            g.setColor(this.color);
            this.drawShape(g);
        }
    }

    public void drawShape(Graphics2D g) {
        super.drawShape(g);
        this.arrow.draw(g);
        g.drawLine((int)this.getPositionX(), (int)this.getPositionY(), (int)this.target.x, (int)this.target.y);
    }
}

