/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.text;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;
import org.antlr.xjlib.appkit.utils.BrowserLauncher;

public class XJURLLabel
extends JLabel {
    protected String url;
    protected ActionListener listener;
    protected Color unvisitedURL = Color.blue;
    protected Color visitedURL = Color.blue;

    public XJURLLabel() {
        this.setForeground(this.unvisitedURL);
        this.addMouseListener(new Clicked());
    }

    public XJURLLabel(String url) {
        this();
        this.url = url;
    }

    public XJURLLabel(ActionListener listener) {
        this();
        this.listener = listener;
    }

    public void setUnvisitedURLColor(Color c) {
        this.unvisitedURL = c;
        this.setForeground(this.unvisitedURL);
    }

    public void setVisitedURLColor(Color c) {
        this.visitedURL = c;
    }

    class Clicked
    extends MouseAdapter {
        Clicked() {
        }

        public void mouseClicked(MouseEvent me) {
            XJURLLabel.this.setForeground(XJURLLabel.this.visitedURL);
            try {
                if (XJURLLabel.this.listener != null) {
                    XJURLLabel.this.listener.actionPerformed(new ActionEvent(this, 0, ""));
                }
                if (XJURLLabel.this.url != null) {
                    BrowserLauncher.openURL(XJURLLabel.this.url);
                }
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }

        public void mouseEntered(MouseEvent e) {
            XJURLLabel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent e) {
            XJURLLabel.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

