package org.antlr.works.menu;

import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.editor.navigation.GoToRule;
import org.antlr.works.grammar.element.Jumpable;
import org.antlr.works.grammar.engine.GrammarEngine;

import java.awt.*;
import java.util.List;
import java.util.Set;/*

[The "BSD licence"]
Copyright (c) 2009 Jean Bovet
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

public interface GoToMenuDelegate {
    GoToRule getGoToRule();

    void goToDeclaration();

    void goToDeclaration(Jumpable ref);

    Set<Integer> getBreakpoints();

    ATEPanel getTextEditor();

    int getCaretPosition();

    GrammarEngine getGrammarEngine();

    Component getJavaContainer();

    ATETextPane getTextPane();

    void goToHistoryRememberCurrentPosition();

    void setCaretPosition(int character);

    void goToBackward();

    void goToForward();

    List<ATELine> getLines();
}
