/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.analysis;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.analysis.ATEAnalysisColumnOverlay;
import org.antlr.works.ate.analysis.ATEAnalysisItem;
import org.antlr.works.ate.analysis.ATEAnalysisManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATEAnalysisColumn
extends JPanel {
    protected ATEPanel textEditor;
    protected ATEAnalysisColumnOverlay overlay;
    protected ColumnAnalysisBox analysisBox;
    protected int topOffset = 30;
    protected int bottomOffset = 50;
    protected int lineCount;

    public ATEAnalysisColumn(ATEPanel textEditor) {
        this.textEditor = textEditor;
        this.setFocusable(false);
        this.analysisBox = new ColumnAnalysisBox();
        this.overlay = new ATEAnalysisColumnOverlay(textEditor.getParentFrame(), this);
        this.addMouseMotionListener(new ColumnMouseMotionAdapter());
        this.addMouseListener(new ColumnMouseAdapter());
    }

    public void close() {
        this.overlay.close();
        this.overlay = null;
    }

    public ATEAnalysisManager getAnalysisManager() {
        return this.textEditor.getAnalysisManager();
    }

    public Rectangle getDrawingBounds() {
        Rectangle r = this.getBounds();
        r.y = this.topOffset;
        r.height -= this.topOffset + this.bottomOffset;
        return r;
    }

    public Rectangle composeIndicatorRectangle(int line, int coarse) {
        Rectangle r = this.getDrawingBounds();
        float position = (float)line / (float)this.lineCount;
        int y = (int)((float)r.y + (float)r.height * position);
        return new Rectangle(3, y - coarse, r.width - 6, 2 + 2 * coarse);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        ATEAnalysisManager manager = this.getAnalysisManager();
        if (manager == null) {
            return;
        }
        this.lineCount = manager.getLinesCount();
        Graphics2D g2d = (Graphics2D)g;
        int[] types = manager.getAvailableTypes();
        for (int type = 0; type < types.length; ++type) {
            this.paintStrips(g2d, manager.getItemsForType(type));
        }
        this.analysisBox.paint(g);
    }

    protected void paintStrips(Graphics2D g, List<ATEAnalysisItem> items) {
        for (ATEAnalysisItem item : items) {
            g.setColor(item.color);
            g.fill(this.composeIndicatorRectangle(item.line, 0));
        }
    }

    protected class ColumnMouseMotionAdapter
    extends MouseMotionAdapter {
        protected ColumnMouseMotionAdapter() {
        }

        public void mouseMoved(MouseEvent e) {
            ATEAnalysisManager manager = ATEAnalysisColumn.this.getAnalysisManager();
            if (manager == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (ATEAnalysisColumn.this.analysisBox.r.contains(e.getPoint())) {
                sb.append(manager.getAnalysisDescription());
            } else {
                sb.append(this.getItemDescriptionsAtPoint(e.getPoint()));
            }
            if (sb.length() > 0) {
                ATEAnalysisColumn.this.setCursor(Cursor.getPredefinedCursor(12));
                ATEAnalysisColumn.this.overlay.setLocation(e.getPoint());
                ATEAnalysisColumn.this.overlay.setText(sb.toString());
                ATEAnalysisColumn.this.overlay.display();
            } else {
                ATEAnalysisColumn.this.setCursor(Cursor.getDefaultCursor());
                ATEAnalysisColumn.this.overlay.hide();
            }
        }

        protected String getItemDescriptionsAtPoint(Point point) {
            StringBuilder sb = new StringBuilder();
            ATEAnalysisManager manager = ATEAnalysisColumn.this.getAnalysisManager();
            if (manager != null) {
                int[] types = manager.getAvailableTypes();
                for (int type = 0; type < types.length; ++type) {
                    List<ATEAnalysisItem> items = manager.getItemsForType(type);
                    for (ATEAnalysisItem ai : items) {
                        if (!ATEAnalysisColumn.this.composeIndicatorRectangle(ai.line, 2).contains(point)) continue;
                        sb.append(ai.description);
                        sb.append("\n");
                    }
                }
            }
            return sb.toString();
        }
    }

    protected class ColumnMouseAdapter
    extends MouseAdapter {
        protected ColumnMouseAdapter() {
        }

        public int getIndexOfFirstErrors(Point p) {
            int[] types = ATEAnalysisColumn.this.getAnalysisManager().getAvailableTypes();
            for (int type = 0; type < types.length; ++type) {
                List<ATEAnalysisItem> items = ATEAnalysisColumn.this.getAnalysisManager().getItemsForType(type);
                for (ATEAnalysisItem ai : items) {
                    if (!ATEAnalysisColumn.this.composeIndicatorRectangle(ai.line, 2).contains(p)) continue;
                    return ai.index;
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent e) {
            int index = this.getIndexOfFirstErrors(e.getPoint());
            if (index > -1) {
                ATEAnalysisColumn.this.overlay.hide();
                ATEAnalysisColumn.this.textEditor.setCaretPosition(index);
            }
        }

        public void mouseExited(MouseEvent e) {
            ATEAnalysisColumn.this.overlay.hide();
        }
    }

    protected class ColumnAnalysisBox {
        protected final Rectangle r = new Rectangle(2, 2, 14, 14);

        public void paint(Graphics g) {
            BorderFactory.createEtchedBorder().paintBorder(ATEAnalysisColumn.this, g, this.r.x, this.r.y, this.r.width, this.r.height);
            g.setColor(ATEAnalysisColumn.this.getAnalysisManager().getAnalysisColor());
            g.fillRect(this.r.x + 2, this.r.y + 2, this.r.width - 5, this.r.height - 5);
        }
    }
}

