/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.input;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.TextPane;
import org.antlr.works.utils.TextPaneDelegate;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class DBInputProcessorToken
implements DBInputProcessor,
TextPaneDelegate,
XJNotificationObserver {
    public static final Color HIGHLIGHTED_COLOR = new Color(0.0f, 0.5f, 1.0f, 0.4f);
    public static final Color INPUT_BREAKPOINT_COLOR = new Color(1.0f, 0.2f, 0.0f, 0.5f);
    protected DebuggerTab debuggerTab;
    protected TextPane textPane;
    protected int mouseIndex = -1;
    protected LinkedList<Integer> inputTokenIndexes = new LinkedList();
    protected Map<Integer, DBInputTextTokenInfo> indexToTokenInfoMap = new HashMap<Integer, DBInputTextTokenInfo>();
    protected Map<Integer, AttributeSet> indexToConsumeAttributeMap = new HashMap<Integer, AttributeSet>();
    protected Set<Integer> lookaheadTokenIndexes = new HashSet<Integer>();
    protected int currentTokenIndex;
    protected int currentTokenIndexInText;
    protected DBEventLocation locationEvent;
    protected int locationCharInLine;
    protected Set<Integer> inputBreakpointIndexes = new HashSet<Integer>();
    protected SimpleAttributeSet attributeNonConsumed;
    protected SimpleAttributeSet attributeConsume;
    protected SimpleAttributeSet attributeConsumeHidden;
    protected SimpleAttributeSet attributeConsumeDead;
    protected SimpleAttributeSet attributeLookahead;
    protected boolean drawTokensBox;

    public DBInputProcessorToken(DebuggerTab debuggerTab, TextPane textPane) {
        this.debuggerTab = debuggerTab;
        this.textPane = textPane;
        this.textPane.setDelegate(this);
        this.textPane.addMouseListener(new MyMouseListener());
        this.textPane.addMouseMotionListener(new MyMouseMotionListener());
        this.drawTokensBox = false;
        this.reset();
        this.createTextAttributes();
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
    }

    public void close() {
        this.debuggerTab = null;
        this.textPane.setDelegate(null);
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public void setDrawTokensBox(boolean flag) {
        this.drawTokensBox = flag;
        this.textPane.repaint();
    }

    public boolean isTokensBoxVisible() {
        return this.drawTokensBox;
    }

    public int getCurrentTokenIndex() {
        return this.currentTokenIndex;
    }

    public void setLocation(DBEventLocation event) {
        this.locationEvent = event;
    }

    public void consumeToken(Token token, int flavor) {
        if (this.ignoreToken(token)) {
            return;
        }
        SimpleAttributeSet attr = null;
        switch (flavor) {
            case 1: {
                attr = this.attributeConsume;
                break;
            }
            case 2: {
                attr = this.attributeConsumeHidden;
                break;
            }
            case 3: {
                attr = this.attributeConsumeDead;
            }
        }
        this.addToken(token);
        this.addConsumeAttribute(token, attr);
        this.removeTokenLT(token);
    }

    public void LT(Token token) {
        this.addToken(token);
        this.addTokenLT(token);
    }

    public boolean ignoreToken(Token t) {
        if (!XJSystem.isWindows()) {
            return false;
        }
        Token ct = this.getCurrentToken();
        if (ct == null) {
            return false;
        }
        return ct.getText().equals("\r") && t.getText().equals("\n");
    }

    public void addConsumeAttribute(Token token, AttributeSet attribute) {
        this.indexToConsumeAttributeMap.put(token.getTokenIndex(), attribute);
    }

    public void addTokenLT(Token token) {
        this.lookaheadTokenIndexes.add(token.getTokenIndex());
    }

    public void removeTokenLT(Token token) {
        this.lookaheadTokenIndexes.remove(token.getTokenIndex());
    }

    public void removeAllLT() {
        this.lookaheadTokenIndexes.clear();
    }

    public void stop() {
        this.inputBreakpointIndexes.clear();
    }

    public void reset() {
        this.textPane.setText("");
        this.textPane.setCharacterAttributes(SimpleAttributeSet.EMPTY, true);
        this.currentTokenIndex = -1;
        this.currentTokenIndexInText = 0;
        this.inputTokenIndexes.clear();
        this.indexToTokenInfoMap.clear();
        this.indexToConsumeAttributeMap.clear();
        this.lookaheadTokenIndexes.clear();
    }

    public void rewindAll() {
        this.rewind(-1);
    }

    public void rewind(int start) {
        this.currentTokenIndex = start;
        for (Integer idx : this.inputTokenIndexes) {
            if (idx < start) continue;
            this.indexToConsumeAttributeMap.remove(idx);
            this.lookaheadTokenIndexes.remove(idx);
        }
    }

    public void addToken(Token token) {
        int index = token.getTokenIndex();
        if (index == -1) {
            return;
        }
        this.currentTokenIndex = index;
        if (!this.indexToTokenInfoMap.containsKey(index)) {
            if (this.inputTokenIndexes.isEmpty()) {
                this.inputTokenIndexes.add(index);
            } else {
                for (int i = this.inputTokenIndexes.size() - 1; i >= 0; --i) {
                    Integer n = this.inputTokenIndexes.get(i);
                    if (n >= index) continue;
                    this.inputTokenIndexes.add(i + 1, index);
                    break;
                }
            }
        }
        this.indexToTokenInfoMap.put(index, new DBInputTextTokenInfo(token, this.locationEvent));
    }

    public Token getCurrentToken() {
        DBInputTextTokenInfo info = this.indexToTokenInfoMap.get(this.getCurrentTokenIndex());
        if (info == null) {
            return null;
        }
        return info.token;
    }

    public String renderTokensText() {
        this.currentTokenIndexInText = 0;
        StringBuilder text = new StringBuilder();
        for (Integer idx : this.inputTokenIndexes) {
            DBInputTextTokenInfo info = this.indexToTokenInfoMap.get(idx);
            info.setStart(text.length());
            text.append(info.getText());
            if (idx.intValue() != this.getCurrentTokenIndex()) continue;
            this.currentTokenIndexInText = info.start;
        }
        return text.toString();
    }

    public void render() {
        String text = this.renderTokensText();
        this.textPane.setText(text);
        this.textPane.getStyledDocument().setCharacterAttributes(0, text.length(), SimpleAttributeSet.EMPTY, true);
        for (Integer idx : this.inputTokenIndexes) {
            DBInputTextTokenInfo info = this.indexToTokenInfoMap.get(idx);
            AttributeSet attribute = this.indexToConsumeAttributeMap.get(idx);
            if (attribute == null) {
                attribute = this.attributeNonConsumed;
            }
            if (this.lookaheadTokenIndexes.contains(idx)) {
                attribute = this.attributeLookahead;
            }
            this.textPane.getStyledDocument().setCharacterAttributes(info.start, info.end, attribute, true);
        }
    }

    public void updateOnBreakEvent() {
        this.render();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Rectangle r = DBInputProcessorToken.this.textPane.modelToView(DBInputProcessorToken.this.currentTokenIndexInText);
                    if (r != null) {
                        DBInputProcessorToken.this.textPane.scrollRectToVisible(r);
                    }
                }
                catch (BadLocationException e) {
                    DBInputProcessorToken.this.debuggerTab.getConsole().println(e);
                }
            }
        });
    }

    public void createTextAttributes() {
        this.attributeNonConsumed = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeNonConsumed, AWPrefs.getNonConsumedTokenColor());
        this.attributeConsume = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeConsume, AWPrefs.getConsumedTokenColor());
        this.attributeConsumeHidden = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeConsumeHidden, AWPrefs.getHiddenTokenColor());
        this.attributeConsumeDead = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeConsumeDead, AWPrefs.getDeadTokenColor());
        this.attributeLookahead = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeLookahead, AWPrefs.getLookaheadTokenColor());
        StyleConstants.setItalic(this.attributeLookahead, true);
    }

    public void textPaneDidPaint(Graphics g) {
        for (DBInputTextTokenInfo info : this.indexToTokenInfoMap.values()) {
            if (this.drawTokensBox) {
                this.drawToken(info, (Graphics2D)g, Color.red, false);
            }
            if (this.inputBreakpointIndexes.contains(info.token.getTokenIndex())) {
                this.drawToken(info, (Graphics2D)g, INPUT_BREAKPOINT_COLOR, true);
                continue;
            }
            if (this.mouseIndex < info.start || this.mouseIndex >= info.end) continue;
            this.drawToken(info, (Graphics2D)g, HIGHLIGHTED_COLOR, true);
        }
    }

    public void drawToken(DBInputTextTokenInfo info, Graphics2D g, Color c, boolean fill) {
        g.setColor(c);
        try {
            Rectangle r1 = this.textPane.modelToView(info.start);
            Rectangle r2 = this.textPane.modelToView(info.end);
            if (r2.y > r1.y) {
                GeneralPath gp = new GeneralPath();
                Area area = new Area();
                for (int index = info.start; index < info.end; ++index) {
                    Rectangle r = this.textPane.modelToView(index);
                    r.width = Math.max(0, this.textPane.modelToView((int)(index + 1)).x - r.x);
                    area.add(new Area(r));
                }
                gp.append(area, true);
                if (fill) {
                    g.fill(gp);
                } else {
                    g.draw(gp);
                }
            } else if (fill) {
                g.fillRect(r1.x, r1.y, r2.x - r1.x, r1.height);
            } else {
                g.drawRect(r1.x, r1.y, r2.x - r1.x, r1.height);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public DBInputTextTokenInfo getTokenInfoAtTokenIndex(int index) {
        return this.indexToTokenInfoMap.get(index);
    }

    public DBInputTextTokenInfo getTokenInfoAtPositionIndex(int index) {
        for (DBInputTextTokenInfo info : this.indexToTokenInfoMap.values()) {
            if (index < info.start || index >= info.end) continue;
            return info;
        }
        return null;
    }

    public boolean isBreakpointAtToken(Token token) {
        return this.inputBreakpointIndexes.contains(token.getTokenIndex());
    }

    public void highlightToken(int index) {
        this.mouseIndex = index;
        this.textPane.repaint();
    }

    public void selectToken(Token t) {
        if (t == null) {
            this.highlightToken(-1);
            return;
        }
        DBInputTextTokenInfo info = this.getTokenInfoForToken(t);
        if (info != null) {
            this.highlightToken(info.start);
        } else {
            this.highlightToken(-1);
        }
    }

    public DBInputTextTokenInfo getTokenInfoForToken(Token t) {
        for (DBInputTextTokenInfo info : this.indexToTokenInfoMap.values()) {
            if (info.token.getTokenIndex() != t.getTokenIndex() || info.token.getType() != t.getType()) continue;
            return info;
        }
        return null;
    }

    public void notificationFire(Object source, String name) {
        if (name.equals("NOTIF_PREFS_APPLIED")) {
            this.createTextAttributes();
        }
    }

    protected class MyMouseMotionListener
    extends MouseMotionAdapter {
        protected MyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent e) {
            DBInputProcessorToken.this.mouseIndex = DBInputProcessorToken.this.textPane.getTextIndexAtLocation(e.getPoint());
            DBInputProcessorToken.this.textPane.repaint();
        }
    }

    protected class MyMouseListener
    extends MouseAdapter {
        protected MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            boolean shiftKey;
            DBInputProcessorToken.this.highlightToken(DBInputProcessorToken.this.textPane.getTextIndexAtLocation(e.getPoint()));
            if (DBInputProcessorToken.this.mouseIndex == -1) {
                return;
            }
            DBInputTextTokenInfo info = DBInputProcessorToken.this.getTokenInfoAtPositionIndex(DBInputProcessorToken.this.mouseIndex);
            if (info == null) {
                return;
            }
            boolean bl = shiftKey = (e.getModifiersEx() & 0x40) == 64;
            if (e.getButton() == 1 && !shiftKey) {
                DBInputProcessorToken.this.debuggerTab.selectToken(info.token, info.getLocation());
            } else {
                Integer index = info.token.getTokenIndex();
                if (DBInputProcessorToken.this.inputBreakpointIndexes.contains(index)) {
                    DBInputProcessorToken.this.inputBreakpointIndexes.remove(index);
                } else {
                    DBInputProcessorToken.this.inputBreakpointIndexes.add(index);
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            DBInputProcessorToken.this.highlightToken(-1);
        }
    }
}

