/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor.tips;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.editor.tips.TipsOverlay;
import org.antlr.works.editor.tips.TipsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TipsManager {
    protected List<TipsProvider> providers = new ArrayList<TipsProvider>();
    protected TipsOverlay overlay;
    protected int lastPosition;
    protected boolean enabled = true;

    public void setOverlay(TipsOverlay overlay) {
        this.overlay = overlay;
    }

    public void addProvider(TipsProvider provider) {
        this.providers.add(provider);
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        if (!this.enabled) {
            this.hide();
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void displayAnyTipsAvailable(int position, Point location) {
        if (!this.enabled) {
            return;
        }
        if (location == null) {
            this.hide();
            return;
        }
        if (position == this.lastPosition) {
            return;
        }
        this.lastPosition = position;
        List<String> tips = this.generateTips(position);
        if (tips == null || tips.isEmpty()) {
            this.hide();
        } else {
            this.overlay.setTips(tips);
            this.overlay.setLocation(location);
            this.overlay.display();
        }
    }

    public void hide() {
        this.overlay.hide();
        this.lastPosition = -1;
    }

    public List<String> generateTips(int position) {
        ArrayList<String> tips = new ArrayList<String>();
        for (TipsProvider provider : this.providers) {
            List<String> ptips = provider.tipsProviderGetTips(position);
            if (ptips == null || ptips.isEmpty()) continue;
            tips.addAll(ptips);
        }
        return tips;
    }

    public void close() {
        this.overlay.close();
    }
}

