/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stats;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.appkit.app.XJApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsAW {
    protected static StatisticsAW shared = new StatisticsAW();
    protected static final String PREF_KEY = "CURSOR_BLINK_2";
    protected static final String PREF_KEY_FROM_DATE = "DATE_BLINK_2";
    public static final int EVENT_EXPORT_AS_BITMAP = 0;
    public static final int EVENT_EXPORT_AS_EPS = 1;
    public static final int EVENT_EXPORT_AS_DOT = 2;
    public static final int EVENT_EXPORT_EVENTS_AS_TEXT = 3;
    public static final int EVENT_FIND_DIALOG = 10;
    public static final int EVENT_FIND_NEXT = 11;
    public static final int EVENT_FIND_PREVIOUS = 12;
    public static final int EVENT_FIND_TEXT_AT_CARET = 13;
    public static final int EVENT_FIND_USAGES = 14;
    public static final int EVENT_GOTO_RULE = 20;
    public static final int EVENT_GOTO_DECLARATION = 21;
    public static final int EVENT_GOTO_LINE = 22;
    public static final int EVENT_GOTO_CHAR = 23;
    public static final int EVENT_GOTO_BACK = 24;
    public static final int EVENT_GOTO_FORWARD = 25;
    public static final int EVENT_GOTO_PREV_BRKPT = 26;
    public static final int EVENT_GOTO_NEXT_BRKPT = 27;
    public static final int EVENT_SHOW_TOKENS_SD = 40;
    public static final int EVENT_SHOW_TOKENS_DFA = 41;
    public static final int EVENT_SHOW_DECISION_DFA = 42;
    public static final int EVENT_SHOW_RULE_DEPENDENCY = 44;
    public static final int EVENT_RULE_GROUP = 45;
    public static final int EVENT_RULE_UNGROUP = 46;
    public static final int EVENT_CHECK_GRAMMAR = 47;
    public static final int EVENT_RENAME = 60;
    public static final int EVENT_REPLACE_LITERALS = 61;
    public static final int EVENT_REMOVE_LEFT_RECURSION = 62;
    public static final int EVENT_REMOVE_ALL_LEFT_RECURSION = 63;
    public static final int EVENT_EXTRACT_RULE = 64;
    public static final int EVENT_INLINE_RULE = 65;
    public static final int EVENT_CONVERT_LITERALS_TO_SINGLE = 66;
    public static final int EVENT_CONVERT_LITERALS_TO_DOUBLE = 67;
    public static final int EVENT_CONVERT_LITERALS_TO_CSTYLE = 68;
    public static final int EVENT_GENERATE_CODE = 80;
    public static final int EVENT_SHOW_PARSER_GENERATED_CODE = 81;
    public static final int EVENT_SHOW_LEXER_GENERATED_CODE = 82;
    public static final int EVENT_SHOW_RULE_GENERATED_CODE = 83;
    public static final int EVENT_INTERPRETER_MENU = 90;
    public static final int EVENT_INTERPRETER_BUTTON = 91;
    public static final int EVENT_LOCAL_DEBUGGER = 92;
    public static final int EVENT_LOCAL_DEBUGGER_BUILD = 93;
    public static final int EVENT_REMOTE_DEBUGGER = 94;
    public static final int EVENT_TOGGLE_SYNTAX_COLORING = 120;
    public static final int EVENT_TOGGLE_SYNTAX_DIAGRAM = 121;
    public static final int EVENT_TOGGLE_IDEAS = 122;
    public static final int EVENT_TOGGLE_RULE_SORT = 123;
    public static final int EVENT_SHOW_PREFERENCES = 130;
    public static final int EVENT_SHOW_HELP = 131;
    public static final int EVENT_CHECK_FOR_UPDATES = 132;
    public static final int EVENT_SHOW_AUTO_COMPLETION_MENU = 133;
    public static final int EVENT_DROP_RULE = 134;
    public static final int EVENT_TOGGLE_SD_NFA = 135;
    public static final int EVENT_DEBUGGER_STOP = 140;
    public static final int EVENT_DEBUGGER_STEP_BACK = 141;
    public static final int EVENT_DEBUGGER_STEP_FORWARD = 142;
    public static final int EVENT_DEBUGGER_STEP_OVER = 143;
    public static final int EVENT_DEBUGGER_FAST_FORWARD = 144;
    public static final int EVENT_DEBUGGER_GOTO_START = 145;
    public static final int EVENT_DEBUGGER_GOTO_END = 146;
    public static final int EVENT_DEBUGGER_TOGGLE_INPUT_TOKENS = 147;
    static final Map<Integer, String> eventNames = new HashMap<Integer, String>();
    static final List<Integer> eventList = new ArrayList<Integer>();
    protected Map<Integer, Integer> events = null;

    static void register(int eventID, String eventName) {
        eventNames.put(eventID, eventName);
        eventList.add(eventID);
    }

    public static StatisticsAW shared() {
        return shared;
    }

    public void reset() {
        if (this.events != null) {
            this.events.clear();
        }
        this.initDate();
    }

    public void initDate() {
        this.setFromDate(new Date().toString());
    }

    public void setFromDate(String date) {
        AWPrefs.getPreferences().setString(PREF_KEY_FROM_DATE, date);
    }

    public String getFromDate() {
        return AWPrefs.getPreferences().getString(PREF_KEY_FROM_DATE, null);
    }

    public void close() {
        AWPrefs.getPreferences().setObject(PREF_KEY, this.events);
    }

    public void recordEvent(int event) {
        this.setCount(event, this.getCount(event) + 1);
    }

    protected void setCount(int event, int count) {
        this.getEvents().put(event, count);
    }

    protected int getCount(int event) {
        Integer count = this.getEvents().get(event);
        if (count == null) {
            return 0;
        }
        return count;
    }

    protected synchronized Map<Integer, Integer> getEvents() {
        if (this.events == null) {
            try {
                this.events = (Map)AWPrefs.getPreferences().getObject(PREF_KEY, null);
            }
            catch (Exception e) {
                this.events = null;
                System.err.println("Statistics: " + e);
            }
            if (this.events == null) {
                this.events = new HashMap<Integer, Integer>();
                this.initDate();
            }
        }
        return this.events;
    }

    public String getRawString() {
        StringBuilder s = new StringBuilder();
        s.append(XJApplication.getAppVersionShort());
        s.append('\t');
        Iterator<Integer> iterator = eventList.iterator();
        while (iterator.hasNext()) {
            Integer key = iterator.next();
            s.append(this.getCount(key));
            if (!iterator.hasNext()) continue;
            s.append('\t');
        }
        return s.toString();
    }

    public String getReadableString() {
        StringBuilder s = new StringBuilder();
        s.append("Version: ");
        s.append(XJApplication.getAppVersionShort());
        s.append('\n');
        Iterator<Integer> iterator = eventList.iterator();
        while (iterator.hasNext()) {
            Integer key = iterator.next();
            s.append(eventNames.get(key));
            s.append(": ");
            s.append(this.getCount(key));
            if (!iterator.hasNext()) continue;
            s.append('\n');
        }
        return s.toString();
    }

    static {
        StatisticsAW.register(0, "Export as bitmap");
        StatisticsAW.register(1, "Export as EPS");
        StatisticsAW.register(2, "Export as DOT");
        StatisticsAW.register(3, "Export events as text");
        StatisticsAW.register(10, "Find dialog");
        StatisticsAW.register(11, "Find next");
        StatisticsAW.register(12, "Find previous");
        StatisticsAW.register(13, "Find text at caret");
        StatisticsAW.register(14, "Find usages");
        StatisticsAW.register(20, "Goto rule");
        StatisticsAW.register(21, "Goto declaration");
        StatisticsAW.register(22, "Goto line");
        StatisticsAW.register(23, "Goto character");
        StatisticsAW.register(24, "Goto back");
        StatisticsAW.register(25, "Goto forward");
        StatisticsAW.register(26, "Goto previous breakpoint");
        StatisticsAW.register(27, "Goto next breakpoint");
        StatisticsAW.register(40, "Show tokens syntax diagram");
        StatisticsAW.register(41, "Show tokens DFA");
        StatisticsAW.register(42, "Show decision DFA");
        StatisticsAW.register(44, "Show rule dependency");
        StatisticsAW.register(45, "Group rule");
        StatisticsAW.register(46, "Ungroup rule");
        StatisticsAW.register(47, "Check grammar");
        StatisticsAW.register(60, "Rename");
        StatisticsAW.register(61, "Replace literals");
        StatisticsAW.register(62, "Remove left recursion");
        StatisticsAW.register(63, "Remove all left recursion");
        StatisticsAW.register(64, "Extract rule");
        StatisticsAW.register(65, "Inline rule");
        StatisticsAW.register(66, "Convert literals to single quote");
        StatisticsAW.register(67, "Convert literals to double quote");
        StatisticsAW.register(68, "Convert literals to C-style quote");
        StatisticsAW.register(80, "Generate code");
        StatisticsAW.register(81, "Show parser code");
        StatisticsAW.register(82, "Show lexer code");
        StatisticsAW.register(83, "Show rule code");
        StatisticsAW.register(90, "Interpreter (menu)");
        StatisticsAW.register(91, "Interpreter (button)");
        StatisticsAW.register(92, "Debug");
        StatisticsAW.register(93, "Build and debug");
        StatisticsAW.register(94, "Remote debug");
        StatisticsAW.register(120, "Toggle syntax coloring");
        StatisticsAW.register(121, "Toggle syntax diagram");
        StatisticsAW.register(122, "Toggle ideas");
        StatisticsAW.register(123, "Toggle rule sort");
        StatisticsAW.register(130, "Show preferences");
        StatisticsAW.register(131, "Show help");
        StatisticsAW.register(132, "Check for updates");
        StatisticsAW.register(133, "Show auto-completion");
        StatisticsAW.register(134, "Drop rule (tree)");
        StatisticsAW.register(135, "Toggle syntax diagram/NFA");
        StatisticsAW.register(140, "Debugger stop");
        StatisticsAW.register(141, "Debugger step back");
        StatisticsAW.register(142, "Debugger step forward");
        StatisticsAW.register(143, "Debugger step over");
        StatisticsAW.register(144, "Debugger fast forward");
        StatisticsAW.register(145, "Debugger goto start");
        StatisticsAW.register(146, "Debugger goto end");
        StatisticsAW.register(147, "Debugger toggle input tokens");
    }
}

