/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stringtemplate;

import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import org.antlr.works.IDE;
import org.antlr.works.menu.ActionRefactor;
import org.antlr.works.menu.FindMenu;
import org.antlr.works.menu.GoToMenu;
import org.antlr.works.menu.STRefactorMenu;
import org.antlr.works.stringtemplate.STWindow;
import org.antlr.works.stringtemplate.menu.ContextualStringTemplateMenuFactory;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;

public class STWindowMenu
implements XJMenuItemDelegate {
    public static final int MI_PRINT = 5;
    public static final int MI_FIND = 30;
    public static final int MI_FIND_NEXT = 31;
    public static final int MI_FIND_PREV = 32;
    public static final int MI_FIND_TOKEN = 33;
    public static final int MI_GOTO_RULE = 40;
    public static final int MI_GOTO_DECLARATION = 41;
    public static final int MI_GOTO_LINE = 42;
    public static final int MI_GOTO_CHARACTER = 43;
    public static final int MI_GOTO_BACK = 44;
    public static final int MI_GOTO_FORWARD = 45;
    public static final int MI_RENAME = 61;
    public static final int MI_INLINE_RULE = 69;
    public static final int MI_SUBMIT_STATS = 100;
    public static final int MI_SEND_FEEDBACK = 101;
    public static final int MI_CHECK_UPDATES = 102;
    public static final int MI_SORT_RULES = 110;
    private FindMenu actionFind;
    private GoToMenu actionGoTo;
    private ActionRefactor actionRefactor;
    private STWindow window;
    private static ResourceBundle resourceBundle = IDE.getMenusResourceBundle();

    public STWindowMenu(STWindow window) {
        this.window = window;
        this.actionFind = new FindMenu(window);
        this.actionGoTo = new GoToMenu(window);
        this.actionRefactor = new STRefactorMenu(window);
    }

    public void close() {
        this.window = null;
    }

    public void customizeFileMenu(XJMenu menu) {
        menu.insertItemAfter(new XJMenuItem(resourceBundle.getString("menu.item.print"), 80, 5, this), 10003);
        menu.insertSeparatorAfter(10003);
    }

    public void customizeMenuBar(XJMainMenuBar menubar) {
        this.createFindMenu(menubar);
        this.createGoToMenu(menubar);
        this.createRefactorMenu(menubar);
    }

    private void createGoToMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.goto"));
        menu.addItem(this.createMenuItem(40));
        menu.addItem(this.createMenuItem(41));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoLine"), 71, 42, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoCharacter"), 43, this));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoBack"), 37, XJMenuItem.getKeyModifier() | 8, 44, (XJMenuItemDelegate)this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoForward"), 39, XJMenuItem.getKeyModifier() | 8, 45, (XJMenuItemDelegate)this));
        menubar.addCustomMenu(menu);
    }

    private void createRefactorMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.refactor"));
        menu.addItem(this.createMenuItem(61));
        menubar.addCustomMenu(menu);
    }

    private void createFindMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.find"));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.find"), 70, 30, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.findNext"), 114, 0, 31, (XJMenuItemDelegate)this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.findPrevious"), 114, 1, 32, (XJMenuItemDelegate)this));
        menu.addItem(this.createMenuItem(33));
        menubar.addCustomMenu(menu);
    }

    public XJMenuItem createMenuItem(int tag) {
        return this.createMenuItem(tag, false);
    }

    public XJMenuItem createMenuItem(int tag, boolean contextual) {
        XJMenuItem item = null;
        switch (tag) {
            case 33: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.findTextAtCaret"), 114, 33, this);
                break;
            }
            case 40: {
                item = new XJMenuItem(contextual ? resourceBundle.getString("contextual.item.gotoRule") : resourceBundle.getString("menu.item.gotoRule"), 66, XJMenuItem.getKeyModifier() | 1, 40, (XJMenuItemDelegate)this);
                break;
            }
            case 41: {
                item = new XJMenuItem(contextual ? resourceBundle.getString("contextual.item.goToDeclaration") : resourceBundle.getString("menu.item.gotoDeclaration"), 66, 41, this);
                break;
            }
            case 61: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.rename"), 117, 1, 61, (XJMenuItemDelegate)this);
                break;
            }
            case 69: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.inlineRule"), 69, this);
                break;
            }
            case 110: {
                item = new XJMenuItemCheck(resourceBundle.getString("menu.item.sortRules"), 110, this, false);
            }
        }
        return item;
    }

    public void menuItemState(XJMenuItem item) {
        switch (item.getTag()) {
            case 10025: 
            case 10027: {
                item.setEnabled(this.window.isFileWritable());
                break;
            }
            case 44: {
                item.setEnabled(this.window.goToHistory.canGoBack());
                break;
            }
            case 45: {
                item.setEnabled(this.window.goToHistory.canGoForward());
            }
        }
    }

    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
        this.handleMenuFile(item.getTag());
        this.handleMenuFind(item.getTag());
        this.handleMenuRefactor(item.getTag());
        this.handleMenuGoTo(item.getTag());
        this.handleSortRules(item.getTag());
    }

    public void handleMenuFile(int itemTag) {
        switch (itemTag) {
            case 5: {
                this.window.print();
            }
        }
    }

    public void handleMenuFind(int itemTag) {
        switch (itemTag) {
            case 30: {
                this.actionFind.find();
                break;
            }
            case 31: {
                this.actionFind.findNext();
                break;
            }
            case 32: {
                this.actionFind.findPrev();
                break;
            }
            case 33: {
                this.actionFind.findSelection();
            }
        }
    }

    public void handleMenuRefactor(int itemTag) {
        switch (itemTag) {
            case 61: {
                this.actionRefactor.rename();
                break;
            }
            case 69: {
                this.actionRefactor.inlineRule();
            }
        }
    }

    public void handleMenuGoTo(int itemTag) {
        switch (itemTag) {
            case 40: {
                this.actionGoTo.goToRule();
                break;
            }
            case 41: {
                this.actionGoTo.goToDeclaration();
                break;
            }
            case 42: {
                this.actionGoTo.goToLine();
                break;
            }
            case 43: {
                this.actionGoTo.goToCharacter();
                break;
            }
            case 44: {
                this.actionGoTo.goToBackward();
                break;
            }
            case 45: {
                this.actionGoTo.goToForward();
            }
        }
    }

    public void handleSortRules(int itemTag) {
        switch (itemTag) {
            case 110: {
                this.window.toggleRulesSorting();
            }
        }
    }

    public ActionRefactor getActionRefactor() {
        return this.actionRefactor;
    }

    public GoToMenu getActionGoTo() {
        return this.actionGoTo;
    }

    public JPopupMenu getContextualMenu(int textIndex) {
        boolean overReference = this.window.getCurrentReference() != null;
        boolean overToken = this.window.getCurrentToken() != null;
        boolean overSelection = this.window.getTextPane().getSelectionStart() != this.window.getTextPane().getSelectionEnd();
        ContextualStringTemplateMenuFactory factory = new ContextualStringTemplateMenuFactory(this);
        factory.addItem(40);
        if (overReference) {
            factory.addItem(41);
        }
        factory.addSeparator();
        if (overToken) {
            factory.addItem(61);
        }
        if (overToken) {
            factory.addSeparator();
            if (overSelection) {
                factory.addItem(33);
            }
        }
        return factory.menu;
    }
}

