/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.utils;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileFilter;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJFileChooser {
    private static XJFileChooser shared = new XJFileChooser();
    private List<String> selectedFilePaths = null;
    private String selectedFilePath = null;
    private String selectedFileExtension = null;
    private static final String DEFAULT_DIR = "xjfilechooser.default.dir";

    public static XJFileChooser shared() {
        return shared;
    }

    public boolean displayOpenDialog(Component parent, boolean multiple) {
        return this.displayOpenDialog(parent, null, (List<String>)null, false);
    }

    public boolean displayOpenDialog(Component parent, String extension, String description, boolean multiple) {
        return this.displayOpenDialog(parent, Collections.singletonList(extension), Collections.singletonList(description), multiple);
    }

    public boolean displayOpenDialog(Component parent, List extensions, String description, boolean multiple) {
        return this.displayOpenDialog(parent, Collections.singletonList(extensions), Collections.singletonList(description), multiple);
    }

    public boolean displayOpenDialog(Component parent, List extensions, List<String> descriptions, boolean multiple) {
        if (parent != null) {
            parent = XJDialog.resolveOwner(parent.getParent());
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(multiple);
        if (extensions == null || extensions.size() == 0) {
            chooser.setAcceptAllFileFilterUsed(true);
        } else {
            for (int i = 0; i < extensions.size(); ++i) {
                XJFileFilter ff = XJFileFilter.createFileFilter(extensions.get(i), descriptions.get(i));
                chooser.addChoosableFileFilter(ff);
                if (extensions.size() != 1 || i != 0) continue;
                chooser.setFileFilter(ff);
            }
            if (extensions.size() > 1) {
                chooser.setFileFilter(chooser.getAcceptAllFileFilter());
            }
        }
        this.loadDefaultDirectory(chooser);
        if (chooser.showOpenDialog(parent == null ? null : parent) == 0) {
            FileFilter ff;
            this.selectedFilePath = chooser.getSelectedFile().getAbsolutePath();
            this.selectedFilePaths = this.filesToList(chooser.getSelectedFiles());
            if (extensions != null && extensions.size() >= 0 && (ff = chooser.getFileFilter()) instanceof XJFileFilter) {
                XJFileFilter filter = (XJFileFilter)ff;
                if (this.selectedFilePath.indexOf(".") == -1) {
                    this.selectedFilePath = this.selectedFilePath + "." + filter.getDefaultExtension();
                }
            }
            this.saveCurrentDirectory(chooser);
            return true;
        }
        return false;
    }

    private void loadDefaultDirectory(JFileChooser chooser) {
        File dir;
        String currentDir = XJApplication.shared().getPreferences().getString(DEFAULT_DIR, null);
        if (currentDir != null && (dir = new File(currentDir)).exists()) {
            chooser.setCurrentDirectory(dir);
        }
    }

    private void saveCurrentDirectory(JFileChooser chooser) {
        String dir = chooser.getSelectedFile().getAbsolutePath();
        if (!chooser.getSelectedFile().isDirectory()) {
            dir = XJUtils.getPathByDeletingLastComponent(chooser.getSelectedFile().getAbsolutePath());
        }
        XJApplication.shared().getPreferences().setString(DEFAULT_DIR, dir);
    }

    private List<String> filesToList(File[] files) {
        ArrayList<String> array = new ArrayList<String>();
        for (File file : files) {
            array.add(file.getAbsolutePath());
        }
        return array;
    }

    public boolean displaySaveDialog(Component parent, String extension, String extensionDescription, boolean acceptAll) {
        return this.displaySaveDialog(parent, Collections.singletonList(extension), Collections.singletonList(extensionDescription), acceptAll);
    }

    public boolean displaySaveDialog(Component parent, List extensions, String extensionDescription, boolean acceptAll) {
        return this.displaySaveDialog(parent, Collections.singletonList(extensions), Collections.singletonList(extensionDescription), acceptAll);
    }

    public boolean displaySaveDialog(Component parent, List extensions, List<String> descriptions, boolean acceptAll) {
        if (parent != null) {
            parent = XJDialog.resolveOwner(parent.getParent());
        }
        JFileChooser chooser = new JFileChooser();
        this.applyExtensions(extensions, chooser, acceptAll, descriptions);
        this.loadDefaultDirectory(chooser);
        if (chooser.showSaveDialog(parent) == 0) {
            this.selectedFilePath = chooser.getSelectedFile().getAbsolutePath();
            this.selectedFilePaths = this.filesToList(chooser.getSelectedFiles());
            this.selectedFileExtension = this.getExtension(extensions, chooser);
            if (this.selectedFileExtension != null && !this.selectedFilePath.endsWith("." + this.selectedFileExtension)) {
                this.selectedFilePath = this.selectedFilePath + "." + this.selectedFileExtension;
            }
            if (new File(this.selectedFilePath).exists()) {
                String name = XJUtils.getLastPathComponent(this.selectedFilePath);
                if (XJAlert.displayAlert(parent, "Warning", "The file '" + name + "' already exists. Do you want to replace it?", "Cancel", "Replace", 1, 0) == 0) {
                    return false;
                }
            }
            this.saveCurrentDirectory(chooser);
            return true;
        }
        return false;
    }

    public boolean displayChooseDirectory(Component parent) {
        return this.displayChooseDirectory(parent, null, null, true);
    }

    public boolean displayChooseDirectory(Component parent, List extensions, List<String> descriptions, boolean acceptAll) {
        JDialog dialog;
        boolean result;
        if (parent != null) {
            parent = XJDialog.resolveOwner(parent.getParent());
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select a directory");
        this.applyExtensions(extensions, chooser, acceptAll, descriptions);
        this.loadDefaultDirectory(chooser);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(parent) == 0) {
            this.selectedFilePath = chooser.getSelectedFile().getAbsolutePath();
            this.selectedFileExtension = this.getExtension(extensions, chooser);
            if (!new File(this.selectedFilePath).exists()) {
                if (XJAlert.displayAlert(parent, "Directory does not exist", "This directory does not exist. ANTLRWorks will create it if you choose to continue.", "Cancel", "Continue", 1, 0) == 1) {
                    new File(this.selectedFilePath).mkdirs();
                    this.saveCurrentDirectory(chooser);
                    result = true;
                } else {
                    result = false;
                }
            } else {
                this.saveCurrentDirectory(chooser);
                result = true;
            }
        } else {
            result = false;
        }
        if (parent instanceof JDialog && (dialog = (JDialog)parent).isModal()) {
            dialog.toFront();
        }
        return result;
    }

    private String getExtension(List extensions, JFileChooser chooser) {
        XJFileFilter filter;
        FileFilter ff;
        if (extensions != null && extensions.size() >= 0 && (ff = chooser.getFileFilter()) instanceof XJFileFilter && !(filter = (XJFileFilter)ff).accept(this.selectedFilePath)) {
            return filter.getDefaultExtension();
        }
        return XJUtils.getPathExtension(this.selectedFilePath);
    }

    private void applyExtensions(List extensions, JFileChooser chooser, boolean acceptAll, List<String> descriptions) {
        if (extensions == null || extensions.size() == 0) {
            chooser.setAcceptAllFileFilterUsed(acceptAll);
        } else {
            chooser.setAcceptAllFileFilterUsed(acceptAll);
            XJFileFilter firstFF = null;
            for (int i = 0; i < extensions.size(); ++i) {
                XJFileFilter ff = XJFileFilter.createFileFilter(extensions.get(i), descriptions.get(i));
                chooser.addChoosableFileFilter(ff);
                if (extensions.size() != 1 && acceptAll || i != 0) continue;
                firstFF = ff;
            }
            if (extensions.size() > 1 && acceptAll) {
                chooser.setFileFilter(chooser.getAcceptAllFileFilter());
            } else {
                chooser.setFileFilter(firstFF);
            }
        }
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public List<String> getSelectedFilePaths() {
        return this.selectedFilePaths;
    }

    public String getSelectedFileExtension() {
        return this.selectedFileExtension;
    }

    static {
        if (XJSystem.isMacOS()) {
            UIManager.put("JFileChooser.appBundleIsTraversable", "always");
            UIManager.put("JFileChooser.packageIsTraversable", "always");
        }
    }
}

