/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.foundation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.antlr.xjlib.foundation.XJSystem;

public class XJUtils {
    public static final String VERSION_EA = "ea";
    public static final String VERSION_BETA = "b";

    public static String concatPath(String a, String b, String separator) {
        if (a.endsWith(separator) && b.startsWith(separator)) {
            return a + b.substring(1);
        }
        if (a.endsWith(separator)) {
            return a + b;
        }
        if (b.startsWith(separator)) {
            return a + b;
        }
        return a + separator + b;
    }

    public static String concatPath(String a, String b) {
        return XJUtils.concatPath(a, b, File.separator);
    }

    public static String getLastPathComponent(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(File.separator);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1, path.length());
    }

    public static String getPathByDeletingPathExtension(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String getPathExtension(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return path.substring(index + 1);
    }

    public static String getPathByDeletingLastComponent(String path, String separator) {
        int index;
        if (path == null) {
            return null;
        }
        if (path.endsWith(separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = path.lastIndexOf(separator)) == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String getPathByDeletingLastComponent(String path) {
        return XJUtils.getPathByDeletingLastComponent(path, File.separator);
    }

    public static List sortedFilesInPath(String path) {
        File[] files = new File(path).listFiles();
        List<File> sortedFiles = Arrays.asList(files);
        Collections.sort(sortedFiles);
        return sortedFiles;
    }

    public static String escapeString(String a) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < a.length(); ++i) {
            char c2;
            char c1 = a.charAt(i);
            char c = c2 = i + 1 < a.length() ? a.charAt(i + 1) : (char)'\u0000';
            if (c1 == '\\' && c2 != '\\') {
                b.append('\\');
                b.append('\\');
                continue;
            }
            if (c1 == '\\') {
                b.append('\\');
                b.append('\\');
                ++i;
                continue;
            }
            b.append(c1);
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object clone(Object object) throws Exception {
        Object copy = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            copy = ois.readObject();
        }
        finally {
            if (ois != null) {
                ois.close();
            }
            if (oos != null) {
                oos.close();
            }
        }
        return copy;
    }

    public static void writeStringToFile(String text, String file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        ((OutputStream)os).write(text.getBytes());
        ((OutputStream)os).close();
    }

    public static String getStringFromFile(String file) throws IOException {
        char[] data = null;
        InputStreamReader fr = null;
        try {
            int count;
            int actual;
            File f = new File(file);
            int max = (int)f.length();
            char[] tmp = new char[max];
            fr = new FileReader(f);
            for (count = 0; count < max && (actual = fr.read(tmp, count, max - count)) != -1; count += actual) {
            }
            if (count == max) {
                data = tmp;
            } else {
                data = new char[count];
                System.arraycopy(tmp, 0, data, 0, count);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new String(data);
    }

    protected static int[] parseVersionElement(String e) {
        int[] v = new int[]{0, 0, 0};
        int index = e.indexOf(VERSION_EA);
        if (index > 0) {
            v[0] = Integer.parseInt(e.substring(0, index));
            v[1] = -2;
            v[2] = Integer.parseInt(e.substring(index + VERSION_EA.length()));
        } else {
            index = e.indexOf(VERSION_BETA);
            if (index > 0) {
                v[0] = Integer.parseInt(e.substring(0, index));
                v[1] = -1;
                v[2] = Integer.parseInt(e.substring(index + VERSION_BETA.length()));
            } else {
                v[0] = Integer.parseInt(e);
            }
        }
        return v;
    }

    protected static int compareVersionElement(String a, String b) {
        int[] va = XJUtils.parseVersionElement(a);
        int[] vb = XJUtils.parseVersionElement(b);
        for (int i = 0; i < va.length; ++i) {
            if (va[i] < vb[i]) {
                return -1;
            }
            if (va[i] <= vb[i]) continue;
            return 1;
        }
        return 0;
    }

    public static boolean isVersionGreaterThan(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        String[] va = a.split("\\.");
        String[] vb = b.split("\\.");
        for (int i = 0; i < va.length; ++i) {
            if (i == vb.length) {
                return true;
            }
            switch (XJUtils.compareVersionElement(va[i], vb[i])) {
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return false;
    }

    public static String encodeToURL(String s) {
        return XJUtils.encodeToURL(s, "");
    }

    public static String encodeToURL(String s, String defaultString) {
        String encoded = defaultString;
        if (s != null && s.length() > 0) {
            try {
                encoded = URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("XJUtils:encodeToURL exception: " + e);
            }
        }
        return encoded;
    }

    public static String getNormalizedText(String text) {
        return XJUtils.getTextByReplacingEOL(text, "\n");
    }

    public static String getLocalizedText(String text) {
        return XJUtils.getTextByReplacingEOL(text, XJSystem.getLineSeparator());
    }

    public static String getTextByReplacingEOL(String text, String eol) {
        StringBuilder sb = new StringBuilder();
        int CR = 13;
        int LF = 10;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                sb.append(eol);
                continue;
            }
            if (c == '\r') {
                if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                    ++i;
                }
                sb.append(eol);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static boolean deleteDirectory(String dir) {
        return XJUtils.deleteDirectoryRecursively(new File(dir));
    }

    private static boolean deleteDirectoryRecursively(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = XJUtils.deleteDirectoryRecursively(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

