/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.swing;

import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.antlr.works.ate.ATEPanel;

public class ATEAutoIndentation
implements Runnable {
    protected int offset;
    protected int length;
    protected boolean enabled = true;
    protected ATEPanel textEditor;

    public ATEAutoIndentation(ATEPanel textEditor) {
        this.textEditor = textEditor;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void indent(int offset, int length) {
        this.offset = offset;
        this.length = length;
        if (this.enabled()) {
            SwingUtilities.invokeLater(this);
        }
    }

    public Document getDocument() {
        return this.textEditor.getTextPane().getDocument();
    }

    public boolean autoIndentAfterReturn() throws BadLocationException {
        String s = this.getDocument().getText(this.offset - 1, this.length + 1);
        if (s.length() == 0) {
            return false;
        }
        if (s.length() == 1 || s.charAt(0) != '\n' && s.charAt(1) == '\n') {
            String t = this.getDocument().getText(0, this.offset);
            for (int i = this.offset - 2; i >= 0; --i) {
                if (t.charAt(i) != '\n' && i != 0) continue;
                if (i > 0) {
                    ++i;
                }
                int start = i;
                while (i < this.offset - 1 && (t.charAt(i) == ' ' || t.charAt(i) == '\t')) {
                    ++i;
                }
                if (i == this.offset - 1 && (t.charAt(i) == ' ' || t.charAt(i) == '\t')) {
                    ++i;
                }
                this.getDocument().insertString(this.offset + 1, t.substring(start, i), null);
                return true;
            }
        }
        return false;
    }

    public void run() {
        try {
            if (!this.autoIndentAfterReturn()) {
                this.textEditor.ateAutoIndent(this.offset, this.length);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

