/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.local;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.antlr.works.IDE;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.debugger.DebuggerEngine;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.dialog.DebuggerInputDialog;
import org.antlr.works.dialog.DialogTestTemplate;
import org.antlr.works.generate.CodeGenerate;
import org.antlr.works.grammar.element.ElementBlock;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.utils.StreamWatcher;
import org.antlr.works.utils.StreamWatcherDelegate;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJUtils;

public class DBLocal
implements Runnable,
XJDialogProgressDelegate,
StreamWatcherDelegate {
    public static final String remoteParserClassName = "__Test__";
    public static final String parserGlueCodeTemplatePath = "templates/";
    public static final String parserGlueCodeTemplateName = "DBParserGlueCode";
    public static final String treeParserGlueCodeTemplateName = "DBTreeParserGlueCode";
    public static final String testRigTemplateSuffix = "__testrig";
    public static final String ST_ATTR_IMPORT = "import";
    public static final String ST_ATTR_CLASSNAME = "class_name";
    public static final String ST_ATTR_INPUT_FILE = "input_file";
    public static final String ST_ATTR_JAVA_PARSER = "java_parser";
    public static final String ST_ATTR_JAVA_LEXER = "java_lexer";
    public static final String ST_ATTR_START_SYMBOL = "start_symbol";
    public static final String ST_ATTR_GRAMMAR_NAME = "grammar_name";
    public static final String ST_ATTR_DEBUG_PORT = "port";
    protected String outputFileDir;
    protected List<String> grammarGeneratedFiles;
    protected String fileRemoteParser;
    protected String fileRemoteParserInputTextFile;
    protected String fileRemoteParserTemplateTextFile;
    protected String startRule;
    protected String lastStartRule;
    protected Process remoteParserProcess;
    protected boolean cancelled;
    protected int options;
    protected CodeGenerate codeGenerator;
    protected DebuggerTab debuggerTab;
    protected int inputMode;
    protected int lastInputMode;
    protected String testTemplateMode;
    protected String lastTestTemplateMode;
    protected String testTemplateClass;
    protected String lastTestTemplateClass;
    protected String inputFile;
    protected String lastInputFile;
    protected String testTemplateText;
    protected String lastTestTemplateText;
    protected String inputText;
    protected String rawInputText;
    protected XJDialogProgress progress;
    protected ErrorReporter error = new ErrorReporter();
    protected int debugPort = -1;
    protected boolean debugPortChanged = true;

    public DBLocal(DebuggerTab debuggerTab) {
        this.debuggerTab = debuggerTab;
    }

    public void close() {
        if (this.codeGenerator != null) {
            this.codeGenerator.close();
        }
        this.codeGenerator = null;
        this.debuggerTab = null;
    }

    public boolean canDebugAgain() {
        if (this.inputMode == 0) {
            return this.inputText != null;
        }
        return this.inputFile != null && new File(this.inputFile).exists();
    }

    public void dialogDidCancel() {
        this.cancel();
    }

    public void forceStop() {
        if (this.remoteParserProcess != null) {
            this.remoteParserProcess.destroy();
        }
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized boolean cancelled() {
        return this.cancelled;
    }

    public void showProgress() {
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.debuggerTab.getContainer());
        }
        this.progress.setInfo("Preparing...");
        this.progress.setIndeterminate(false);
        this.progress.setProgress(0);
        this.progress.setProgressMax(3);
        this.progress.setDelegate(this);
        this.progress.display();
    }

    public void hideProgress() {
        if (this.progress != null) {
            this.progress.close();
        }
    }

    private boolean optionBuild() {
        return (this.options & 2) > 0 || this.debugPortChanged;
    }

    private boolean optionAgain() {
        return (this.options & 1) > 0;
    }

    private boolean optionRun() {
        return (this.options & 4) > 0;
    }

    public void showEditTestRig() {
        DialogTestTemplate dialog = new DialogTestTemplate(this.debuggerTab, this.debuggerTab.getContainer());
        dialog.runModal();
    }

    public void prepareAndLaunch(int options) {
        this.options = options;
        this.cancelled = false;
        if (this.debugPort != AWPrefs.getDebugDefaultLocalPort()) {
            this.debugPort = AWPrefs.getDebugDefaultLocalPort();
            this.debugPortChanged = true;
        } else {
            this.debugPortChanged = false;
        }
        if (this.optionBuild()) {
            this.showProgress();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBLocal.this.startThread();
            }
        });
    }

    public void startThread() {
        new Thread(this).start();
    }

    public void run() {
        this.resetErrors();
        if (this.prepare()) {
            if (this.optionBuild()) {
                this.generateAndCompileGrammar();
            }
            if (!this.cancelled() && !this.optionAgain()) {
                this.askUserForInputText();
            }
            if (!this.cancelled() && !"class".equals(this.testTemplateMode)) {
                this.generateAndCompileGlueCode(this.optionBuild());
            }
            if (!this.cancelled()) {
                this.generateInputText();
            }
            if (!this.cancelled()) {
                this.launchRemoteParser();
            }
        }
        if (this.hasErrors()) {
            this.notifyErrors();
        } else if (this.cancelled()) {
            this.notifyCancellation();
        } else {
            this.notifyCompletion();
        }
    }

    protected void askUserForInputText() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DBLocal.this.hideProgress();
                    DebuggerInputDialog dialog = new DebuggerInputDialog(DBLocal.this.debuggerTab, DBLocal.this.debuggerTab.getContainer());
                    dialog.setInputText(DBLocal.this.rawInputText);
                    if (dialog.runModal() == 1) {
                        DBLocal.this.rawInputText = dialog.getRawInputText();
                        DBLocal.this.inputText = dialog.getInputText();
                        DBLocal.this.inputFile = dialog.getInputFile();
                        DBLocal.this.inputMode = dialog.getInputMode();
                        DBLocal.this.startRule = dialog.getRule();
                        DBLocal.this.showProgress();
                    } else {
                        DBLocal.this.cancel();
                    }
                }
            });
        }
        catch (Exception e) {
            this.debuggerTab.getConsole().println(e);
        }
    }

    protected void reportError(String message) {
        this.error.setTitle("Error");
        this.error.setMessage(message);
        this.error.enable();
        this.cancel();
    }

    protected void resetErrors() {
        this.error.reset();
    }

    protected boolean hasErrors() {
        return this.error.hasErrors;
    }

    protected void notifyErrors() {
        this.hideProgress();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (XJAlert.displayAlert(DBLocal.this.debuggerTab.getContainer(), DBLocal.this.error.title, DBLocal.this.error.message, "Show Console", "OK", 1, 1) == 0) {
                    DBLocal.this.debuggerTab.selectConsoleTab();
                }
            }
        });
    }

    protected void notifyCancellation() {
        this.hideProgress();
    }

    protected void notifyCompletion() {
        this.hideProgress();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean didRun = false;
                if (!DBLocal.this.cancelled()) {
                    didRun = DBLocal.this.debuggerTab.debuggerLocalDidRun(DBLocal.this.optionBuild());
                    if (DBLocal.this.optionRun() && didRun) {
                        DBLocal.this.runThroughRecorder();
                    }
                }
            }
        });
    }

    private void runThroughRecorder() {
        long t = System.currentTimeMillis();
        long timeout = AWPrefs.getDebugLaunchTimeout() * 1000;
        while (!this.debuggerTab.getRecorder().isAlive()) {
            if (System.currentTimeMillis() - t <= timeout) continue;
            return;
        }
        this.debuggerTab.getRecorder().goToEnd();
        while (!this.debuggerTab.getRecorder().isAtEnd() && this.debuggerTab.getRecorder().getStatus() != 0) {
        }
        this.debuggerTab.getRecorder().requestStop();
        this.debuggerTab.selectConsoleTab();
    }

    protected boolean prepare() {
        String testRigFullPath = "";
        String grammarIdentifier = "";
        String qualifiedFileName = this.debuggerTab.getDelegate().getDocument().getDocumentPath();
        if (qualifiedFileName != null) {
            testRigFullPath = XJUtils.getPathByDeletingPathExtension(qualifiedFileName) + testRigTemplateSuffix + ".st";
            grammarIdentifier = qualifiedFileName.toUpperCase();
        }
        try {
            this.testTemplateMode = AWPrefs.getTestRigTemplateMode(grammarIdentifier);
            this.testTemplateText = this.getTestRigTemplateFromFile(testRigFullPath);
            this.testTemplateClass = AWPrefs.getTestRigTemplateClass(grammarIdentifier);
            this.codeGenerator = this.debuggerTab.getDelegate().getCodeGenerate();
            this.grammarGeneratedFiles = this.codeGenerator.getGeneratedFileNames();
            this.fileRemoteParser = XJUtils.concatPath(this.codeGenerator.getOutputPath(), "__Test__.java");
            this.fileRemoteParserInputTextFile = XJUtils.concatPath(this.codeGenerator.getOutputPath(), "__Test___input.txt");
            this.fileRemoteParserTemplateTextFile = XJUtils.concatPath(this.codeGenerator.getOutputPath(), "__Test___template.st");
            this.outputFileDir = XJUtils.concatPath(this.codeGenerator.getOutputPath(), "classes");
            new File(this.outputFileDir).mkdirs();
        }
        catch (Exception e) {
            this.debuggerTab.getConsole().println(e);
            String msg = ErrorListener.getThreadInstance().getFirstErrorMessage();
            StringBuilder sb = new StringBuilder("Error while preparing the grammar:\n");
            if (msg != null) {
                sb.append(msg);
                sb.append("\n");
            }
            sb.append(e.toString());
            this.reportError(sb.toString());
            return false;
        }
        return true;
    }

    protected void generateAndCompileGrammar() {
        this.progress.setInfo("Analyzing...");
        this.progress.setProgress(1);
        this.analyzeGrammar();
        if (this.cancelled()) {
            return;
        }
        this.progress.setInfo("Generating...");
        this.progress.setProgress(2);
        this.generateGrammar();
        if (this.cancelled()) {
            return;
        }
        this.progress.setInfo("Compiling...");
        this.progress.setProgress(3);
        this.compileGrammar();
    }

    protected void analyzeGrammar() {
        String errorMessage = null;
        try {
            this.debuggerTab.getDelegate().getGrammarEngine().analyze();
        }
        catch (Exception e) {
            this.debuggerTab.getConsole().println(e);
            errorMessage = e.getLocalizedMessage();
        }
        if (errorMessage != null) {
            this.reportError("Error while analyzing the grammar:\n" + errorMessage);
        }
    }

    protected void generateGrammar() {
        String errorMessage = null;
        try {
            if (!this.codeGenerator.generate()) {
                errorMessage = this.codeGenerator.getLastError();
            }
        }
        catch (Exception e) {
            this.debuggerTab.getConsole().println(e);
            errorMessage = e.toString();
        }
        catch (OutOfMemoryError e) {
            this.debuggerTab.getConsole().println(e);
            errorMessage = e.toString();
        }
        if (errorMessage != null) {
            this.reportError("Error while generating the grammar:\n" + errorMessage);
        }
    }

    protected void compileGrammar() {
        XJUtils.deleteDirectory(this.outputFileDir);
        new File(this.outputFileDir).mkdirs();
        this.compileFiles(this.grammarGeneratedFiles.toArray(new String[this.grammarGeneratedFiles.size()]));
    }

    protected void generateAndCompileGlueCode(boolean build) {
        this.progress.setInfo("Preparing...");
        this.progress.setIndeterminate(true);
        if (!build && this.lastStartRule != null && this.startRule.equals(this.lastStartRule) && this.inputFile.equals(this.lastInputFile) && this.lastInputMode == this.inputMode && this.testTemplateClass.equals(this.lastTestTemplateClass) && this.lastTestTemplateMode.equals(this.testTemplateMode) && this.testTemplateText.equals(this.lastTestTemplateText)) {
            return;
        }
        this.lastStartRule = this.startRule;
        this.lastTestTemplateMode = this.testTemplateMode;
        this.lastTestTemplateClass = this.testTemplateClass;
        this.lastTestTemplateText = this.testTemplateText;
        this.lastInputMode = this.inputMode;
        this.lastInputFile = this.inputFile;
        this.generateGlueCode();
        if (this.cancelled()) {
            return;
        }
        this.compileGlueCode();
    }

    protected String getLexerName() throws Exception {
        String lexer = this.debuggerTab.getDelegate().getGrammarEngine().getGeneratedClassName(2);
        if (lexer == null) {
            lexer = this.debuggerTab.getDelegate().getTokenVocab();
        }
        return lexer;
    }

    protected void generateGlueCode() {
        try {
            StringTemplate glueCode;
            String parserName;
            boolean isTreeGrammar = this.debuggerTab.getDelegate().getGrammarEngine().getType() == 3;
            String templateName = isTreeGrammar ? treeParserGlueCodeTemplateName : parserGlueCodeTemplateName;
            String lexerName = isTreeGrammar ? this.getLexerName() + "Lexer" : this.getLexerName();
            String string = parserName = isTreeGrammar ? this.debuggerTab.getDelegate().getTokenVocab() + "Parser" : this.debuggerTab.getDelegate().getGrammarEngine().getGeneratedClassName(1);
            if ("text".equals(this.testTemplateMode)) {
                if ("".equals(this.testTemplateText)) {
                    StringTemplateGroup group = new StringTemplateGroup("DebuggerLocalGroup", DefaultTemplateLexer.class);
                    glueCode = group.getInstanceOf(parserGlueCodeTemplatePath + templateName);
                } else {
                    this.generateTestTemplateTextFile();
                    StringTemplateGroup group = new StringTemplateGroup("DebuggerLocalGroup", this.codeGenerator.getOutputPath());
                    glueCode = group.getInstanceOf("__Test___template");
                }
            } else {
                return;
            }
            glueCode.setAttribute(ST_ATTR_IMPORT, (Object)this.getCustomImports());
            glueCode.setAttribute(ST_ATTR_CLASSNAME, (Object)remoteParserClassName);
            if (this.inputMode == 0) {
                glueCode.setAttribute(ST_ATTR_INPUT_FILE, (Object)XJUtils.escapeString(this.fileRemoteParserInputTextFile));
            } else {
                glueCode.setAttribute(ST_ATTR_INPUT_FILE, (Object)XJUtils.escapeString(this.inputFile));
            }
            glueCode.setAttribute(ST_ATTR_JAVA_PARSER, (Object)parserName);
            glueCode.setAttribute(ST_ATTR_JAVA_LEXER, (Object)lexerName);
            glueCode.setAttribute(ST_ATTR_START_SYMBOL, (Object)this.startRule);
            glueCode.setAttribute(ST_ATTR_DEBUG_PORT, AWPrefs.getDebugDefaultLocalPort());
            glueCode.setAttribute(ST_ATTR_GRAMMAR_NAME, (Object)this.debuggerTab.getDelegate().getGrammarName());
            XJUtils.writeStringToFile(glueCode.toString(), this.fileRemoteParser);
        }
        catch (Exception e) {
            this.debuggerTab.getConsole().println(e);
            this.reportError("Error while generating the glue-code:\n" + e.toString());
        }
    }

    private String getCustomImports() {
        List<ElementBlock> blocks = this.debuggerTab.getBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return "";
        }
        HashSet<String> imports = new HashSet<String>();
        for (ElementBlock block : blocks) {
            if (!block.name.equals("@header") && !block.name.equals("@lexer::header")) continue;
            List<ATEToken> tokens = block.internalTokens;
            for (int j = 0; j < tokens.size(); ++j) {
                ATEToken t;
                String at;
                ATEToken token = tokens.get(j);
                if (token.type != 5 || !token.getAttribute().equals("package")) continue;
                StringBuilder sb = new StringBuilder();
                ++j;
                while (j < tokens.size() && !(at = (t = tokens.get(j)).getAttribute()).equals(";")) {
                    sb.append(at);
                    ++j;
                }
                imports.add(sb.toString());
            }
        }
        if (imports.isEmpty()) {
            return "";
        }
        StringBuilder importLines = new StringBuilder();
        for (String importName : imports) {
            importLines.append("import ");
            importLines.append(importName);
            importLines.append(".*;\n");
        }
        return importLines.toString();
    }

    protected void compileGlueCode() {
        try {
            boolean isTreeGrammar = this.debuggerTab.getDelegate().getGrammarEngine().getType() == 3;
            String lexerName = XJUtils.concatPath(this.codeGenerator.getOutputPath(), isTreeGrammar ? this.getLexerName() + "Lexer.java" : this.getLexerName() + ".java");
            String parserName = XJUtils.concatPath(this.codeGenerator.getOutputPath(), isTreeGrammar ? this.debuggerTab.getDelegate().getTokenVocab() + "Parser.java" : this.debuggerTab.getDelegate().getGrammarEngine().getGeneratedClassName(1) + ".java");
            this.compileFiles(new String[]{lexerName});
            this.compileFiles(new String[]{parserName});
            this.compileFiles(new String[]{this.fileRemoteParser});
        }
        catch (Exception e) {
            this.debuggerTab.getConsole().println(e);
            this.reportError("Error :\n" + e.toString());
        }
    }

    protected void compileFiles(String[] files) {
        String error = DebuggerEngine.compileFiles(this.debuggerTab.getConsole(), files, this.outputFileDir, this);
        if (error != null) {
            this.reportError(error);
        }
    }

    protected void generateInputText() {
        try {
            XJUtils.writeStringToFile(this.inputText, this.fileRemoteParserInputTextFile);
        }
        catch (IOException e) {
            this.debuggerTab.getConsole().println(e);
            this.reportError("Error while generating the input text:\n" + e.toString());
        }
    }

    protected void generateTestTemplateTextFile() {
        try {
            XJUtils.writeStringToFile(this.testTemplateText, this.fileRemoteParserTemplateTextFile);
        }
        catch (IOException e) {
            this.debuggerTab.getConsole().println(e);
            this.reportError("Error while generating the test template text file:\n" + e.toString());
        }
    }

    private String getTestRigTemplateFromFile(String testRigFullPath) {
        try {
            return Utils.stringFromFile(testRigFullPath);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public boolean isRequiredFilesExisting() {
        if (!this.prepare()) {
            return false;
        }
        if (!new File(this.fileRemoteParser).exists()) {
            return false;
        }
        if (this.inputMode == 0 && !new File(this.fileRemoteParserInputTextFile).exists()) {
            return false;
        }
        if (this.inputMode == 1 && !new File(this.inputFile).exists()) {
            return false;
        }
        for (String file : this.grammarGeneratedFiles) {
            if (new File(file).exists()) continue;
            return false;
        }
        return true;
    }

    public boolean checkForLaunch() {
        boolean success = true;
        try {
            ServerSocket serverSocket = new ServerSocket(AWPrefs.getDebugDefaultLocalPort());
            serverSocket.close();
        }
        catch (IOException e) {
            this.reportError("Cannot launch the remote parser because port " + AWPrefs.getDebugDefaultLocalPort() + " is already in use.");
            success = false;
        }
        return success;
    }

    public boolean launchRemoteParser() {
        if (!this.checkForLaunch()) {
            return false;
        }
        String classPath = DebuggerEngine.getClassPath(this.outputFileDir);
        IDE.debugVerbose(this.debuggerTab.getConsole(), this.getClass(), "Launch with path: " + classPath);
        try {
            String classNameToRun = remoteParserClassName;
            if ("class".equals(this.testTemplateMode)) {
                Class.forName(this.testTemplateClass);
                classNameToRun = this.testTemplateClass;
            }
            this.remoteParserProcess = Runtime.getRuntime().exec(new String[]{"java", "-classpath", classPath, classNameToRun});
            new StreamWatcher(this.remoteParserProcess.getErrorStream(), "Launcher", this.debuggerTab.getOutputPanel()).start();
            new StreamWatcher(this.remoteParserProcess.getInputStream(), "Launcher", this.debuggerTab.getOutputPanel()).start();
        }
        catch (IOException e) {
            this.reportError("Cannot launch the remote parser:\n" + e.toString() + "\nIt is possible that some errors prevented the parser from launching. Check the output panel of the debugger and any other output console in your system to see if an error has been reported from the parser and try again.");
            return false;
        }
        catch (ClassNotFoundException e) {
            this.reportError("Cannot launch the remote parser:\n" + e.toString() + "\nIt is possible that some errors prevented the parser from launching. Check the output panel of the debugger and any other output console in your system to see if an error has been reported from the parser and try again.");
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void streamWatcherDidStart() {
    }

    public synchronized void streamWatcherDidReceiveString(String string) {
        this.debuggerTab.getConsole().print(string, 0);
    }

    public synchronized void streamWatcherException(Exception e) {
        this.debuggerTab.getConsole().println(e);
    }

    protected static class ErrorReporter {
        public String title;
        public String message;
        public boolean hasErrors;

        protected ErrorReporter() {
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void enable() {
            this.hasErrors = true;
        }

        public void reset() {
            this.hasErrors = false;
        }
    }
}

