/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.dialog;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.antlr.works.IDE;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.TextUtils;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;

public class DialogTestTemplate
extends XJDialog {
    public static final String TEXT_FULLY_QUALIFIED_CLASS_NAME = "Enter fully qualified class name here..";
    private DebuggerTab debuggerTab;
    private String testRigFullPath;
    private String qualifiedFileName;
    private String grammarIdentifier;
    private String grammarLanguage = "Java";
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JRadioButton textTestRadio;
    private JScrollPane scrollPane1;
    private JTextPane testTextArea;
    private JRadioButton classTestRadio;
    private JTextField testClassField;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField testClassHiddenField;

    public DialogTestTemplate(DebuggerTab debuggerTab, Container parent) {
        super(parent, true);
        this.debuggerTab = debuggerTab;
        this.qualifiedFileName = this.debuggerTab.getDelegate().getDocument().getDocumentPath();
        if (this.qualifiedFileName != null) {
            this.testRigFullPath = XJUtils.getPathByDeletingPathExtension(this.qualifiedFileName) + "__testrig" + ".st";
            this.grammarIdentifier = this.qualifiedFileName.toUpperCase();
        }
        if (this.debuggerTab.getDelegate().getGrammarEngine() != null) {
            this.grammarLanguage = this.debuggerTab.getDelegate().getGrammarEngine().getGrammarLanguage();
        }
        this.initComponents();
        if (XJSystem.isMacOS()) {
            this.buttonBar.remove(this.okButton);
            this.buttonBar.remove(this.cancelButton);
            CellConstraints cc = new CellConstraints();
            this.buttonBar.add((Component)this.cancelButton, cc.xy(2, 1));
            this.buttonBar.add((Component)this.okButton, cc.xy(4, 1));
        }
        this.setDefaultButton(this.okButton);
        this.setOKButton(this.okButton);
        this.setCancelButton(this.cancelButton);
        TextUtils.createTabs(this.testTextArea);
        TextUtils.setDefaultTextPaneProperties(this.testTextArea);
        this.testTextArea.setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.testTextArea.setFocusable(true);
        this.testTextArea.requestFocusInWindow();
        this.testTextArea.setText(this.getTestRigTemplateFromFile(this.testRigFullPath));
        if ("".equals(this.testTextArea.getText())) {
            if ("default".equals(AWPrefs.getTestRigTemplateModeByLanguage(this.grammarLanguage.toUpperCase()))) {
                this.testTextArea.setText(this.getDefaultTestRigByLanguage(this.grammarLanguage));
            } else {
                this.testTextArea.setText(AWPrefs.getTestRigTemplateTextByLanguage(this.grammarLanguage.toUpperCase()));
            }
        }
        this.testClassHiddenField.setText(AWPrefs.getTestRigTemplateClass(this.grammarIdentifier));
        this.testClassField.setText(this.testClassHiddenField.getText());
        if ("".equals(this.testClassField.getText())) {
            this.testClassField.setForeground(Color.LIGHT_GRAY);
            this.testClassField.setText(TEXT_FULLY_QUALIFIED_CLASS_NAME);
        }
        this.textTestRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DialogTestTemplate.this.textTestRadio.isSelected()) {
                    DialogTestTemplate.this.testTextArea.setEnabled(true);
                    DialogTestTemplate.this.testClassField.setEnabled(false);
                } else {
                    DialogTestTemplate.this.testTextArea.setEnabled(false);
                    DialogTestTemplate.this.testClassField.setEnabled(true);
                }
            }
        });
        this.classTestRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DialogTestTemplate.this.classTestRadio.isSelected()) {
                    DialogTestTemplate.this.testTextArea.setEnabled(false);
                    DialogTestTemplate.this.testClassField.setEnabled(true);
                } else {
                    DialogTestTemplate.this.testTextArea.setEnabled(true);
                    DialogTestTemplate.this.testClassField.setEnabled(false);
                }
            }
        });
        if ("text".equals(AWPrefs.getTestRigTemplateMode(this.grammarIdentifier))) {
            this.textTestRadio.setSelected(true);
            this.testTextArea.setEnabled(true);
            this.testClassField.setEnabled(false);
        } else {
            this.classTestRadio.setSelected(true);
            this.testTextArea.setEnabled(false);
            this.testClassField.setEnabled(true);
        }
    }

    public void dialogWillCloseOK() {
        String text = this.getTestRigText();
        if (text.length() > 8192) {
            XJAlert.display(this.getJavaComponent(), "Error", "The test template text is too large: " + text.length() + " bytes but preferences can only hold " + 8192 + " bytes. It will be truncated.");
            text = text.substring(0, 8191);
        }
        this.setTestRigTemplateToFile(this.testRigFullPath, text);
        AWPrefs.setTestRigTemplateMode(this.grammarIdentifier, this.getTestRigMode());
        AWPrefs.setTestRigTemplateClass(this.grammarIdentifier, this.getTestRigClass());
    }

    public String getTestRigMode() {
        return this.textTestRadio.isSelected() ? "text" : "class";
    }

    public String getTestRigText() {
        return this.testTextArea.getText();
    }

    public String getTestRigClass() {
        return this.testClassHiddenField.getText();
    }

    private String getDefaultTestRigByLanguage(String grammarLanguage) {
        try {
            if ("JAVA".equalsIgnoreCase(grammarLanguage)) {
                return Utils.stringFromFile(IDE.getApplicationPath() + File.separatorChar + "templates/" + "DBParserGlueCode" + ".st");
            }
            if ("PYTHON".equalsIgnoreCase(grammarLanguage)) {
                return Utils.stringFromFile(IDE.getApplicationPath() + File.separatorChar + "templates/" + "DBParserGlueCode" + "_python.st");
            }
        }
        catch (IOException ioe) {
            this.debuggerTab.getConsole().println(ioe);
        }
        return "";
    }

    private String getTestRigTemplateFromFile(String testRigFullPath) {
        if (testRigFullPath == null) {
            return "";
        }
        try {
            return Utils.stringFromFile(testRigFullPath);
        }
        catch (IOException ioe) {
            return "";
        }
    }

    private void setTestRigTemplateToFile(String testRigFullPath, String text) {
        try {
            XJUtils.writeStringToFile(text, testRigFullPath);
        }
        catch (IOException ioe) {
            this.debuggerTab.getConsole().println(ioe);
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.textTestRadio = new JRadioButton();
        this.scrollPane1 = new JScrollPane();
        this.testTextArea = new JTextPane();
        this.classTestRadio = new JRadioButton();
        this.testClassField = new JTextField();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.testClassHiddenField = new JTextField();
        CellConstraints cc = new CellConstraints();
        String title = "Edit Test Rig";
        if (this.qualifiedFileName != null && !"".equals(this.qualifiedFileName)) {
            title = "Edit " + XJUtils.getLastPathComponent(this.qualifiedFileName) + " Test Rig";
        }
        if (this.grammarLanguage != null && !"".equals(this.grammarLanguage)) {
            title = title + " for " + this.grammarLanguage;
        }
        this.setTitle(title);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setMinimumSize(new Dimension(340, 250));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.textTestRadio.setText("Text:");
        this.contentPanel.add((Component)this.textTestRadio, cc.xy(1, 1));
        this.scrollPane1.setPreferredSize(new Dimension(300, 200));
        this.scrollPane1.setViewportView(this.testTextArea);
        this.contentPanel.add((Component)this.scrollPane1, cc.xywh(3, 1, 3, 5));
        this.classTestRadio.setText("Class:");
        this.contentPanel.add((Component)this.classTestRadio, cc.xy(1, 7));
        this.testClassField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (DialogTestTemplate.TEXT_FULLY_QUALIFIED_CLASS_NAME.equals(DialogTestTemplate.this.testClassField.getText())) {
                    DialogTestTemplate.this.testClassField.setForeground(Color.BLACK);
                    DialogTestTemplate.this.testClassField.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                DialogTestTemplate.this.testClassHiddenField.setText(DialogTestTemplate.this.testClassField.getText());
                if ("".equals(DialogTestTemplate.this.testClassField.getText())) {
                    DialogTestTemplate.this.testClassField.setForeground(Color.LIGHT_GRAY);
                    DialogTestTemplate.this.testClassField.setText(DialogTestTemplate.TEXT_FULLY_QUALIFIED_CLASS_NAME);
                }
            }
        });
        this.contentPanel.add((Component)this.testClassField, cc.xywh(3, 7, 3, 1));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.okButton.setText("OK");
        this.buttonBar.add((Component)this.okButton, cc.xy(2, 1));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, cc.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(625, 395);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.textTestRadio);
        buttonGroup1.add(this.classTestRadio);
    }
}

