/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.editor.EditorPersistentObject;

public class EditorPersistence {
    private static final String KEY_RULES = "rules";
    private static final String KEY_ACTIONS = "actions";
    private Map<String, Map<Object, EditorPersistentObject>> persistence = new HashMap<String, Map<Object, EditorPersistentObject>>();
    private boolean stored = false;
    private GrammarWindow window;

    public EditorPersistence(GrammarWindow window) {
        this.window = window;
    }

    public void close() {
        this.window = null;
    }

    public void store() {
        if (this.stored) {
            return;
        }
        this.stored = true;
        this.store(this.window.getGrammarEngine().getRules(), KEY_RULES);
        this.store(this.window.getGrammarEngine().getActions(), KEY_ACTIONS);
    }

    public void restore() {
        if (this.stored) {
            this.stored = false;
            this.restore(this.window.getGrammarEngine().getRules(), KEY_RULES);
            this.restore(this.window.getGrammarEngine().getActions(), KEY_ACTIONS);
        }
    }

    public void store(List objects, String key) {
        Map<Object, EditorPersistentObject> m = this.persistence.get(key);
        if (m == null) {
            m = new HashMap<Object, EditorPersistentObject>();
            this.persistence.put(key, m);
        }
        m.clear();
        if (objects == null) {
            return;
        }
        for (Object object : objects) {
            EditorPersistentObject o = (EditorPersistentObject)object;
            m.put(o.getPersistentID(), o);
        }
    }

    public void restore(List objects, String key) {
        Map<Object, EditorPersistentObject> m = this.persistence.get(key);
        if (m == null) {
            return;
        }
        if (objects == null) {
            return;
        }
        for (Object object : objects) {
            EditorPersistentObject o = (EditorPersistentObject)object;
            EditorPersistentObject oldObject = m.get(o.getPersistentID());
            if (oldObject == null) continue;
            o.persistentAssign(oldObject);
        }
    }
}

