/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.generate;

import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.antlr.Tool;
import org.antlr.tool.ANTLRErrorListener;
import org.antlr.tool.ErrorManager;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.generate.CodeGenerateDelegate;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerate
implements Runnable {
    private boolean debug = true;
    protected GrammarWindow window;
    protected CodeGenerateDelegate delegate;
    protected long dateOfModificationOnDisk = 0L;
    protected String lastError;
    protected String generateError = null;
    protected XJDialogProgress progress;

    public CodeGenerate(GrammarWindow window, CodeGenerateDelegate delegate) {
        this.window = window;
        this.delegate = delegate;
    }

    public void close() {
        this.window = null;
        this.delegate = null;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getOutputPath() {
        return this.window.getOutputPath();
    }

    public String getGrammarLanguage() {
        return this.window.getGrammarEngine().getGrammarLanguage();
    }

    public String getGrammarName() {
        return this.window.getGrammarEngine().getGrammarName();
    }

    public String getLastError() {
        return this.lastError;
    }

    public boolean generate() {
        boolean success;
        ErrorListener el = ErrorListener.getThreadInstance();
        ErrorManager.setErrorListener((ANTLRErrorListener)el);
        String[] params = this.debug ? new String[]{"-debug", "-o", this.getOutputPath(), "-lib", this.window.getFileFolder(), this.window.getFilePath()} : new String[]{"-o", this.getOutputPath(), "-lib", this.window.getFileFolder(), this.window.getFilePath()};
        new File(this.getOutputPath()).mkdirs();
        Tool antlr = new Tool(Utils.concat(params, AWPrefs.getANTLR3Options()));
        antlr.process();
        boolean bl = success = !el.hasErrors();
        if (success) {
            this.dateOfModificationOnDisk = this.window.getDocument().getDateOfModificationOnDisk();
        }
        this.lastError = el.getFirstErrorMessage();
        el.clear();
        ErrorManager.removeErrorListener();
        return success;
    }

    public List<String> getGeneratedFileNames() throws Exception {
        ArrayList<String> files = new ArrayList<String>();
        for (String name : this.window.getGrammarEngine().getAllGeneratedNames()) {
            files.add(XJUtils.concatPath(this.getOutputPath(), name + ".java"));
        }
        return files;
    }

    public String getGeneratedFileName(int type) throws Exception {
        String className = this.window.getGrammarEngine().getGeneratedClassName(type);
        if (className == null) {
            return null;
        }
        return XJUtils.concatPath(this.getOutputPath(), className + ".java");
    }

    public boolean isGeneratedTextFileExisting(int type) {
        try {
            String file = this.getGeneratedFileName(type);
            return file == null || new File(file).exists();
        }
        catch (Exception e) {
            this.window.getConsoleTab().println(e);
            return false;
        }
    }

    public boolean isFileModifiedSinceLastGeneration() {
        return this.dateOfModificationOnDisk != this.window.getDocument().getDateOfModificationOnDisk();
    }

    public void generateInThread(Container parent) {
        this.progress = new XJDialogProgress(parent);
        this.progress.setInfo("Generating...");
        this.progress.setCancellable(false);
        this.progress.setIndeterminate(true);
        this.progress.display();
        new Thread(this).start();
    }

    public void generateInThreadDidTerminate() {
        this.progress.close();
        if (this.generateError != null) {
            XJAlert.display(this.window.getJavaContainer(), "Error", "Cannot generate the grammar because:\n" + this.generateError);
            if (this.delegate != null) {
                this.delegate.codeGenerateDidCompleteWithError(this.generateError);
            }
        } else {
            if ((this.delegate == null || this.delegate.codeGenerateDisplaySuccess()) && AWPrefs.isAlertGenerateCodeSuccess()) {
                XJAlert alert = XJAlert.createInstance();
                alert.setDisplayDoNotShowAgainButton(true);
                alert.showSimple(this.window.getJavaContainer(), "Success", "The grammar has been successfully generated in path:\n" + this.getOutputPath());
                AWPrefs.setAlertGenerateCodeSuccess(!alert.isDoNotShowAgain());
            }
            if (this.delegate != null) {
                this.delegate.codeGenerateDidComplete();
            }
        }
    }

    @Override
    public void run() {
        this.generateError = null;
        this.window.getConsoleTab().setMode(1);
        try {
            if (!this.generate()) {
                this.generateError = this.getLastError();
            }
        }
        catch (Exception e) {
            this.generateError = e.toString();
            this.window.getConsoleTab().println(e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CodeGenerate.this.generateInThreadDidTerminate();
            }
        });
    }
}

