/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.works.ate.syntax.generic.ATESyntaxParser;
import org.antlr.works.ate.syntax.misc.ATEScope;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.grammar.element.ElementAction;
import org.antlr.works.grammar.element.ElementArgumentBlock;
import org.antlr.works.grammar.element.ElementBlock;
import org.antlr.works.grammar.element.ElementGrammarName;
import org.antlr.works.grammar.element.ElementGroup;
import org.antlr.works.grammar.element.ElementImport;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRewriteBlock;
import org.antlr.works.grammar.element.ElementRewriteFunction;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.element.ElementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarSyntaxParser
extends ATESyntaxParser {
    private static final ElementRewriteBlock REWRITE_BLOCK = new ElementRewriteBlock();
    private static final ElementArgumentBlock ARGUMENT_BLOCK = new ElementArgumentBlock();
    private static final ElementRewriteFunction REWRITE_FUNCTION = new ElementRewriteFunction();
    public static final String BEGIN_GROUP = "// $<";
    public static final String END_GROUP = "// $>";
    public static final String TOKENS_BLOCK_NAME = "tokens";
    public static final String OPTIONS_BLOCK_NAME = "options";
    public static final String PARSER_HEADER_BLOCK_NAME = "@header";
    public static final String LEXER_HEADER_BLOCK_NAME = "@lexer::header";
    public static final String PARSER_MEMBERS_BLOCK_NAME = "@members";
    public static final String LEXER_MEMBERS_BLOCK_NAME = "@lexer::members";
    public static final List<String> blockIdentifiers = new ArrayList<String>();
    public static final List<String> ruleModifiers;
    public static final List<String> keywords;
    public static final List<String> predefinedReferences;
    public final List<ElementRule> rules = new ArrayList<ElementRule>();
    public final List<ElementGroup> groups = new ArrayList<ElementGroup>();
    public final List<ElementBlock> blocks = new ArrayList<ElementBlock>();
    public final List<ElementAction> actions = new ArrayList<ElementAction>();
    public final List<ElementReference> references = new ArrayList<ElementReference>();
    public final List<ElementImport> imports = new ArrayList<ElementImport>();
    public final List<ATEToken> decls = new ArrayList<ATEToken>();
    private final LabelTable labels = new LabelTable();
    private final List<ATEToken> unresolvedReferences = new ArrayList<ATEToken>();
    private final Set<String> declaredReferenceNames = new HashSet<String>();
    private final Map<ATEToken, ElementRule> refsToRules = new HashMap<ATEToken, ElementRule>();
    private ElementGrammarName name;
    private ElementRule currentRule;

    public ElementGrammarName getName() {
        return this.name;
    }

    @Override
    public void close() {
        super.close();
        this.clear();
    }

    @Override
    public void parseTokens() {
        this.clear();
        if (!this.nextToken()) {
            return;
        }
        while (this.matchName() || this.matchScope() || this.matchBlock() || this.matchImport() || this.matchRule() || this.matchRuleGroup() || this.matchSingleComment(0) || this.matchComplexComment(0) || this.nextToken()) {
        }
        this.resolveReferences();
    }

    private void clear() {
        this.rules.clear();
        this.groups.clear();
        this.blocks.clear();
        this.actions.clear();
        this.references.clear();
        this.imports.clear();
        this.decls.clear();
        this.currentRule = null;
        this.declaredReferenceNames.clear();
        this.unresolvedReferences.clear();
        this.refsToRules.clear();
    }

    public void resolveReferencesWithExternalNames(Set<String> externalNames) {
        for (int i = this.unresolvedReferences.size() - 1; i >= 0; --i) {
            ATEToken ref = this.unresolvedReferences.get(i);
            if (!externalNames.contains(ref.getAttribute())) continue;
            ref.type = 100;
            this.references.add(new ElementReference(this.refsToRules.get(ref), ref));
            this.unresolvedReferences.remove(i);
        }
    }

    private void resolveReferences() {
        for (int i = this.unresolvedReferences.size() - 1; i >= 0; --i) {
            ATEToken ref = this.unresolvedReferences.get(i);
            if (!this.declaredReferenceNames.contains(ref.getAttribute())) continue;
            ref.type = 100;
            this.references.add(new ElementReference(this.refsToRules.get(ref), ref));
            this.unresolvedReferences.remove(i);
        }
    }

    private boolean matchName() {
        if (!this.isID(0)) {
            return false;
        }
        this.mark();
        if (this.tryMatchName()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchName() {
        ATEToken start = this.T(0);
        if (ElementGrammarName.isKnownType(start.getAttribute()) && !this.nextToken()) {
            return false;
        }
        if (!this.matchID(0, "grammar")) {
            return false;
        }
        ATEToken name = this.T(0);
        if (!this.nextToken()) {
            return false;
        }
        if (!this.matchSEMI(0)) {
            return false;
        }
        this.name = new ElementGrammarName(name, start, this.T(-1), start);
        return true;
    }

    private boolean matchScope() {
        if (!this.isID(0, "scope")) {
            return false;
        }
        this.mark();
        ATEToken start = this.T(0);
        if (!this.matchID(0, "scope")) {
            return false;
        }
        this.matchID(0);
        if (this.isOpenBLOCK(0)) {
            ElementBlock block = new ElementBlock(start.getAttribute().toLowerCase(), start);
            ATEToken beginBlock = this.T(0);
            if (this.matchBalancedToken(9, 10, null, true)) {
                beginBlock.type = 103;
                this.T((int)-1).type = 103;
                start.type = 102;
                this.blocks.add(block);
                return true;
            }
        }
        this.rewind();
        return false;
    }

    private boolean matchScopeUse() {
        if (!this.isID(0, "scope")) {
            return false;
        }
        this.mark();
        ATEToken start = this.T(0);
        if (!this.matchID(0, "scope")) {
            return false;
        }
        if (this.matchID(0)) {
            while (this.matchChar(0, ",")) {
                if (this.matchID(0)) continue;
                this.rewind();
                return false;
            }
            if (this.matchSEMI(0)) {
                return true;
            }
        }
        this.rewind();
        return false;
    }

    private boolean matchBlock() {
        return this.matchBlock(null);
    }

    private boolean matchBlock(String label) {
        if (label == null && !this.isID(0)) {
            return false;
        }
        if (label != null && !this.isID(0, label)) {
            return false;
        }
        this.mark();
        ATEToken start = this.T(0);
        int startIndex = this.getPosition();
        if (label == null ? !this.matchID(0) : !this.matchID(0, label)) {
            return false;
        }
        ElementBlock block = new ElementBlock(start.getAttribute().toLowerCase(), start);
        ATEToken beginBlock = this.T(0);
        if (this.matchBalancedToken(9, 10, block, true)) {
            beginBlock.type = 103;
            this.T((int)-1).type = 103;
            start.type = 102;
            this.blocks.add(block);
            block.end = this.T(-1);
            block.internalTokens = new ArrayList<ATEToken>(this.getTokens().subList(startIndex, this.getPosition()));
            block.parse();
            if (block.isTokenBlock) {
                List<ATEToken> tokens = block.getDeclaredTokens();
                for (ATEToken lexerToken : tokens) {
                    lexerToken.type = 105;
                    this.addDeclaration(lexerToken);
                }
            }
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean matchImport() {
        this.mark();
        if (!this.matchID(0, "import")) {
            return false;
        }
        while (!this.matchSEMI(0)) {
            if (this.T(0) != null) {
                this.imports.add(new ElementImport(this.name, this.T(0)));
            }
            if (!this.matchID(0)) {
                this.rewind();
                return false;
            }
            if (this.matchChar(0, ",")) continue;
            this.rewind();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchRule() {
        this.mark();
        try {
            if (this.tryMatchRule()) {
                boolean bl = true;
                return bl;
            }
            this.rewind();
            boolean bl = false;
            return bl;
        }
        finally {
            this.currentRule = null;
        }
    }

    private boolean tryMatchRule() {
        ATEToken start = this.T(0);
        if (start == null) {
            return false;
        }
        if (ruleModifiers.contains(start.getAttribute()) && !this.nextToken()) {
            return false;
        }
        ElementToken tokenName = (ElementToken)this.T(0);
        String name = tokenName.getAttribute();
        if (!this.matchID(0)) {
            return false;
        }
        this.matchArguments();
        while (this.matchSingleComment(0) || this.matchComplexComment(0)) {
        }
        if (this.matchID(0, "returns")) {
            this.matchArguments();
        }
        this.matchChar(0, "!");
        while (this.matchScopeUse() || this.matchBlock() || this.matchSingleComment(0) || this.matchComplexComment(0)) {
        }
        if (!this.isCOLON(0)) {
            return false;
        }
        this.nextToken();
        ATEToken colonToken = this.T(-1);
        int oldRefsSize = this.references.size();
        int oldBlocksSize = this.blocks.size();
        int oldActionsSize = this.actions.size();
        this.currentRule = new ElementRule(this, name, start, colonToken, null);
        this.labels.clear();
        do {
            if (!this.matchEndOfRule(tokenName, oldRefsSize, oldBlocksSize, oldActionsSize)) continue;
            return true;
        } while (this.matchBlock(OPTIONS_BLOCK_NAME) || this.matchRewriteTemplate() || this.matchAssignment(this.labels) || this.matchInternalRefInRule() || this.matchAction() || this.matchSingleQuoteString(0) && this.matchOptionalNodeToken() || this.nextToken());
        return false;
    }

    private boolean matchEndOfRule(ElementToken tokenName, int oldRefsSize, int oldBlocksSize, int oldActionsSize) {
        if (!this.matchSEMI(0)) {
            return false;
        }
        while (this.matchComplexComment(0) || this.matchSingleComment(0)) {
        }
        this.matchRuleExceptionGroup();
        this.currentRule.end = this.T(-1);
        tokenName.type = 105;
        this.addDeclaration(tokenName);
        if (this.references.size() > oldRefsSize) {
            this.currentRule.setReferencesIndexes(oldRefsSize, this.references.size() - 1);
        }
        if (this.blocks.size() > oldBlocksSize) {
            this.currentRule.setBlocksIndexes(oldBlocksSize, this.blocks.size() - 1);
        }
        if (this.actions.size() > oldActionsSize) {
            this.currentRule.setActionsIndexes(oldActionsSize, this.actions.size() - 1);
        }
        this.currentRule.completed();
        this.rules.add(this.currentRule);
        return true;
    }

    private boolean matchInternalRefInRule() {
        ATEToken refToken = this.T(0);
        if (!this.matchID(0)) {
            return false;
        }
        if (!this.matchOptionalNodeToken()) {
            return false;
        }
        while (this.isChar(0, ".") && this.isID(1)) {
            if (this.skip(2)) continue;
            return false;
        }
        this.matchArguments();
        this.addReference(refToken, false);
        return true;
    }

    private boolean matchAction() {
        if (!this.isOpenBLOCK(0)) {
            return false;
        }
        ATEToken t0 = this.T(0);
        ElementAction action = new ElementAction(this, this.currentRule, t0);
        if (this.matchBalancedToken(9, 10, action, true)) {
            t0.type = 103;
            this.T((int)-1).type = 103;
            action.end = this.T(-1);
            action.actionNum = this.actions.size();
            action.setScope(this.currentRule);
            this.actions.add(action);
            return true;
        }
        return false;
    }

    private boolean matchAssignment(LabelTable labels) {
        this.mark();
        ATEToken label = this.T(0);
        if (this.matchID(0)) {
            if (this.matchChar(0, "=")) {
                label.type = 101;
                labels.add(label.getAttribute());
                return true;
            }
            if (this.isChar(0, "+") && this.isChar(1, "=")) {
                label.type = 101;
                labels.add(label.getAttribute());
                this.skip(2);
                return true;
            }
        }
        this.rewind();
        return false;
    }

    private boolean matchRewriteTemplate() {
        if (!this.isTokenType(0, 104)) {
            return false;
        }
        if (!this.nextToken()) {
            return false;
        }
        while (this.matchComplexComment(0) || this.matchSingleComment(0)) {
        }
        if (this.matchAction() && !this.matchChar(0, "?")) {
            return true;
        }
        if (this.isID(0, "template")) {
            if (!this.matchRewriteTemplateHead()) {
                return false;
            }
            if (this.matchDoubleQuotedString()) {
                return true;
            }
            if (this.matchDoubleAngleString()) {
                return true;
            }
        } else if (!(this.matchRewriteTemplateHead() || this.matchRewriteIndirectTemplateHead() || this.matchAction())) {
            return true;
        }
        return true;
    }

    private boolean matchRewriteIndirectTemplateHead() {
        if (!this.isLPAREN(0)) {
            return false;
        }
        this.mark();
        if (this.tryMatchRewriteIndirectTemplateHead()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchRewriteIndirectTemplateHead() {
        if (!this.matchLPAREN(0)) {
            return false;
        }
        if (!this.matchAction()) {
            return false;
        }
        if (!this.matchRPAREN(0)) {
            return false;
        }
        if (!this.matchLPAREN(0)) {
            return false;
        }
        if (!this.matchRewriteTemplateArgs()) {
            return false;
        }
        return this.matchRPAREN(0);
    }

    private boolean matchRewriteTemplateHead() {
        if (!this.isID(0)) {
            return false;
        }
        this.mark();
        if (this.tryMatchRewriteTemplateHead()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchRewriteTemplateHead() {
        if (!this.matchID(0)) {
            return false;
        }
        if (!this.matchLPAREN(0)) {
            return false;
        }
        if (!this.matchRewriteTemplateArgs()) {
            return false;
        }
        return this.matchRPAREN(0);
    }

    private boolean matchRewriteTemplateArgs() {
        if (this.matchRewriteTemplateArg()) {
            while (this.matchChar(0, ",")) {
                this.matchSingleComment(0);
                this.matchComplexComment(0);
                if (this.matchRewriteTemplateArg()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matchRewriteTemplateArg() {
        if (!this.isID(0) && !this.isChar(1, "=")) {
            return false;
        }
        this.mark();
        if (this.tryMatchRewriteTemplateArg()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchRewriteTemplateArg() {
        if (!this.matchID(0)) {
            return false;
        }
        if (!this.matchChar(0, "=")) {
            return false;
        }
        return this.matchBalancedToken(9, 10, REWRITE_FUNCTION, true);
    }

    private boolean matchDoubleQuotedString() {
        if (this.isTokenType(0, 2)) {
            this.T((int)0).scope = REWRITE_BLOCK;
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchDoubleAngleString() {
        return this.matchBalancedToken(106, 107, REWRITE_BLOCK, false);
    }

    private boolean matchArguments() {
        return this.matchBalancedToken(11, 12, ARGUMENT_BLOCK, true);
    }

    private void matchRuleExceptionGroup() {
        while (this.matchID(0, "catch")) {
            this.matchArguments();
            this.matchAction();
        }
        if (this.matchID(0, "finally")) {
            this.matchAction();
        }
    }

    private boolean matchRuleGroup() {
        if (!this.isSingleComment(0)) {
            return false;
        }
        ATEToken token = this.T(0);
        String comment = token.getAttribute();
        if (comment.startsWith(BEGIN_GROUP)) {
            this.groups.add(new ElementGroup(comment.substring(BEGIN_GROUP.length(), comment.length() - 1), this.rules.size() - 1, token));
            this.nextToken();
            return true;
        }
        if (comment.startsWith(END_GROUP)) {
            this.groups.add(new ElementGroup(this.rules.size() - 1, token));
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean addReference(ATEToken ref, boolean addOnlyIfKnownLabel) {
        this.refsToRules.put(ref, this.currentRule);
        if (this.labels.lookup(ref.getAttribute())) {
            ref.type = 101;
            return true;
        }
        if (!addOnlyIfKnownLabel) {
            ref.type = 100;
            this.references.add(new ElementReference(this.refsToRules.get(ref), ref));
        }
        return false;
    }

    private void addDeclaration(ATEToken token) {
        this.decls.add(token);
        this.declaredReferenceNames.add(token.getAttribute());
    }

    private boolean matchBalancedToken(int open, int close, ATEScope scope, boolean matchInternalRef) {
        if (this.T(0) == null || this.T((int)0).type != open) {
            return false;
        }
        this.mark();
        int balance = 0;
        while (true) {
            this.T((int)0).scope = scope;
            if (this.T((int)0).type == open) {
                ++balance;
            } else if (this.T((int)0).type == close && --balance == 0) {
                this.nextToken();
                return true;
            }
            if (!this.nextToken()) break;
            this.matchInternalRefInBalancedToken(matchInternalRef);
        }
        this.rewind();
        return false;
    }

    private void matchInternalRefInBalancedToken(boolean matchInternalRef) {
        if (matchInternalRef && this.isChar(0, "$") && this.isID(1)) {
            this.T((int)0).type = 108;
            ATEToken ref = this.T(1);
            if (!this.addReference(ref, true)) {
                this.unresolvedReferences.add(ref);
            }
        }
    }

    private boolean matchChar(int index, String c) {
        if (this.isChar(index, c)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchID(int index) {
        if (this.isID(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchID(int index, String text) {
        if (this.isID(index, text)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchOptionalNodeToken() {
        this.mark();
        if (this.matchChar(0, "<")) {
            while (this.matchID(0) && !this.isChar(0, ">")) {
                if (this.matchChar(0, ".")) continue;
                if (!this.matchChar(0, "=")) {
                    this.rewind();
                    return false;
                }
                if (this.matchSEMI(0)) continue;
                this.rewind();
                return false;
            }
            if (!this.matchChar(0, ">")) {
                this.rewind();
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean matchSEMI(int index) {
        if (this.isSEMI(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchLPAREN(int index) {
        if (this.isLPAREN(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchRPAREN(int index) {
        if (this.isRPAREN(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean isLPAREN(int index) {
        return this.isTokenType(index, 7);
    }

    private boolean isRPAREN(int index) {
        return this.isTokenType(index, 8);
    }

    private boolean isSEMI(int index) {
        return this.isTokenType(index, 14);
    }

    private boolean isCOLON(int index) {
        return this.isTokenType(index, 13);
    }

    private boolean isOpenBLOCK(int index) {
        return this.isTokenType(index, 9);
    }

    static {
        blockIdentifiers.add(OPTIONS_BLOCK_NAME);
        blockIdentifiers.add(TOKENS_BLOCK_NAME);
        blockIdentifiers.add(PARSER_HEADER_BLOCK_NAME);
        blockIdentifiers.add(LEXER_HEADER_BLOCK_NAME);
        blockIdentifiers.add(PARSER_MEMBERS_BLOCK_NAME);
        blockIdentifiers.add(LEXER_MEMBERS_BLOCK_NAME);
        ruleModifiers = new ArrayList<String>();
        ruleModifiers.add("protected");
        ruleModifiers.add("public");
        ruleModifiers.add("private");
        ruleModifiers.add("fragment");
        keywords = new ArrayList<String>();
        keywords.addAll(blockIdentifiers);
        keywords.addAll(ruleModifiers);
        keywords.add("returns");
        keywords.add("init");
        predefinedReferences = new ArrayList<String>();
        predefinedReferences.add("EOF");
    }

    private static class LabelTable {
        Set<String> labels = new HashSet<String>();

        private LabelTable() {
        }

        public void clear() {
            this.labels.clear();
        }

        public void add(String label) {
            this.labels.add(label);
        }

        public boolean lookup(String label) {
            return this.labels.contains(label);
        }
    }
}

