/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stringtemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.table.AbstractTableModel;
import org.antlr.works.stringtemplate.STWindow;
import org.antlr.works.stringtemplate.element.ElementTemplateRule;
import org.antlr.works.stringtemplate.syntax.ATEStringTemplateSyntaxParser;
import org.antlr.xjlib.appkit.swing.XJTableView;

public class STRulePanel
extends JPanel {
    protected STWindow window;
    private STRuleModel model;
    private final XJTableView tableView = new XJTableView();

    public STRulePanel(STWindow window) {
        this.window = window;
        this.model = new STRuleModel();
        this.tableView.setAlternateBackground(true);
        this.refreshRules();
        this.setLayout(new BorderLayout());
        this.tableView.autoresizeColumns();
        this.tableView.getTable().addMouseListener(new RuleTableMouseListener());
        this.add((Component)this.tableView, "Center");
    }

    public boolean isRulesSorted() {
        return this.model.isRulesSorted();
    }

    public void toggleSorting() {
        this.model.toggleSort();
    }

    public void refreshRules() {
        this.model.clear();
        List<ElementTemplateRule> rules = ((ATEStringTemplateSyntaxParser)this.window.getTextEditor().getParserEngine().getParser()).templateRules;
        for (ElementTemplateRule rule : rules) {
            this.model.addRule(rule);
        }
        this.model.fireSort();
        this.tableView.getTable().setModel(this.model);
        this.tableView.autoresizeColumns();
    }

    private static class STRuleModel
    extends AbstractTableModel {
        private final List<String> rules = new ArrayList<String>();
        private final List<String> sortedRules = new ArrayList<String>();
        private boolean sorted = false;

        public void addRule(ElementTemplateRule rule) {
            this.rules.add(rule.name);
            this.sortedRules.add(rule.name);
            int index = this.rules.size() - 1;
            this.fireTableRowsInserted(index, index);
        }

        public boolean isRulesSorted() {
            return this.sorted;
        }

        public boolean toggleSort() {
            this.sorted = !this.sorted;
            return this.sorted;
        }

        public void fireSort() {
            Collections.sort(this.sortedRules);
        }

        public void clear() {
            this.rules.clear();
            this.sortedRules.clear();
        }

        public int getRowCount() {
            return this.rules.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return "Rules";
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.sorted) {
                return this.sortedRules.get(rowIndex);
            }
            return this.rules.get(rowIndex);
        }
    }

    public class RuleTableMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            int selectedRow = STRulePanel.this.tableView.getTable().getSelectedRow();
            String selectedRuleName = null;
            if (selectedRow > -1) {
                selectedRuleName = STRulePanel.this.tableView.getTable().getModel().getValueAt(selectedRow, 0).toString();
                STRulePanel.this.window.goToRule(selectedRuleName);
            }
            STRulePanel.this.tableView.requestFocusInWindow();
            this.checkForPopupTrigger(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkForPopupTrigger(e);
        }

        public void checkForPopupTrigger(MouseEvent e) {
            JPopupMenu menu;
            if (e.isPopupTrigger() && (menu = STRulePanel.this.window.rulesGetContextualMenu()) != null) {
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

