/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.DetachablePanelDelegate;
import org.antlr.works.utils.IconManager;
import org.antlr.xjlib.appkit.frame.XJDialog;

public class DetachablePanel
extends JPanel {
    protected DetachablePanelDelegate delegate;
    protected JPanel mainPanel;
    protected TitlePanel titlePanel;
    protected String title;
    protected boolean detached = false;
    protected JButton detach;
    protected XJDialog window;
    protected int tag;
    private PropertyChangeListener pcl;
    private ActionListener al;
    private Point previousPosition;
    private Dimension previousSize;

    public DetachablePanel(String title, DetachablePanelDelegate delegate) {
        super(new BorderLayout());
        this.delegate = delegate;
        this.title = title;
        this.createTitleBar(title);
        this.mainPanel = new JPanel(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("focusOwner") && e.getNewValue() != null) {
                    Component c = (Component)e.getNewValue();
                    if (DetachablePanel.this.isParentOf(c)) {
                        DetachablePanel.this.focusGained();
                    } else {
                        DetachablePanel.this.focusLost();
                    }
                }
            }
        };
        focusManager.addPropertyChangeListener(this.pcl);
    }

    public void close() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.pcl);
        this.detach.removeActionListener(this.al);
        this.delegate = null;
        this.window = null;
    }

    public void createTitleBar(String title) {
        Box box = Box.createHorizontalBox();
        JLabel l = new JLabel(title);
        l.setFont(l.getFont().deriveFont(11.0f));
        l.setForeground(Color.white);
        box.add(Box.createHorizontalStrut(2));
        box.add(l);
        box.add(Box.createHorizontalGlue());
        this.detach = this.createDetachButton();
        box.add(this.detach);
        this.titlePanel = new TitlePanel();
        this.titlePanel.setMinimumSize(new Dimension(0, 15));
        this.titlePanel.setMaximumSize(new Dimension(0, 15));
        this.titlePanel.setPreferredSize(new Dimension(0, 15));
        this.titlePanel.add(box);
        super.add((Component)this.titlePanel, "North");
    }

    public JButton createDetachButton() {
        JButton detach = new JButton(IconManager.shared().getIconDetach());
        detach.setBorder(null);
        detach.setBorderPainted(false);
        detach.setOpaque(false);
        detach.setFocusable(false);
        detach.setVerticalAlignment(0);
        detach.setMargin(new Insets(0, 0, 0, 0));
        this.al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DetachablePanel.this.detached) {
                    DetachablePanel.this.attach();
                } else {
                    DetachablePanel.this.detach();
                }
            }
        };
        detach.addActionListener(this.al);
        return detach;
    }

    public boolean isParentOf(Component c) {
        Container p = c.getParent();
        return p != null && (p == this || this.isParentOf(p));
    }

    public void focusGained() {
        this.titlePanel.setFocused(true);
    }

    public void focusLost() {
        this.titlePanel.setFocused(false);
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getTag() {
        return this.tag;
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (this.detached) {
            this.window.setVisible(flag);
        }
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void detach() {
        this.detached = true;
        Point p = this.getLocationOnScreen();
        this.delegate.panelDoDetach(this);
        this.detach.setIcon(IconManager.shared().getIconAttach());
        this.window = AWPrefs.getDetachableChildren() ? new DetachableWindow(this.delegate.panelParentContainer()) : new DetachableWindow(null);
        this.window.setTitle(this.title);
        if (this.previousPosition == null) {
            this.window.setPosition(p.x, p.y);
        } else {
            this.window.setPosition(this.previousPosition);
        }
        if (this.previousSize == null) {
            this.window.setSize(this.getWidth(), this.getHeight());
        } else {
            this.window.setSize(this.previousSize);
        }
        this.window.getContentPane().add(this);
        this.window.setVisible(true);
    }

    public void attach() {
        this.detached = false;
        this.previousPosition = this.window.getPosition();
        this.previousSize = this.window.getSize();
        this.window.getContentPane().remove(0);
        this.window.close();
        this.detach.setIcon(IconManager.shared().getIconDetach());
        this.delegate.panelDoAttach(this);
    }

    public class DetachableWindow
    extends XJDialog {
        public DetachableWindow(Container container) {
            super(container, false);
        }

        public void dialogWillCloseCancel() {
            if (DetachablePanel.this.detached) {
                DetachablePanel.this.setVisible(false);
                DetachablePanel.this.delegate.panelDoClose(DetachablePanel.this);
            }
        }
    }

    public static class TitlePanel
    extends JPanel {
        public boolean focused = false;

        public TitlePanel() {
            super(new BorderLayout());
        }

        public void setFocused(boolean flag) {
            this.focused = flag;
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            Color endColor;
            Color startColor;
            if (this.focused) {
                startColor = new Color(0.1f, 0.6f, 0.9f);
                endColor = new Color(0.8f, 0.9f, 1.0f);
            } else {
                startColor = new Color(0.7f, 0.7f, 0.7f);
                endColor = new Color(0.9f, 0.9f, 0.9f);
            }
            int x = this.getVisibleRect().width;
            int y = this.getVisibleRect().height;
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, startColor, x, y, endColor);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(gradient);
            g2d.fillRect(0, 0, x, y);
        }
    }
}

