/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.Container;
import java.io.IOException;
import java.util.Calendar;
import org.antlr.Tool;
import org.antlr.works.dialog.DialogReports;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.Localizable;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.update.XJUpdateManager;
import org.antlr.xjlib.appkit.utils.BrowserLauncher;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;
import org.antlr.xjlib.foundation.timer.XJScheduledTimerDelegate;

public class HelpManager
implements XJScheduledTimerDelegate {
    public void scheduledTimerFired(boolean startup) {
        HelpManager.checkUpdatesAuto(startup);
    }

    public static void submitStats(Container parent) {
        new DialogReports(parent, true).runModal();
    }

    public static void sendFeedback(Container parent) {
        StringBuilder url = new StringBuilder(Localizable.getLocalizedString("FeedbackURL"));
        url.append("?ANTLRVersion=");
        url.append(XJUtils.encodeToURL(new Tool().VERSION));
        url.append("&StringTemplateVersion=");
        url.append(XJUtils.encodeToURL("3.2.1"));
        url.append("&ANTLRWorksVersion=");
        url.append(XJUtils.encodeToURL(XJApplication.getAppVersionShort()));
        url.append("&OS=");
        url.append(XJUtils.encodeToURL(XJSystem.getOSName()));
        url.append("&JavaVersion=");
        url.append(XJUtils.encodeToURL(XJSystem.getJavaRuntimeVersion()));
        try {
            BrowserLauncher.openURL(url.toString());
        }
        catch (IOException e) {
            XJAlert.display(parent, "Error", "Cannot display the feedback page because:\n" + e + "\n\nTo report a feedback, go to " + url + ".");
        }
    }

    public static void checkUpdates(Container parent, boolean automatic) {
        String url = XJSystem.isMacOS() ? Localizable.getLocalizedString("UpdateOSXXMLURL") : Localizable.getLocalizedString("UpdateXMLURL");
        XJUpdateManager um = new XJUpdateManager(parent, null);
        um.checkForUpdates(Localizable.getLocalizedString("AppVersionShort"), url, AWPrefs.getDownloadPath(), automatic);
    }

    public static void checkUpdatesAuto(boolean atStartup) {
        int method = AWPrefs.getUpdateType();
        boolean check = false;
        if (method == 0) {
            check = false;
        } else if (method == 1 && atStartup) {
            check = true;
        } else {
            Calendar currentCalendar = Calendar.getInstance();
            Calendar nextUpdateCalendar = AWPrefs.getUpdateNextDate();
            if (nextUpdateCalendar == null || currentCalendar.equals(nextUpdateCalendar) || currentCalendar.after(nextUpdateCalendar)) {
                switch (method) {
                    case 2: {
                        check = nextUpdateCalendar != null;
                        currentCalendar.add(5, 1);
                        AWPrefs.setUpdateNextDate(currentCalendar);
                        break;
                    }
                    case 3: {
                        check = nextUpdateCalendar != null;
                        currentCalendar.add(5, 7);
                        AWPrefs.setUpdateNextDate(currentCalendar);
                    }
                }
            }
        }
        if (check) {
            HelpManager.checkUpdates(null, true);
        }
    }
}

