/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.antlr.works.utils.ToolTipListDelegate;

public class ToolTipList
extends JPanel {
    protected static final int VISIBLE_TIPS = 10;
    protected static final Color BACKGROUND_COLOR = new Color(1.0f, 1.0f, 0.6f, 0.8f);
    protected DefaultListModel tipsModel;
    protected JList tipsList;
    protected JScrollPane tipsScrollPane;
    protected ToolTipListDelegate delegate;

    public ToolTipList(ToolTipListDelegate delegate) {
        super(new BorderLayout());
        this.delegate = delegate;
        this.tipsModel = new DefaultListModel();
        this.tipsList = new JList(this.tipsModel);
        this.tipsList.setSelectionMode(0);
        this.tipsList.setBackground(BACKGROUND_COLOR);
        this.tipsList.setSelectionForeground(Color.black);
        this.tipsList.setSelectionBackground(BACKGROUND_COLOR);
        this.tipsList.setPrototypeCellValue("This is a rule name g");
        this.tipsList.addKeyListener(new MyListKeyAdapter());
        this.tipsList.setFocusable(false);
        this.tipsScrollPane = new JScrollPane(this.tipsList, 20, 31);
        this.tipsScrollPane.setFocusable(false);
        this.tipsScrollPane.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.addMouseListener(new MyMouseAdapter());
        this.add((Component)this.tipsScrollPane, "Center");
    }

    protected void notifyHide() {
        if (this.delegate != null) {
            this.delegate.toolTipListHide();
        }
    }

    public void clear() {
        this.tipsModel.clear();
    }

    public void setText(String text) {
        String[] lines = text.split("\n");
        this.clear();
        for (int index = 0; index < lines.length; ++index) {
            this.addLine(lines[index]);
        }
    }

    public void addLine(String text) {
        this.tipsModel.addElement(text);
    }

    public void selectFirstLine() {
        this.tipsList.setSelectedIndex(0);
    }

    public void resize() {
        int height = this.tipsList.getFixedCellHeight();
        int size = this.tipsModel.size();
        if (size > 0) {
            int width = 0;
            for (int i = 0; i < this.tipsModel.size(); ++i) {
                String e = (String)this.tipsModel.getElementAt(i);
                TextLayout layout = new TextLayout(e, this.tipsList.getFont(), ((Graphics2D)this.tipsList.getGraphics()).getFontRenderContext());
                width = Math.max(width, (int)layout.getBounds().getWidth());
            }
            height = height * Math.min(10, size) + 5;
            Dimension d = new Dimension(width + 10, height);
            this.setSize(d);
            this.tipsList.setSize(d);
            this.tipsScrollPane.setSize(d);
        }
    }

    protected class MyListKeyAdapter
    extends KeyAdapter {
        protected MyListKeyAdapter() {
        }

        public void selectNextListElement(int direction) {
            int index = ToolTipList.this.tipsList.getSelectedIndex();
            index += direction;
            index = Math.min(Math.max(0, index), ToolTipList.this.tipsModel.size() - 1);
            ToolTipList.this.tipsList.setSelectedIndex(index);
            ToolTipList.this.tipsList.scrollRectToVisible(ToolTipList.this.tipsList.getCellBounds(index, index));
        }

        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            switch (e.getKeyCode()) {
                case 10: 
                case 27: {
                    ToolTipList.this.notifyHide();
                    e.consume();
                    break;
                }
                case 38: {
                    this.selectNextListElement(-1);
                    e.consume();
                    break;
                }
                case 40: {
                    this.selectNextListElement(1);
                    e.consume();
                }
            }
        }
    }

    protected class MyMouseAdapter
    extends MouseAdapter {
        protected MyMouseAdapter() {
        }

        public void mouseEntered(MouseEvent e) {
            ToolTipList.this.notifyHide();
        }

        public void mousePressed(MouseEvent e) {
            ToolTipList.this.notifyHide();
        }
    }
}

