/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.foundation.XJXMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GElement
implements XJXMLSerializable {
    public static final String ANCHOR_CENTER = "CENTER";
    public static final String ANCHOR_TOP = "TOP";
    public static final String ANCHOR_BOTTOM = "BOTTOM";
    public static final String ANCHOR_LEFT = "LEFT";
    public static final String ANCHOR_RIGHT = "RIGHT";
    protected transient GView view = null;
    protected List<GElement> elements = new ArrayList<GElement>();
    protected Vector2D position = new Vector2D();
    protected transient Vector2D oldPosition = null;
    protected transient Map<String, Anchor2D> anchors = new HashMap<String, Anchor2D>();
    protected String label = null;
    protected Color labelColor = Color.black;
    protected boolean labelVisible = true;
    protected transient boolean selected = false;
    protected transient boolean focused = false;
    protected transient Color color = Color.black;
    protected transient int penSize = 1;
    protected transient BasicStroke strokeSize = new BasicStroke(this.penSize);
    protected transient BasicStroke strokeNormal = new BasicStroke(1.0f);
    protected transient BasicStroke strokeBold = new BasicStroke(3.0f);
    protected boolean draggable = false;
    protected final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPanel(GView view) {
        this.view = view;
        Object object = this.lock;
        synchronized (object) {
            for (GElement element : this.elements) {
                element.setPanel(view);
            }
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isLabelEqualsTo(String otherLabel) {
        if (this.label == null) {
            return otherLabel == null;
        }
        return this.label.equals(otherLabel);
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelVisible(boolean flag) {
        this.labelVisible = flag;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setPosition(double x, double y) {
        this.position.setX(x);
        this.position.setY(y);
        this.elementPositionDidChange();
    }

    public double getPositionX() {
        return this.position.getX();
    }

    public double getPositionY() {
        return this.position.getY();
    }

    public void setPosition(Vector2D position) {
        this.position = position;
        this.elementPositionDidChange();
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public void setElements(List<GElement> elements) {
        this.elements = elements;
    }

    public List<GElement> getElements() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(GElement element) {
        element.setPanel(this.view);
        Object object = this.lock;
        synchronized (object) {
            this.elements.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(GElement element) {
        Object object = this.lock;
        synchronized (object) {
            this.elements.remove(element);
        }
    }

    public GElement getFirstElement() {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(0);
    }

    public GElement getLastElement() {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public GElement findElementWithLabel(String label) {
        if (this.isLabelEqualsTo(label)) {
            return this;
        }
        if (this.elements == null) {
            return null;
        }
        for (GElement element : this.elements) {
            if (element.isLabelEqualsTo(label)) {
                return element;
            }
            if ((element = element.findElementWithLabel(label)) == null) continue;
            return element;
        }
        return null;
    }

    public void updateAnchors() {
    }

    public void setAnchor(String key, Vector2D position, Vector2D direction) {
        Anchor2D anchor = this.getAnchor(key);
        if (anchor == null) {
            anchor = new Anchor2D();
            this.anchors.put(key, anchor);
        }
        anchor.setPosition(position);
        anchor.setDirection(direction);
    }

    public double getDefaultAnchorOffset(String anchorKey) {
        return 0.0;
    }

    public Anchor2D getAnchor(String key) {
        return this.anchors.get(key);
    }

    public String getAnchorKeyClosestToPoint(Point p) {
        Anchor2D anchor = this.getAnchorClosestToPoint(p);
        for (String key : this.anchors.keySet()) {
            if (this.anchors.get(key) != anchor) continue;
            return key;
        }
        return null;
    }

    public Anchor2D getAnchorClosestToPoint(Point p) {
        double smallest_distance = 2.147483647E9;
        Anchor2D closest_anchor = null;
        for (Anchor2D anchor : this.anchors.values()) {
            double dy;
            double dx = anchor.position.getX() - (double)p.x;
            double d = Math.sqrt(dx * dx + (dy = anchor.position.getY() - (double)p.y) * dy);
            if (!(d < smallest_distance)) continue;
            smallest_distance = d;
            closest_anchor = anchor;
        }
        return closest_anchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rect bounds() {
        Rect r = this.getFrame();
        Object object = this.lock;
        synchronized (object) {
            for (GElement element : this.elements) {
                if (element == this) continue;
                if (r == null) {
                    r = element.bounds();
                    continue;
                }
                r = r.union(element.bounds());
            }
        }
        return r;
    }

    public Rect getFrame() {
        return null;
    }

    public void setFocused(boolean flag) {
        this.focused = flag;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setSelected(boolean flag) {
        this.selected = flag;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean acceptIncomingLink() {
        return false;
    }

    public boolean acceptOutgoingLink() {
        return false;
    }

    public void setDraggable(boolean flag) {
        this.draggable = flag;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPenSize(int size) {
        this.penSize = size;
        this.strokeSize = new BasicStroke(this.penSize);
    }

    public boolean isInside(Point p) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(double dx, double dy) {
        this.position.shift(dx, dy);
        Object object = this.lock;
        synchronized (object) {
            for (GElement element : this.elements) {
                element.move(dx, dy);
            }
        }
        this.elementPositionDidChange();
    }

    public void moveToPosition(Vector2D position) {
        double dx = position.x - this.getPosition().x;
        double dy = position.y - this.getPosition().y;
        this.move(dx, dy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GElement match(Point p) {
        Object object = this.lock;
        synchronized (object) {
            for (GElement element : this.elements) {
                GElement match = element.match(p);
                if (match == null) continue;
                return match;
            }
        }
        if (this.isInside(p)) {
            return this;
        }
        return null;
    }

    public void beginDrag() {
        this.oldPosition = null;
    }

    public Vector2D dragElementPosition(Vector2D p) {
        Vector2D ep = p.copy();
        if (this.oldPosition != null) {
            ep.x += p.x - this.oldPosition.x;
            ep.y += p.y - this.oldPosition.y;
        }
        return ep;
    }

    public void drag(Vector2D p) {
        double dx = 0.0;
        double dy = 0.0;
        if (this.oldPosition == null) {
            this.oldPosition = new Vector2D();
        } else {
            dx = p.x - this.oldPosition.x;
            dy = p.y - this.oldPosition.y;
        }
        this.oldPosition.x = p.x;
        this.oldPosition.y = p.y;
        this.move(dx, dy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRecursive(Graphics2D g) {
        Object object = this.lock;
        synchronized (object) {
            for (GElement element : this.elements) {
                element.drawRecursive(g);
            }
        }
        this.draw(g);
        if (this.isSelected()) {
            this.drawSelected(g);
        } else if (this.isFocused()) {
            this.drawFocused(g);
        }
    }

    public boolean isVisibleInClip(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return true;
        }
        Rectangle r = this.getFrame().rectangle();
        ++r.width;
        ++r.height;
        return clip.intersects(r);
    }

    public void draw(Graphics2D g) {
    }

    public void drawShape(Graphics2D g) {
    }

    private void drawSelected(Graphics2D g) {
        g.setComposite(AlphaComposite.getInstance(3, this.view.getSelectionAlphaValue()));
        g.setColor(Color.gray);
        g.setStroke(this.strokeBold);
        this.drawShape(g);
        g.setStroke(this.strokeNormal);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private void drawFocused(Graphics2D g) {
        g.setComposite(AlphaComposite.getInstance(3, this.view.getFocusAlphaValue()));
        g.setColor(Color.blue);
        g.setStroke(this.strokeBold);
        this.drawShape(g);
        g.setStroke(this.strokeNormal);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public void elementPositionDidChange() {
        this.updateAnchors();
    }

    public void elementDimensionDidChange() {
        this.updateAnchors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementDidLoad() {
        Object object = this.lock;
        synchronized (object) {
            for (GElement element : this.elements) {
                element.elementDidLoad();
            }
        }
        this.updateAnchors();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.position.x + "/" + this.position.y;
    }
}

