/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.utils;

import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GElementCircle;

public abstract class GDOTImporter {
    protected GElement graph;
    protected float height = 0.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GElement generateGraph(String dotFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(dotFile));
        try {
            int c;
            this.graph = null;
            StringBuilder line = new StringBuilder();
            int pc = -1;
            while ((c = br.read()) != -1) {
                if (c == 10) {
                    if (pc == 92) {
                        line.deleteCharAt(line.length() - 1);
                    } else {
                        GElement element = this.parseLine(line.toString());
                        if (element != null) {
                            if (this.graph == null) {
                                this.graph = element;
                            } else {
                                this.graph.addElement(element);
                            }
                        }
                        line.delete(0, line.length());
                    }
                } else if (c != 13) {
                    line.append((char)c);
                } else if (c == 13) continue;
                pc = c;
            }
        }
        finally {
            br.close();
        }
        return this.graph;
    }

    public String[] parseTokens(String line) throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(line));
        st.parseNumbers();
        st.wordChars(95, 95);
        int token = st.nextToken();
        while (token != -1) {
            String element = null;
            switch (token) {
                case -2: {
                    element = String.valueOf(st.nval);
                    break;
                }
                case -3: {
                    element = st.sval;
                    break;
                }
                case 34: 
                case 39: {
                    element = st.sval;
                    break;
                }
                case 10: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    element = String.valueOf((char)st.ttype);
                }
            }
            if (element != null) {
                tokens.add(element);
            }
            token = st.nextToken();
        }
        String[] result = new String[tokens.size()];
        for (int index = 0; index < tokens.size(); ++index) {
            result[index] = (String)tokens.get(index);
        }
        return result;
    }

    public abstract GElement parseLine(String var1) throws IOException;

    public abstract GElement createGraphNode(String[] var1) throws IOException;

    public abstract GElement createGraphEdge(String[] var1) throws IOException;

    public boolean isFloatString(String s) {
        try {
            Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static class StringTokenizer {
        public String s;
        public int position;

        public StringTokenizer(String s) {
            this.s = s;
            this.position = -1;
        }

        public String nextToken() {
            StringBuilder token = new StringBuilder();
            while (this.skipChar((char)this.getChar(1))) {
                this.nextChar();
            }
            while (this.nextChar()) {
                char c = this.getChar();
                if (c == '\"') {
                    token.append(this.parseString());
                    break;
                }
                if (this.isWordChar(c)) {
                    token.append(c);
                    continue;
                }
                if (token.length() == 0) {
                    token.append(c);
                    break;
                }
                --this.position;
                break;
            }
            if (token.length() == 0) {
                return null;
            }
            return token.toString();
        }

        public String parseString() {
            StringBuilder string = new StringBuilder();
            boolean escaping = false;
            while (this.nextChar()) {
                char c = this.getChar();
                if (c == '\\' && !escaping) {
                    escaping = true;
                    continue;
                }
                if (c == '\"' && !escaping) break;
                string.append(c);
                escaping = false;
            }
            return string.toString();
        }

        public boolean nextChar() {
            ++this.position;
            return this.position < this.s.length();
        }

        public char getChar() {
            return (char)this.getChar(0);
        }

        public int getChar(int offset) {
            int index = this.position + offset;
            if (index < this.s.length()) {
                return this.s.charAt(index);
            }
            return -1;
        }

        public boolean isWordChar(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '.';
        }

        public boolean skipChar(char c) {
            return c == ' ' || c == '\t';
        }
    }

    public static class Node
    extends GElementCircle {
        public boolean doublecircle;
        public float width;
        public float height;

        public void setDouble(boolean flag) {
            this.doublecircle = flag;
        }

        public void setSize(float width, float height) {
            this.width = width;
            this.height = height;
        }

        public void drawShape(Graphics2D g) {
            int x = (int)(this.getPositionX() - (double)(this.width / 2.0f));
            int y = (int)(this.getPositionY() - (double)(this.height / 2.0f));
            g.drawOval(x, y, (int)this.width, (int)this.height);
            if (this.doublecircle) {
                x = (int)(this.getPositionX() - (double)(this.width / 2.0f));
                y = (int)(this.getPositionY() - (double)(this.height / 2.0f));
                g.drawOval(x + 3, y + 3, (int)(this.width - 6.0f), (int)(this.height - 6.0f));
            }
        }
    }
}

