/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.utils.GDOTImporter;

public class GDOTImporterDOT
extends GDOTImporter {
    public static final int INCH_TO_PIXEL = 72;

    public GElement parseLine(String line) throws IOException {
        String[] tokens = this.parseTokens(line);
        if (tokens[0].equals("graph")) {
            this.parseGraphHeight(tokens);
        } else {
            if (tokens.length >= 2 && !tokens[0].equals("node") && tokens[1].equals("[")) {
                return this.createGraphNode(tokens);
            }
            if (tokens.length >= 3 && tokens[1].equals("-") && tokens[2].equals(">")) {
                return this.createGraphEdge(tokens);
            }
        }
        return null;
    }

    public void parseGraphHeight(String[] tokens) throws IOException {
        if (tokens[2].equals("bb")) {
            String[] t = this.parseTokens(tokens[4]);
            this.height = Float.parseFloat(t[6]);
        }
    }

    public GElement createGraphNode(String[] tokens) throws IOException {
        float x = 0.0f;
        float y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        boolean doublecircle = false;
        int index = 0;
        while (index < tokens.length - 1) {
            if (tokens[++index].equals("pos")) {
                String[] posTokens = this.parseTokens(tokens[index += 2]);
                x = Float.parseFloat(posTokens[0]);
                y = this.height - Float.parseFloat(posTokens[2]);
                continue;
            }
            if (tokens[index].equals("width")) {
                w = Float.parseFloat(tokens[index += 2]) * 72.0f;
                continue;
            }
            if (tokens[index].equals("height")) {
                h = Float.parseFloat(tokens[index += 2]) * 72.0f;
                continue;
            }
            if (!tokens[index].equals("shape")) continue;
            doublecircle = tokens[index += 2].equals("doublecircle");
        }
        GDOTImporter.Node node = new GDOTImporter.Node();
        node.setDraggable(true);
        node.setPosition(x, y);
        node.setSize(w, h);
        node.setRadius(w / 2.0f);
        node.setLabel(tokens[0]);
        node.setDouble(doublecircle);
        return node;
    }

    public GElement createGraphEdge(String[] tokens) throws IOException {
        String sourceName = tokens[0];
        String targetName = tokens[3];
        String labelName = null;
        Vector2D labelPosition = null;
        Vector2D[] points = null;
        int index = 4;
        while (index < tokens.length - 1) {
            if (tokens[++index].equals("label")) {
                labelName = tokens[index += 2];
                continue;
            }
            if (tokens[index].equals("lp")) {
                String[] lpos = this.parseTokens(tokens[index += 2]);
                labelPosition = new Vector2D(Float.parseFloat(lpos[0]), this.height - Float.parseFloat(lpos[2]));
                continue;
            }
            if (tokens[index].equals("pos")) {
                points = this.parseControlPoints(tokens[index += 2]);
                continue;
            }
            if (!tokens[index].equals(";")) continue;
        }
        GElement source = this.graph.findElementWithLabel(sourceName);
        GElement target = this.graph.findElementWithLabel(targetName);
        GLink link = new GLink(source, "CENTER", target, "CENTER", 2, labelName, 0.0);
        if (points == null) {
            System.err.println("No points for " + sourceName + ", " + targetName + ", " + tokens.length);
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                System.out.println(token);
            }
        }
        link.setBezierControlPoints(points);
        link.setBezierLabelPosition(labelPosition);
        return link;
    }

    public Vector2D[] parseControlPoints(String s) throws IOException {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        Vector2D endPoint = null;
        String[] pts = this.parseTokens(s);
        int index = -1;
        while (++index < pts.length) {
            String y;
            String x;
            if (pts[index].equals("e")) {
                if (index + 2 >= pts.length) {
                    System.err.println(String.format("Expected x arrow position at %d but reached the end at %d", index + 2, pts.length));
                    continue;
                }
                if (index + 4 >= pts.length) {
                    System.err.println(String.format("Expected y arrow position at %d but reached the end at %d", index + 4, pts.length));
                    continue;
                }
                x = pts[index += 2];
                y = pts[index += 2];
                endPoint = new Vector2D(Float.parseFloat(x), this.height - Float.parseFloat(y));
                continue;
            }
            if (!this.isFloatString(pts[index]) || index + 2 >= pts.length || !this.isFloatString(pts[index + 2])) continue;
            if (index + 2 >= pts.length) {
                System.err.println(String.format("Expected y position at %d but reached the end at %d", index + 2, pts.length));
                continue;
            }
            x = pts[index];
            y = pts[index += 2];
            points.add(new Vector2D(Float.parseFloat(x), this.height - Float.parseFloat(y)));
        }
        if (endPoint != null) {
            points.add(endPoint);
        }
        Vector2D[] p = new Vector2D[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            p[i] = (Vector2D)points.get(i);
        }
        return p;
    }
}

