/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.undo;

import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextPane;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;

public class XJUndoEngine {
    protected XJMainMenuBar mainMenuBar;
    protected Map<JTextPane, XJUndo> undos = new HashMap<JTextPane, XJUndo>();

    public void setMainMenuBar(XJMainMenuBar mainMenuBar) {
        this.mainMenuBar = mainMenuBar;
    }

    public void registerUndo(XJUndo undo, JTextPane component) {
        undo.bindTo(component);
        component.addFocusListener(new EditorFocusListener());
        this.undos.put(component, undo);
    }

    public void unregisterUndo(XJUndoDelegate delegate) {
        for (JTextPane tp : new HashSet<JTextPane>(this.undos.keySet())) {
            XJUndo undo = this.undos.get(tp);
            if (undo.delegate != delegate) continue;
            undo.close();
            this.undos.remove(tp);
            for (FocusListener fl : tp.getFocusListeners()) {
                tp.removeFocusListener(fl);
            }
        }
    }

    public XJUndo getCurrentUndo() {
        return this.undos.get(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner());
    }

    public XJUndo getUndo(Object object) {
        return this.undos.get(object);
    }

    public void updateUndoRedo(Object source) {
        XJUndo undo = this.getUndo(source);
        this.updateUndoRedo(undo);
    }

    public void updateUndoRedo(XJUndo undo) {
        if (this.mainMenuBar != null) {
            this.mainMenuBar.menuUndoRedoItemState(this.getCurrentUndo());
        }
    }

    public void undoStateDidChange(XJUndo undo) {
        this.updateUndoRedo(undo);
    }

    protected class EditorFocusListener
    implements FocusListener {
        protected EditorFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            XJUndoEngine.this.updateUndoRedo(event.getSource());
        }

        public void focusLost(FocusEvent event) {
            if (!event.isTemporary()) {
                XJUndoEngine.this.updateUndoRedo(null);
            }
        }
    }
}

