/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.utils;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.antlr.xjlib.appkit.gview.base.Vector2D;

public class XJSmoothScrolling
implements ActionListener {
    protected static final int steps = 10;
    protected JComponent c;
    protected Rectangle source;
    protected Rectangle dest;
    protected Vector2D v;
    protected int k;
    protected Timer timer;
    protected ScrollingDelegate delegate;

    public XJSmoothScrolling(JComponent c, ScrollingDelegate delegate) {
        this.c = c;
        this.delegate = delegate;
    }

    public synchronized void scrollTo(Rectangle dest) {
        this.dest = dest;
        this.computeSource();
        this.computeVector();
        if (this.c.getVisibleRect().intersects(dest)) {
            this.c.scrollRectToVisible(dest);
            this.completed();
        } else {
            this.startTimer();
        }
    }

    public synchronized void startTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(30, this);
        this.timer.start();
        this.k = 0;
    }

    public void completed() {
        if (this.delegate != null) {
            this.delegate.smoothScrollingDidComplete();
        }
    }

    public void computeVector() {
        this.v = new Vector2D(this.dest.x - this.source.x, this.dest.y - this.source.y);
    }

    public void computeSource() {
        Rectangle vr = this.c.getVisibleRect();
        this.source = new Rectangle(this.dest);
        if (this.source.x < vr.x) {
            this.source.x = vr.x;
        } else if (this.source.x > vr.x + vr.width) {
            this.source.x = vr.x + vr.width - this.source.width;
        }
        if (this.source.y < vr.y) {
            this.source.y = vr.y;
        } else if (this.source.y > vr.y + vr.height) {
            this.source.y = vr.y + vr.height - this.source.height;
        }
    }

    public void actionPerformed(ActionEvent e) {
        ++this.k;
        if (this.k > 10) {
            this.c.scrollRectToVisible(this.dest);
            this.timer.stop();
            this.timer = null;
            this.completed();
        } else {
            Rectangle current = new Rectangle(this.source);
            current.x = (int)((double)current.x + this.v.x * (double)this.k / 10.0);
            current.y = (int)((double)current.y + this.v.y * (double)this.k / 10.0);
            this.c.scrollRectToVisible(current);
        }
    }

    public static interface ScrollingDelegate {
        public void smoothScrollingDidComplete();
    }
}

