lexer grammar gUnit;
options {
  language=Java;

}
@header {package org.antlr.gunit;}

T22 : 'gunit' ;
T23 : 'walks' ;
T24 : ';' ;
T25 : '@header' ;
T26 : ':' ;
T27 : 'OK' ;
T28 : 'FAIL' ;
T29 : 'returns' ;
T30 : '->' ;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 90
SL_COMMENT
 	:	'//' ~('\r'|'\n')* '\r'? '\n' {$channel=HIDDEN;}
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 94
ML_COMMENT
	:	'/*' {$channel=HIDDEN;} .* '*/'
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 98
STRING	:	'"' (STRING_ESC|~('\\'|'"'))* '"' {setText(getText().substring(1, getText().length()-1));}
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 101
ML_STRING
	:	'<<' .* '>>' 
		{
		if ( getText().charAt(3)=='\n' && getText().charAt(getText().length()-3)=='\n' ) {
			setText(getText().substring(3, getText().length()-3));
		}
		else {
			setText(getText().substring(2, getText().length()-2));
		}
		}
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 113
fragment
STRING_ESC
	:	'\\"'
	|	'\\' ~'"'
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 119
ID	:	('a'..'z'|'A'..'Z'|'_')('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 121
EXT	:	'.'('a'..'z'|'A'..'Z'|'0'..'9')+;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 123
RETVAL	:	NESTED_RETVAL {setText(getText().substring(1, getText().length()-1));}
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 126
fragment
NESTED_RETVAL :
	'['
	(	options {greedy=false;}
	:	NESTED_RETVAL
	|	.
	)*
	']'
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 136
AST	:	NESTED_AST ;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 138
fragment
NESTED_AST :
	'('
	(	options {greedy=false;}
	:	NESTED_AST
	|	.
	)*
	')'
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 148
ACTION
	:	NESTED_ACTION {setText(getText().substring(1, getText().length()-1));}
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 152
fragment
NESTED_ACTION :
	'{'
	(	options {greedy=false; k=3;}
	:	NESTED_ACTION
	|	STRING_LITERAL
	|	CHAR_LITERAL
	|	.
	)*
	'}'
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 164
fragment
CHAR_LITERAL
	:	'\'' (ESC|~('\\'|'\'')) '\''
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 169
fragment
STRING_LITERAL
	:	'"' (ESC|~('\\'|'"'))+ '"'
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 174
fragment
ESC
	:	'\\\''
	|	'\\"'
	|	'\\' ~('\''|'"')
	;

// $ANTLR src "/Users/kenny/projects/personal/gunit.update/gunit/src/main/antlr/org/antlr/gunit/gUnit.g" 181
WS	:	(	' '
		|	'\t'
		|	'\r'? '\n'
		)+
		{$channel=HIDDEN;}
	;
