/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.antlr.gunit.Interp;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

public class JUnitCodeGen {
    public Interp interpreter;
    public Map<String, String> ruleWithReturn;

    public JUnitCodeGen(Interp interpreter) throws ClassNotFoundException {
        Method[] methods;
        this.interpreter = interpreter;
        this.ruleWithReturn = new HashMap<String, String>();
        Class<?> c = interpreter.header != null ? Class.forName(interpreter.header + "." + interpreter.grammarName + "Parser") : Class.forName(interpreter.grammarName + "Parser");
        for (Method method : methods = c.getDeclaredMethods()) {
            if (method.getReturnType().getName().equals("void")) continue;
            this.ruleWithReturn.put(method.getName(), method.getReturnType().getName().replace('$', '.'));
        }
    }

    public void compile() throws IOException {
        String junitFileName = this.interpreter.treeGrammarName != null ? "Test" + this.interpreter.treeGrammarName : "Test" + this.interpreter.grammarName;
        String lexerName = this.interpreter.grammarName + "Lexer";
        String parserName = this.interpreter.grammarName + "Parser";
        CommonGroupLoader loader = new CommonGroupLoader("org/antlr/gunit", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)loader);
        StringTemplateGroup.registerDefaultLexer(DefaultTemplateLexer.class);
        StringTemplateGroup group = StringTemplateGroup.loadGroup((String)"junit");
        StringBuffer buf = new StringBuffer();
        buf.append(this.genClassHeader(group, junitFileName));
        buf.append(this.genTestRuleMethods(group));
        buf.append(this.genSupportingMethods(group, lexerName, parserName));
        buf.append(group.getInstanceOf("examineParserExecResult").toString());
        buf.append("\n\n}");
        this.writeTestFile(".", junitFileName + ".java", buf.toString());
    }

    protected String genClassHeader(StringTemplateGroup group, String junitFileName) {
        StringTemplate classHeaderST = group.getInstanceOf("classHeader");
        if (this.interpreter.header != null) {
            classHeaderST.setAttribute("header", (Object)("package " + this.interpreter.header + ";"));
        }
        classHeaderST.setAttribute("junitFileName", (Object)junitFileName);
        return classHeaderST.toString();
    }

    protected String genTestRuleMethods(StringTemplateGroup group) {
        StringBuffer buf = new StringBuffer();
        if (this.interpreter.treeGrammarName != null) {
            for (gUnitTestSuite ts : this.interpreter.ruleTestSuites) {
                int i = 0;
                for (gUnitTestInput input : ts.testSuites.keySet()) {
                    String outputString;
                    String inputString;
                    StringTemplate testRuleMethodST;
                    ++i;
                    if (ts.testSuites.get(input).getType() == 6 && this.ruleWithReturn.containsKey(ts.treeRule)) {
                        testRuleMethodST = group.getInstanceOf("testTreeRuleMethod2");
                        inputString = input.testInput.replace("\n", "\\n").replace("\t", "\\t");
                        outputString = ts.testSuites.get(input).getText();
                        testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.treeRule) + "_walks_" + this.changeFirstCapital(ts.rule) + i));
                        testRuleMethodST.setAttribute("testTreeRuleName", (Object)('\"' + ts.treeRule + '\"'));
                        testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.rule + '\"'));
                        testRuleMethodST.setAttribute("testInput", (Object)('\"' + inputString + '\"'));
                        testRuleMethodST.setAttribute("returnType", (Object)this.ruleWithReturn.get(ts.treeRule));
                        testRuleMethodST.setAttribute("isFile", (Object)input.inputIsFile);
                        testRuleMethodST.setAttribute("expecting", (Object)outputString);
                    } else {
                        testRuleMethodST = group.getInstanceOf("testTreeRuleMethod");
                        inputString = input.testInput.replace("\n", "\\n").replace("\t", "\\t");
                        outputString = ts.testSuites.get(input).getText();
                        testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.treeRule) + "_walks_" + this.changeFirstCapital(ts.rule) + i));
                        testRuleMethodST.setAttribute("testTreeRuleName", (Object)('\"' + ts.treeRule + '\"'));
                        testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.rule + '\"'));
                        testRuleMethodST.setAttribute("testInput", (Object)('\"' + inputString + '\"'));
                        testRuleMethodST.setAttribute("isFile", (Object)input.inputIsFile);
                        testRuleMethodST.setAttribute("tokenType", ts.testSuites.get(input).getType());
                        if (ts.testSuites.get(input).getType() == 6) {
                            testRuleMethodST.setAttribute("expecting", (Object)outputString);
                        } else if (ts.testSuites.get(input).getType() == 7) {
                            testRuleMethodST.setAttribute("expecting", (Object)outputString);
                        } else {
                            testRuleMethodST.setAttribute("expecting", (Object)('\"' + outputString.replace("\n", "\\n") + '\"'));
                        }
                    }
                    buf.append(testRuleMethodST.toString());
                }
            }
        } else {
            for (gUnitTestSuite ts : this.interpreter.ruleTestSuites) {
                int i = 0;
                for (gUnitTestInput input : ts.testSuites.keySet()) {
                    String outputString;
                    String inputString;
                    StringTemplate testRuleMethodST;
                    ++i;
                    if (ts.testSuites.get(input).getType() == 6 && this.ruleWithReturn.containsKey(ts.rule)) {
                        testRuleMethodST = group.getInstanceOf("testRuleMethod2");
                        inputString = input.testInput.replace("\n", "\\n").replace("\t", "\\t");
                        outputString = ts.testSuites.get(input).getText();
                        testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.rule) + i));
                        testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.rule + '\"'));
                        testRuleMethodST.setAttribute("testInput", (Object)('\"' + inputString + '\"'));
                        testRuleMethodST.setAttribute("returnType", (Object)this.ruleWithReturn.get(ts.rule));
                        testRuleMethodST.setAttribute("isFile", (Object)input.inputIsFile);
                        testRuleMethodST.setAttribute("expecting", (Object)outputString);
                    } else {
                        testRuleMethodST = group.getInstanceOf("testRuleMethod");
                        inputString = input.testInput.replace("\n", "\\n").replace("\t", "\\t");
                        outputString = ts.testSuites.get(input).getText();
                        testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.rule) + i));
                        testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.rule + '\"'));
                        testRuleMethodST.setAttribute("testInput", (Object)('\"' + inputString + '\"'));
                        testRuleMethodST.setAttribute("isFile", (Object)input.inputIsFile);
                        testRuleMethodST.setAttribute("tokenType", ts.testSuites.get(input).getType());
                        if (ts.testSuites.get(input).getType() == 6) {
                            testRuleMethodST.setAttribute("expecting", (Object)outputString);
                        } else if (ts.testSuites.get(input).getType() == 7) {
                            testRuleMethodST.setAttribute("expecting", (Object)outputString);
                        } else {
                            testRuleMethodST.setAttribute("expecting", (Object)('\"' + outputString.replace("\n", "\\n") + '\"'));
                        }
                    }
                    buf.append(testRuleMethodST.toString());
                }
            }
        }
        return buf.toString();
    }

    protected String genSupportingMethods(StringTemplateGroup group, String lexerName, String parserName) {
        StringTemplate supportingMethodST;
        String treeParserPath;
        String parserPath;
        if (this.interpreter.header != null) {
            parserPath = this.interpreter.header + "." + parserName;
            treeParserPath = this.interpreter.header + "." + this.interpreter.treeGrammarName;
        } else {
            parserPath = parserName;
            treeParserPath = this.interpreter.treeGrammarName;
        }
        if (this.interpreter.treeGrammarName != null) {
            supportingMethodST = group.getInstanceOf("execTreeParser");
            supportingMethodST.setAttribute("treeParserName", (Object)this.interpreter.treeGrammarName);
            supportingMethodST.setAttribute("treeParserPath", (Object)treeParserPath);
        } else {
            supportingMethodST = group.getInstanceOf("execParser");
        }
        supportingMethodST.setAttribute("lexerName", (Object)lexerName);
        supportingMethodST.setAttribute("parserName", (Object)parserName);
        supportingMethodST.setAttribute("parserPath", (Object)parserPath);
        return supportingMethodST.toString();
    }

    protected void writeTestFile(String dir, String fileName, String content) {
        try {
            File f = new File(dir, fileName);
            FileWriter w = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(w);
            bw.write(content);
            bw.close();
            w.close();
        }
        catch (IOException ioe) {
            System.err.println("can't write file");
            ioe.printStackTrace(System.err);
        }
    }

    protected String changeFirstCapital(String ruleName) {
        String firstChar = String.valueOf(ruleName.charAt(0));
        ruleName = firstChar.toUpperCase() + ruleName.substring(1);
        return ruleName;
    }
}

