/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import org.antlr.gunit.JUnitCodeGen;
import org.antlr.gunit.gUnitTestResult;

public abstract class AbstractTest {
    protected String header;
    protected String actual;
    protected boolean hasErrorMsg;

    public abstract int getType();

    public abstract String getText();

    public abstract String getExpected();

    public String getExpectedResult() {
        String expected = this.getExpected();
        if (expected != null) {
            expected = JUnitCodeGen.escapeForJava(expected);
        }
        return expected;
    }

    public abstract String getResult(gUnitTestResult var1);

    public String getHeader() {
        return this.header;
    }

    public String getActual() {
        return this.actual;
    }

    public String getActualResult() {
        String actual = this.getActual();
        if (actual != null && !this.hasErrorMsg) {
            actual = JUnitCodeGen.escapeForJava(actual);
        }
        return actual;
    }

    public void setHeader(String rule, String lexicalRule, String treeRule, int numOfTest, int line) {
        StringBuffer buf = new StringBuffer();
        buf.append("test" + numOfTest + " (");
        if (treeRule != null) {
            buf.append(treeRule + " walks ");
        }
        if (lexicalRule != null) {
            buf.append(lexicalRule + ", line" + line + ")" + " - ");
        } else {
            buf.append(rule + ", line" + line + ")" + " - ");
        }
        this.header = buf.toString();
    }

    public void setActual(String actual) {
        this.actual = actual;
    }
}

