lexer grammar gUnit;
options {
  language=Java;

}

@header {
package org.antlr.gunit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
}

OK : 'OK' ;
FAIL : 'FAIL' ;
T__25 : 'gunit' ;
T__26 : 'walks' ;
T__27 : ';' ;
T__28 : '@header' ;
T__29 : ':' ;
T__30 : 'returns' ;
T__31 : '->' ;

// $ANTLR src "org/antlr/gunit/gUnit.g" 153
SL_COMMENT
 	:	'//' ~('\r'|'\n')* '\r'? '\n' {$channel=HIDDEN;}
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 157
ML_COMMENT
	:	'/*' {$channel=HIDDEN;} .* '*/'
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 161
STRING	:	'"' ( ESC | ~('\\'|'"') )* '"' {setText(getText().substring(1, getText().length()-1));}
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 164
ML_STRING
	:	{// we need to determine the number of spaces or tabs (indentation) for multi-line input
		StringBuffer buf = new StringBuffer();
		int i = -1;
		int c = input.LA(-1);
		while ( c==' ' || c=='\t' ) {
			buf.append((char)c);
			c = input.LA(--i);
		}
		String indentation = buf.reverse().toString();
		}
		'<<' .* '>>' 
		{// also determine the appropriate newline separator and get info of the first and last 2 characters (exclude '<<' and '>>')
		String newline = System.getProperty("line.separator");
		String front, end;
		int oldFrontIndex = 2;
		int oldEndIndex = getText().length()-2;
		int newFrontIndex, newEndIndex;
		if ( newline.length()==1 ) {
			front = getText().substring(2, 3);
			end = getText().substring(getText().length()-3, getText().length()-2);
			newFrontIndex = 3;
			newEndIndex = getText().length()-3;
		}
		else {// must be 2, e.g. Windows System which uses \r\n as a line separator
			front = getText().substring(2, 4);
			end = getText().substring(getText().length()-4, getText().length()-2);
			newFrontIndex = 4;
			newEndIndex = getText().length()-4;
		}
		// strip unwanted characters, e.g. '<<' (including a newline after it) or '>>'  (including a newline before it)
		String temp = null;
		if ( front.equals(newline) && end.equals(newline) ) {
			// need to handle the special case: <<\n>> or <<\r\n>>
			if ( newline.length()==1 && getText().length()==5 ) temp = "";
			else if ( newline.length()==2 && getText().length()==6 ) temp = "";
			else temp = getText().substring(newFrontIndex, newEndIndex);
		}
		else if ( front.equals(newline) ) {
			temp = getText().substring(newFrontIndex, oldEndIndex);
		}
		else if ( end.equals(newline) ) {
			temp = getText().substring(oldFrontIndex, newEndIndex);
		}
		else {
			temp = getText().substring(oldFrontIndex, oldEndIndex);
		}
		// finally we need to prpcess the indentation line by line
		BufferedReader bufReader = new BufferedReader(new StringReader(temp));
		buf = new StringBuffer();
		String line = null;
		int count = 0;
		try {
			while((line = bufReader.readLine()) != null) {
				if ( line.startsWith(indentation) ) line = line.substring(indentation.length());
				if ( count>0 ) buf.append(newline);
				buf.append(line);
				count++;
			}
			setText(buf.toString());
		}
		catch (IOException ioe) {
			setText(temp);
		}
		}
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 231
TOKEN_REF
	:	'A'..'Z' ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 235
RULE_REF
	:	'a'..'z' ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 239
EXT	:	'.'('a'..'z'|'A'..'Z'|'0'..'9')+;

// $ANTLR src "org/antlr/gunit/gUnit.g" 241
RETVAL	:	NESTED_RETVAL {setText(getText().substring(1, getText().length()-1));}
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 244
fragment
NESTED_RETVAL :
	'['
	(	options {greedy=false;}
	:	NESTED_RETVAL
	|	.
	)*
	']'
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 254
AST	:	NESTED_AST (' '? NESTED_AST)*;

// $ANTLR src "org/antlr/gunit/gUnit.g" 256
fragment
NESTED_AST :
	'('
	(	options {greedy=false;}
	:	NESTED_AST
	|	.
	)*
	')'
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 266
ACTION
	:	NESTED_ACTION {setText(getText().substring(1, getText().length()-1));}
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 270
fragment
NESTED_ACTION :
	'{'
	(	options {greedy=false; k=3;}
	:	NESTED_ACTION
	|	STRING_LITERAL
	|	CHAR_LITERAL
	|	.
	)*
	'}'
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 282
fragment
CHAR_LITERAL
	:	'\'' ( ESC | ~('\''|'\\') ) '\''
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 287
fragment
STRING_LITERAL
	:	'"' ( ESC | ~('\\'|'"') )* '"'
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 292
fragment
ESC	:	'\\'
		(	'n'
		|	'r'
		|	't'
		|	'b'
		|	'f'
		|	'"'
		|	'\''
		|	'\\'
		|	'>'
		|	'u' XDIGIT XDIGIT XDIGIT XDIGIT
		|	. // unknown, leave as it is
		)
	;
	
// $ANTLR src "org/antlr/gunit/gUnit.g" 308
fragment
XDIGIT :
		'0' .. '9'
	|	'a' .. 'f'
	|	'A' .. 'F'
	;

// $ANTLR src "org/antlr/gunit/gUnit.g" 315
WS	:	(	' '
		|	'\t'
		|	'\r'? '\n'
		)+
		{$channel=HIDDEN;}
	;
