/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.symtab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.symtab.MethodSymbol;
import org.antlr.symtab.Scope;
import org.antlr.symtab.Symbol;
import org.antlr.symtab.Utils;

public abstract class BaseScope
implements Scope {
    protected Scope enclosingScope;
    protected Map<String, Symbol> symbols = new LinkedHashMap<String, Symbol>();

    public BaseScope() {
    }

    public BaseScope(Scope enclosingScope) {
        this.setEnclosingScope(enclosingScope);
    }

    public Map<String, ? extends Symbol> getMembers() {
        return this.symbols;
    }

    @Override
    public Symbol getSymbol(String name) {
        return this.symbols.get(name);
    }

    @Override
    public void setEnclosingScope(Scope enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    @Override
    public List<Scope> getNestedScopedSymbols() {
        List<Symbol> scopes = Utils.filter(this.getSymbols(), s -> s instanceof Scope);
        return scopes;
    }

    @Override
    public Symbol resolve(String name) {
        Symbol s = this.symbols.get(name);
        if (s != null) {
            return s;
        }
        Scope parent = this.getParentScope();
        if (parent != null) {
            return parent.resolve(name);
        }
        return null;
    }

    @Override
    public void define(Symbol sym) throws IllegalArgumentException {
        if (this.symbols.containsKey(sym.getName())) {
            throw new IllegalArgumentException("duplicate symbol " + sym.getName());
        }
        sym.setScope(this);
        sym.setInsertionOrderNumber(this.symbols.size());
        this.symbols.put(sym.getName(), sym);
    }

    @Override
    public Scope getParentScope() {
        return this.getEnclosingScope();
    }

    @Override
    public List<Scope> getParentScopes() {
        return new ArrayList<Scope>(){
            {
                this.add(BaseScope.this.getParentScope());
            }
        };
    }

    @Override
    public Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    public Scope getOuterMostEnclosingScope() {
        Scope s = this;
        while (s.getEnclosingScope() != null) {
            s = s.getEnclosingScope();
        }
        return s;
    }

    public MethodSymbol getEnclosingScopeOfType(Class<?> type) {
        for (Scope s = this; s != null; s = s.getEnclosingScope()) {
            if (s.getClass() != type) continue;
            return (MethodSymbol)s;
        }
        return null;
    }

    @Override
    public List<Scope> getEnclosingPathToRoot() {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (Scope s = this; s != null; s = s.getEnclosingScope()) {
            scopes.add(s);
        }
        return scopes;
    }

    @Override
    public List<? extends Symbol> getSymbols() {
        Collection<Symbol> values = this.symbols.values();
        if (values instanceof List) {
            return (List)values;
        }
        return new ArrayList<Symbol>(values);
    }

    @Override
    public List<? extends Symbol> getAllSymbols() {
        ArrayList<Symbol> syms = new ArrayList<Symbol>();
        syms.addAll(this.getSymbols());
        for (Symbol s : this.symbols.values()) {
            if (!(s instanceof Scope)) continue;
            Scope scope = (Scope)((Object)s);
            syms.addAll(scope.getAllSymbols());
        }
        return syms;
    }

    @Override
    public int getNumberOfSymbols() {
        return this.symbols.size();
    }

    public List<Scope> getAllNestedScopes() {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        Utils.getAllNestedScopes(this, scopes);
        return scopes;
    }

    @Override
    public Set<String> getSymbolNames() {
        return this.symbols.keySet();
    }

    public String toString() {
        return this.symbols.keySet().toString();
    }

    public String toScopeStackString(String separator) {
        return Utils.toScopeStackString(this, separator);
    }

    @Override
    public String toQualifierString(String separator) {
        return Utils.toQualifierString(this, separator);
    }

    public String toTestString() {
        return this.toTestString(", ", ".");
    }

    public String toTestString(String separator, String scopePathSeparator) {
        List<? extends Symbol> allSymbols = this.getAllSymbols();
        List<String> syms = Utils.map(allSymbols, s -> s.getScope().getName() + scopePathSeparator + s.getName());
        return Utils.join(syms, separator);
    }
}

