/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.symtab;

import java.util.Collections;
import java.util.List;
import org.antlr.symtab.Scope;
import org.antlr.symtab.Symbol;
import org.antlr.symtab.Type;
import org.antlr.symtab.Utils;
import org.antlr.v4.runtime.ParserRuleContext;

public abstract class BaseSymbol
implements Symbol {
    protected final String name;
    protected Type type;
    protected Scope scope;
    protected ParserRuleContext defNode;
    protected int lexicalOrder;

    public BaseSymbol(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setDefNode(ParserRuleContext defNode) {
        this.defNode = defNode;
    }

    public ParserRuleContext getDefNode() {
        return this.defNode;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Symbol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.name.equals(((Symbol)obj).getName());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int getInsertionOrderNumber() {
        return this.lexicalOrder;
    }

    @Override
    public void setInsertionOrderNumber(int i) {
        this.lexicalOrder = i;
    }

    public String getFullyQualifiedName(String scopePathSeparator) {
        List<Scope> path = this.scope.getEnclosingPathToRoot();
        Collections.reverse(path);
        String qualifier = Utils.joinScopeNames(path, scopePathSeparator);
        return qualifier + scopePathSeparator + this.name;
    }

    public String toString() {
        String s = "";
        if (this.scope != null) {
            s = this.scope.getName() + ".";
        }
        if (this.type != null) {
            return '<' + s + this.getName() + "." + this.type + '>';
        }
        return s + this.getName();
    }
}

