/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.symtab;

import java.util.LinkedHashSet;
import java.util.Set;
import org.antlr.symtab.DataAggregateSymbol;
import org.antlr.symtab.MemberSymbol;
import org.antlr.symtab.MethodSymbol;
import org.antlr.symtab.Scope;
import org.antlr.symtab.Symbol;

public class ClassSymbol
extends DataAggregateSymbol {
    protected String superClassName;
    protected int nextFreeMethodSlot = 0;

    public ClassSymbol(String name) {
        super(name);
    }

    @Override
    public Scope getParentScope() {
        Symbol superClass;
        if (this.superClassName != null && this.getEnclosingScope() != null && (superClass = this.getEnclosingScope().resolve(this.superClassName)) instanceof ClassSymbol) {
            return (Scope)((Object)superClass);
        }
        return super.getEnclosingScope();
    }

    public MethodSymbol resolveMethod(String name) {
        Symbol sym = this.resolve(name);
        if (sym instanceof MethodSymbol) {
            return (MethodSymbol)sym;
        }
        return null;
    }

    public void setSuperClass(String superClassName) {
        this.superClassName = superClassName;
        this.nextFreeMethodSlot = this.getNumberOfMethods();
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public void setSlotNumber(Symbol sym) {
        if (sym instanceof MethodSymbol) {
            MethodSymbol superMethodSym;
            MethodSymbol msym = (MethodSymbol)sym;
            Scope parentScope = this.getParentScope();
            if (parentScope instanceof ClassSymbol && (superMethodSym = ((ClassSymbol)parentScope).resolveMethod(sym.getName())) != null) {
                msym.slot = superMethodSym.slot;
            }
            if (msym.slot == -1) {
                msym.slot = this.nextFreeMethodSlot++;
            }
        } else {
            super.setSlotNumber(sym);
        }
    }

    public Set<MethodSymbol> getDefinedMethods() {
        LinkedHashSet<MethodSymbol> methods = new LinkedHashSet<MethodSymbol>();
        for (MemberSymbol s : this.getSymbols()) {
            if (!(s instanceof MethodSymbol)) continue;
            methods.add((MethodSymbol)s);
        }
        return methods;
    }

    public Set<MethodSymbol> getMethods() {
        LinkedHashSet<MethodSymbol> methods = new LinkedHashSet<MethodSymbol>();
        if (this.getParentScope() instanceof ClassSymbol) {
            ClassSymbol parentScope = (ClassSymbol)this.getParentScope();
            methods.addAll(parentScope.getMethods());
        }
        methods.removeAll(this.getDefinedMethods());
        methods.addAll(this.getDefinedMethods());
        return methods;
    }

    public int getNumberOfDefinedMethods() {
        int n = 0;
        for (MemberSymbol s : this.getSymbols()) {
            if (!(s instanceof MethodSymbol)) continue;
            ++n;
        }
        return n;
    }

    public int getNumberOfMethods() {
        int n = 0;
        if (this.getParentScope() instanceof ClassSymbol) {
            ClassSymbol parentScope = (ClassSymbol)this.getParentScope();
            n += parentScope.getNumberOfMethods();
        }
        return n += this.getNumberOfDefinedMethods();
    }

    @Override
    public String toString() {
        return this.name + ":" + super.toString();
    }
}

