/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.symtab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.symtab.DataAggregateSymbol;
import org.antlr.symtab.FieldSymbol;
import org.antlr.symtab.MemberSymbol;
import org.antlr.symtab.MethodSymbol;
import org.antlr.symtab.Scope;
import org.antlr.symtab.Symbol;

public class ClassSymbol
extends DataAggregateSymbol {
    protected String superClassName;
    protected int nextFreeMethodSlot = 0;

    public ClassSymbol(String name) {
        super(name);
    }

    public ClassSymbol getSuperClassScope() {
        Symbol superClass;
        if (this.superClassName != null && this.getEnclosingScope() != null && (superClass = this.getEnclosingScope().resolve(this.superClassName)) instanceof ClassSymbol) {
            return (ClassSymbol)superClass;
        }
        return null;
    }

    public List<ClassSymbol> getSuperClassScopes() {
        ClassSymbol superClassScope = this.getSuperClassScope();
        if (superClassScope != null) {
            return Collections.singletonList(superClassScope);
        }
        return null;
    }

    @Override
    public Symbol resolve(String name) {
        Symbol s = this.resolveMember(name);
        if (s != null) {
            return s;
        }
        Scope parent = this.getEnclosingScope();
        if (parent != null) {
            return parent.resolve(name);
        }
        return null;
    }

    @Override
    public Symbol resolveMember(String name) {
        Symbol s = (Symbol)this.symbols.get(name);
        if (s instanceof MemberSymbol) {
            return s;
        }
        List<ClassSymbol> superClassScopes = this.getSuperClassScopes();
        if (superClassScopes != null) {
            for (ClassSymbol sup : superClassScopes) {
                s = sup.resolveMember(name);
                if (!(s instanceof MemberSymbol)) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    public Symbol resolveField(String name) {
        Symbol s = this.resolveMember(name);
        if (s instanceof FieldSymbol) {
            return s;
        }
        return null;
    }

    public MethodSymbol resolveMethod(String name) {
        Symbol s = this.resolveMember(name);
        if (s instanceof MethodSymbol) {
            return (MethodSymbol)s;
        }
        return null;
    }

    public void setSuperClass(String superClassName) {
        this.superClassName = superClassName;
        this.nextFreeMethodSlot = this.getNumberOfMethods();
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public void setSlotNumber(Symbol sym) {
        if (sym instanceof MethodSymbol) {
            MethodSymbol superMethodSym;
            MethodSymbol msym = (MethodSymbol)sym;
            ClassSymbol superClass = this.getSuperClassScope();
            if (superClass != null && (superMethodSym = superClass.resolveMethod(sym.getName())) != null) {
                msym.slot = superMethodSym.slot;
            }
            if (msym.slot == -1) {
                msym.slot = this.nextFreeMethodSlot++;
            }
        } else {
            super.setSlotNumber(sym);
        }
    }

    public Set<MethodSymbol> getDefinedMethods() {
        LinkedHashSet<MethodSymbol> methods = new LinkedHashSet<MethodSymbol>();
        for (MemberSymbol s : this.getSymbols()) {
            if (!(s instanceof MethodSymbol)) continue;
            methods.add((MethodSymbol)s);
        }
        return methods;
    }

    public Set<MethodSymbol> getMethods() {
        LinkedHashSet<MethodSymbol> methods = new LinkedHashSet<MethodSymbol>();
        ClassSymbol superClassScope = this.getSuperClassScope();
        if (superClassScope != null) {
            methods.addAll(superClassScope.getMethods());
        }
        methods.removeAll(this.getDefinedMethods());
        methods.addAll(this.getDefinedMethods());
        return methods;
    }

    @Override
    public List<? extends FieldSymbol> getFields() {
        ArrayList<FieldSymbol> fields = new ArrayList<FieldSymbol>();
        ClassSymbol superClassScope = this.getSuperClassScope();
        if (superClassScope != null) {
            fields.addAll(superClassScope.getFields());
        }
        fields.addAll(this.getDefinedFields());
        return fields;
    }

    public int getNumberOfDefinedMethods() {
        int n = 0;
        for (MemberSymbol s : this.getSymbols()) {
            if (!(s instanceof MethodSymbol)) continue;
            ++n;
        }
        return n;
    }

    public int getNumberOfMethods() {
        int n = 0;
        ClassSymbol superClassScope = this.getSuperClassScope();
        if (superClassScope != null) {
            n += superClassScope.getNumberOfMethods();
        }
        return n += this.getNumberOfDefinedMethods();
    }

    @Override
    public int getNumberOfFields() {
        int n = 0;
        ClassSymbol superClassScope = this.getSuperClassScope();
        if (superClassScope != null) {
            n += superClassScope.getNumberOfFields();
        }
        return n += this.getNumberOfDefinedFields();
    }

    @Override
    public String toString() {
        return this.name + ":" + super.toString();
    }
}

