/*
 * Copyright 2023 Douglas Hoard
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.antublue.map.accessor.function;

import java.lang.reflect.Constructor;
import java.util.function.Function;

@SuppressWarnings("PMD.PreserveStackTrace")
public final class ToInteger implements Function<Object, Integer> {

    public static final ToInteger INSTANCE = new ToInteger();

    private Class<? extends RuntimeException> clazz;
    private String message;

    private ToInteger() {
        // DO NOTHING
    }

    public ToInteger(Class<? extends RuntimeException> clazz, String message) {
        this();

        this.clazz = clazz;
        this.message = message;
    }

    @Override
    public Integer apply(Object value) {
        if (value == null) {
            return null;
        }

        if (value instanceof Integer) {
            return (Integer) value;
        }

        try {
            return Integer.parseInt(value.toString());
        } catch (NumberFormatException e) {
            if (clazz != null) {
                RuntimeException runtimeException;

                try {
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    runtimeException = (RuntimeException) constructor.newInstance(message);
                } catch (Throwable t) {
                    throw new RuntimeException(t);
                }

                throw runtimeException;
            }
        }

        throw new UnsupportedOperationException(
                String.format("Unsupported conversion [%s] to Integer", value));
    }
}
