/*
 * Copyright 2023 Douglas Hoard
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.antublue.map.accessor.util;

import java.util.function.Supplier;

public final class ThrowableSupplier implements Supplier<Throwable> {

    private final Throwable throwable;

    private ThrowableSupplier(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public Throwable get() {
        return throwable;
    }

    public static ThrowableSupplier of(Throwable throwable) {
        return new ThrowableSupplier(throwable);
    }
}
