/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class ToBoolean
implements Function<Object, Boolean> {
    public static final ToBoolean INSTANCE = new ToBoolean();
    private final Set<String> TRUE_SET = new HashSet<String>();
    private final Set<String> FALSE_SET = new HashSet<String>();
    private Class<? extends RuntimeException> clazz;
    private String message;

    private ToBoolean() {
        String trueString = "y|Y|yes|Yes|YES|true|True|TRUE|on|On|ON";
        String falseString = "n|N|no|No|NO|false|False|FALSE|off|Off|OFF";
        String[] tokens = trueString.split(Pattern.quote("|"));
        Collections.addAll(this.TRUE_SET, tokens);
        tokens = falseString.split(Pattern.quote("|"));
        Collections.addAll(this.FALSE_SET, tokens);
    }

    public ToBoolean(Class<? extends RuntimeException> clazz, String message) {
        this();
        this.clazz = clazz;
        this.message = message;
    }

    @Override
    public Boolean apply(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String string = value.toString();
        if (this.TRUE_SET.contains(string)) {
            return true;
        }
        if (this.FALSE_SET.contains(string)) {
            return false;
        }
        if (this.clazz != null) {
            RuntimeException runtimeException;
            try {
                Constructor<? extends RuntimeException> constructor = this.clazz.getConstructor(String.class);
                runtimeException = constructor.newInstance(this.message);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            throw runtimeException;
        }
        throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Boolean", string));
    }
}

