/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.antublue.map.accessor.org.joda.time.format.DateTimeFormat;
import org.antublue.map.accessor.org.joda.time.format.DateTimeFormatter;

public final class ToDate
implements Function<Object, Date> {
    public static final ToDate INSTANCE = new ToDate();
    private static final List<DateTimeFormatter> DATE_TIME_FORMATTER_LIST = new ArrayList<DateTimeFormatter>();
    private Class<? extends RuntimeException> clazz;
    private String message;

    private ToDate() {
    }

    public ToDate(Class<? extends RuntimeException> clazz, String message) {
        this();
        this.clazz = clazz;
        this.message = message;
    }

    @Override
    public Date apply(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            if (longValue < 0L) {
                throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Date", value));
            }
            return new Date(longValue);
        }
        String stringValue = value.toString();
        try {
            Long longValue = Long.parseLong(stringValue);
            if (longValue < 0L) {
                throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Date", value));
            }
            return new Date(longValue);
        }
        catch (NumberFormatException longValue) {
            for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTER_LIST) {
                try {
                    return dateTimeFormatter.parseDateTime(stringValue).toDate();
                }
                catch (Throwable throwable) {
                }
            }
            if (this.clazz != null) {
                RuntimeException runtimeException;
                try {
                    Constructor<? extends RuntimeException> constructor = this.clazz.getConstructor(String.class);
                    runtimeException = constructor.newInstance(this.message);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                throw runtimeException;
            }
            throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Date", value));
        }
    }

    static {
        DATE_TIME_FORMATTER_LIST.add(DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssSSSZ"));
        DATE_TIME_FORMATTER_LIST.add(DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssZ"));
        DATE_TIME_FORMATTER_LIST.add(DateTimeFormat.forPattern("yyyyMMdd'T'HHmmssSSSZ"));
        DATE_TIME_FORMATTER_LIST.add(DateTimeFormat.forPattern("yyyyMMdd'T'HHmmssZ"));
    }
}

