/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.lang.reflect.Constructor;
import java.util.function.Function;

public final class ToDouble
implements Function<Object, Double> {
    public static final ToDouble INSTANCE = new ToDouble();
    private Class<? extends RuntimeException> clazz;
    private String message;

    private ToDouble() {
    }

    public ToDouble(Class<? extends RuntimeException> clazz, String message) {
        this();
        this.clazz = clazz;
        this.message = message;
    }

    @Override
    public Double apply(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            if (this.clazz != null) {
                RuntimeException runtimeException;
                try {
                    Constructor<? extends RuntimeException> constructor = this.clazz.getConstructor(String.class);
                    runtimeException = constructor.newInstance(this.message);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                throw runtimeException;
            }
            throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Float", value));
        }
    }
}

