/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.lang.reflect.Constructor;
import java.util.function.Function;

public final class ToInteger
implements Function<Object, Integer> {
    public static final ToInteger INSTANCE = new ToInteger();
    private Class<? extends RuntimeException> clazz;
    private String message;

    private ToInteger() {
    }

    public ToInteger(Class<? extends RuntimeException> clazz, String message) {
        this();
        this.clazz = clazz;
        this.message = message;
    }

    @Override
    public Integer apply(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            if (this.clazz != null) {
                RuntimeException runtimeException;
                try {
                    Constructor<? extends RuntimeException> constructor = this.clazz.getConstructor(String.class);
                    runtimeException = constructor.newInstance(this.message);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                throw runtimeException;
            }
            throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Integer", value));
        }
    }
}

