/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.function.Function;

public final class ToLowerCase
implements Function<Object, String> {
    public static final ToLowerCase INSTANCE = new ToLowerCase(Locale.getDefault());
    private final Locale locale;
    private Class<? extends RuntimeException> clazz;
    private String message;

    private ToLowerCase(Locale locale) {
        this.locale = locale;
    }

    public ToLowerCase(Class<? extends RuntimeException> clazz, String message) {
        this(Locale.getDefault(), clazz, message);
    }

    public ToLowerCase(Locale locale, Class<? extends RuntimeException> clazz, String message) {
        this(locale);
        this.clazz = clazz;
        this.message = message;
    }

    @Override
    public String apply(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return ((String)value).toLowerCase(this.locale);
        }
        if (this.clazz != null) {
            RuntimeException runtimeException;
            try {
                Constructor<? extends RuntimeException> constructor = this.clazz.getConstructor(String.class);
                runtimeException = constructor.newInstance(this.message);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            throw runtimeException;
        }
        throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to String", value));
    }
}

