/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class MapAccessor {
    private final Map<String, Object> map;

    private MapAccessor(Map<String, Object> map) {
        this.map = map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public MapAccessor put(String path, boolean value) {
        this.putObject(path, value);
        return this;
    }

    public MapAccessor put(String path, short value) {
        this.putObject(path, value);
        return this;
    }

    public MapAccessor put(String path, int value) {
        this.putObject(path, value);
        return this;
    }

    public MapAccessor put(String path, float value) {
        this.putObject(path, Float.valueOf(value));
        return this;
    }

    public MapAccessor put(String path, String value) {
        this.putObject(path, value);
        return this;
    }

    public MapAccessor put(String path, Map<String, Object> value) {
        this.putObject(path, value);
        return this;
    }

    public MapAccessor put(String path, List<Object> value) {
        this.putObject(path, value);
        return this;
    }

    public Optional<Object> get(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        String pathTrimmed = path.trim();
        if (pathTrimmed.isEmpty()) {
            throw new IllegalArgumentException("Path is empty");
        }
        if ("/".equals(pathTrimmed)) {
            return Optional.of(this.map);
        }
        if (!pathTrimmed.startsWith("/") || pathTrimmed.endsWith("/")) {
            throw new IllegalArgumentException(String.format("Path [%s] is invalid", pathTrimmed));
        }
        Object object = null;
        String[] keys = pathTrimmed.split(Pattern.quote("/"));
        Map map = this.map;
        for (int i = 1; i < keys.length; ++i) {
            String key = keys[i];
            object = map.get(key);
            if (object == null) {
                return Optional.ofNullable(null);
            }
            if (object instanceof Map) {
                map = (Map)object;
                continue;
            }
            if (i >= keys.length - 1) continue;
            throw new UnsupportedOperationException(String.format("Path [%s] type [%s] can't be converted to Map", pathTrimmed, object.getClass()));
        }
        return Optional.of(object);
    }

    public Optional<Object> delete(String path) {
        LinkedHashMap object;
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        String pathTrimmed = path.trim();
        if ("/".equals(pathTrimmed)) {
            throw new IllegalArgumentException(String.format("Path [%s] is invalid", pathTrimmed));
        }
        if (!pathTrimmed.startsWith("/") || pathTrimmed.endsWith("/")) {
            throw new IllegalArgumentException(String.format("Path [%s] is invalid", pathTrimmed));
        }
        String key = pathTrimmed.substring(pathTrimmed.lastIndexOf("/") + 1);
        if (!"/".equals(pathTrimmed = pathTrimmed.substring(0, pathTrimmed.indexOf(key))) && pathTrimmed.endsWith("/")) {
            pathTrimmed = pathTrimmed.substring(0, pathTrimmed.length() - 1);
        }
        if (!((object = this.get(pathTrimmed).orElse(new LinkedHashMap())) instanceof Map)) {
            throw new UnsupportedOperationException(String.format("Path [%s] type [%s] can't be converted to a Map", pathTrimmed, object.getClass()));
        }
        return Optional.of(object);
    }

    public boolean containsPath(String path) {
        return this.get(path).isPresent();
    }

    public static MapAccessor of(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        Map<String, Object> treeMap = map;
        if (!(map instanceof TreeMap)) {
            treeMap = new TreeMap<String, Object>(map);
        }
        return new MapAccessor(treeMap);
    }

    private void putObject(String path, Object value) {
        if (!path.startsWith("/") || path.endsWith("/")) {
            throw new IllegalArgumentException(String.format("Path [%s] is invalid", path));
        }
        String[] keys = path.split(Pattern.quote("/"));
        LinkedHashMap<String, Object> map = this.map;
        for (int i = 1; i < keys.length - 1; ++i) {
            String key = keys[i];
            Object object = map.get(key);
            if (object == null) {
                LinkedHashMap<String, Object> childMap = new LinkedHashMap<String, Object>();
                map.put(key, childMap);
                map = childMap;
                continue;
            }
            if (object instanceof Map) {
                map = (LinkedHashMap<String, Object>)object;
                continue;
            }
            if (i >= keys.length - 1) continue;
            throw new UnsupportedOperationException(String.format("Path [%s] type [%s] can't be converted to a Map", path, object.getClass()));
        }
        map.put(keys[keys.length - 1], value);
    }

    private static String toString(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        while ((count = reader.read(buffer, 0, buffer.length)) != -1) {
            stringBuilder.append(buffer, 0, count);
        }
        return new String(buffer.toString().getBytes("UTF-8"));
    }
}

