/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.util.function.Function;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public final class ToDouble
implements Function<Object, Double> {
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public ToDouble() {
        this(null);
    }

    public ToDouble(RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
    }

    @Override
    public Double apply(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException e) {
            if (this.runtimeExceptionSupplier != null) {
                throw this.runtimeExceptionSupplier.get();
            }
            throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Float", object));
        }
    }
}

