/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.util.function.Function;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public final class ToFloat
implements Function<Object, Float> {
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public ToFloat() {
        this(null);
    }

    public ToFloat(RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
    }

    @Override
    public Float apply(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        try {
            return Float.valueOf(Float.parseFloat(object.toString()));
        }
        catch (NumberFormatException e) {
            if (this.runtimeExceptionSupplier != null) {
                throw this.runtimeExceptionSupplier.get();
            }
            throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Float", object));
        }
    }
}

